/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.pinot.common.config.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceStatus.class);
    public static String STATUS_DESCRIPTION_NONE = "None";
    public static String STATUS_DESCRIPTION_INIT = "Init";
    private static ServiceStatusCallback serviceStatusCallback = null;

    public static void setServiceStatusCallback(ServiceStatusCallback serviceStatusCallback) {
        ServiceStatus.serviceStatusCallback = serviceStatusCallback;
    }

    public static Status getServiceStatus() {
        if (serviceStatusCallback == null) {
            return Status.STARTING;
        }
        try {
            return serviceStatusCallback.getServiceStatus();
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while reading the service status", (Throwable)e);
            return Status.BAD;
        }
    }

    public static String getStatusDescription() {
        if (serviceStatusCallback == null) {
            return STATUS_DESCRIPTION_INIT;
        }
        try {
            return serviceStatusCallback.getStatusDescription();
        }
        catch (Exception e) {
            return "Exception: " + e.getMessage();
        }
    }

    public static class IdealStateAndExternalViewMatchServiceStatusCallback
    extends IdealStateMatchServiceStatusCallback<ExternalView> {
        public IdealStateAndExternalViewMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName) {
            super(helixManager, clusterName, instanceName);
        }

        public IdealStateAndExternalViewMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName, List<String> resourcesToMonitor) {
            super(helixManager, clusterName, instanceName, resourcesToMonitor);
        }

        @Override
        protected ExternalView getState(String resourceName) {
            return this._helixAdmin.getResourceExternalView(this._clusterName, resourceName);
        }

        @Override
        protected Map<String, String> getPartitionStateMap(ExternalView state) {
            HashMap<String, String> partitionState = new HashMap<String, String>();
            for (String partition : state.getPartitionSet()) {
                Map instanceStateMap = state.getStateMap(partition);
                if (!instanceStateMap.containsKey(this._instanceName)) continue;
                partitionState.put(partition, (String)instanceStateMap.get(this._instanceName));
            }
            return partitionState;
        }
    }

    public static class IdealStateAndCurrentStateMatchServiceStatusCallback
    extends IdealStateMatchServiceStatusCallback<CurrentState> {
        public IdealStateAndCurrentStateMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName) {
            super(helixManager, clusterName, instanceName);
        }

        public IdealStateAndCurrentStateMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName, List<String> resourcesToMonitor) {
            super(helixManager, clusterName, instanceName, resourcesToMonitor);
        }

        @Override
        protected CurrentState getState(String resourceName) {
            PropertyKey.Builder keyBuilder = this._helixDataAccessor.keyBuilder();
            LiveInstance liveInstance = (LiveInstance)this._helixDataAccessor.getProperty(keyBuilder.liveInstance(this._instanceName));
            String sessionId = liveInstance.getSessionId();
            return (CurrentState)this._helixDataAccessor.getProperty(keyBuilder.currentState(this._instanceName, sessionId, resourceName));
        }

        @Override
        protected Map<String, String> getPartitionStateMap(CurrentState state) {
            return state.getPartitionStateMap();
        }
    }

    private static abstract class IdealStateMatchServiceStatusCallback<T>
    implements ServiceStatusCallback {
        protected final String _clusterName;
        protected final String _instanceName;
        protected final HelixAdmin _helixAdmin;
        protected final HelixDataAccessor _helixDataAccessor;
        private final Set<String> _resourcesToMonitor;
        private final int _numTotalResourcesToMonitor;
        private String _statusDescription = STATUS_DESCRIPTION_INIT;

        public IdealStateMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName) {
            this._clusterName = clusterName;
            this._instanceName = instanceName;
            this._helixAdmin = helixManager.getClusterManagmentTool();
            this._helixDataAccessor = helixManager.getHelixDataAccessor();
            this._resourcesToMonitor = new HashSet<String>();
            block0: for (String resourceName : this._helixAdmin.getResourcesInCluster(this._clusterName)) {
                IdealState idealState;
                if (!TableNameBuilder.isTableResource(resourceName) && !resourceName.equals("brokerResource") || !(idealState = this.getResourceIdealState(resourceName)).isEnabled()) continue;
                for (String partitionName : idealState.getPartitionSet()) {
                    if (!idealState.getInstanceSet(partitionName).contains(this._instanceName)) continue;
                    this._resourcesToMonitor.add(resourceName);
                    continue block0;
                }
            }
            this._numTotalResourcesToMonitor = this._resourcesToMonitor.size();
            LOGGER.info("Monitoring {} resources: {} for start up of instance {}", new Object[]{this._numTotalResourcesToMonitor, this._resourcesToMonitor, this._instanceName});
        }

        public IdealStateMatchServiceStatusCallback(HelixManager helixManager, String clusterName, String instanceName, List<String> resourcesToMonitor) {
            this._clusterName = clusterName;
            this._instanceName = instanceName;
            this._helixAdmin = helixManager.getClusterManagmentTool();
            this._helixDataAccessor = helixManager.getHelixDataAccessor();
            this._resourcesToMonitor = new HashSet<String>(resourcesToMonitor);
            this._numTotalResourcesToMonitor = this._resourcesToMonitor.size();
            LOGGER.info("Monitoring {} resources: {} for start up of instance {}", new Object[]{this._numTotalResourcesToMonitor, this._resourcesToMonitor, this._instanceName});
        }

        protected abstract T getState(String var1);

        protected abstract Map<String, String> getPartitionStateMap(T var1);

        @Override
        public synchronized Status getServiceStatus() {
            if (this._resourcesToMonitor.isEmpty()) {
                return Status.GOOD;
            }
            Iterator<String> iterator = this._resourcesToMonitor.iterator();
            while (iterator.hasNext()) {
                String resourceName = iterator.next();
                IdealState idealState = this.getResourceIdealState(resourceName);
                if (idealState == null || !idealState.isEnabled()) {
                    iterator.remove();
                    continue;
                }
                String descriptionSuffix = String.format("resource=%s, numResourcesLeft=%d, numTotalResources=%d", resourceName, this._resourcesToMonitor.size(), this._numTotalResourcesToMonitor);
                T helixState = this.getState(resourceName);
                if (helixState == null) {
                    this._statusDescription = "Helix state does not exist: " + descriptionSuffix;
                    return Status.STARTING;
                }
                Map<String, String> partitionStateMap = this.getPartitionStateMap(helixState);
                for (String partitionName : idealState.getPartitionSet()) {
                    String currentStateStatus;
                    String idealStateStatus = (String)idealState.getInstanceStateMap(partitionName).get(this._instanceName);
                    if (idealStateStatus == null || "OFFLINE".equals(idealStateStatus) || idealStateStatus.equals(currentStateStatus = partitionStateMap.get(partitionName))) continue;
                    if ("ERROR".equals(currentStateStatus)) {
                        LOGGER.error(String.format("Resource: %s, partition: %s is in ERROR state", resourceName, partitionName));
                        continue;
                    }
                    this._statusDescription = String.format("partition=%s, idealStateStatus=%s, currentStateStatus=%s, %s", partitionName, idealStateStatus, currentStateStatus, descriptionSuffix);
                    return Status.STARTING;
                }
                iterator.remove();
            }
            LOGGER.info("Instance {} has finished starting up", (Object)this._instanceName);
            this._statusDescription = STATUS_DESCRIPTION_NONE;
            return Status.GOOD;
        }

        @Override
        public synchronized String getStatusDescription() {
            return this._statusDescription;
        }

        protected IdealState getResourceIdealState(String resourceName) {
            return this._helixAdmin.getResourceIdealState(this._clusterName, resourceName);
        }
    }

    public static class MultipleCallbackServiceStatusCallback
    implements ServiceStatusCallback {
        private final List<? extends ServiceStatusCallback> _statusCallbacks;

        public MultipleCallbackServiceStatusCallback(List<? extends ServiceStatusCallback> statusCallbacks) {
            this._statusCallbacks = statusCallbacks;
        }

        @Override
        public Status getServiceStatus() {
            for (ServiceStatusCallback serviceStatusCallback : this._statusCallbacks) {
                Status serviceStatus = serviceStatusCallback.getServiceStatus();
                if (serviceStatus == Status.GOOD) continue;
                return serviceStatus;
            }
            return Status.GOOD;
        }

        @Override
        public String getStatusDescription() {
            StringBuilder statusDescription = new StringBuilder();
            for (ServiceStatusCallback serviceStatusCallback : this._statusCallbacks) {
                statusDescription.append(serviceStatusCallback.getClass().getSimpleName()).append(":").append(serviceStatusCallback.getStatusDescription()).append(";");
            }
            return statusDescription.toString();
        }
    }

    public static interface ServiceStatusCallback {
        public Status getServiceStatus();

        public String getStatusDescription();
    }

    public static enum Status {
        STARTING,
        GOOD,
        BAD;

    }
}

