/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.$internal.com.google.common.collect.Lists;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.StringUtil;

public class FilterQueryTree {
    private final String column;
    private final List<String> value;
    private final FilterOperator operator;
    private final List<FilterQueryTree> children;

    public FilterQueryTree(String column, List<String> value, FilterOperator operator, List<FilterQueryTree> children) {
        this.column = column;
        this.value = value;
        this.operator = operator;
        this.children = children;
    }

    public String getColumn() {
        return this.column;
    }

    public List<String> getValue() {
        return this.value;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public List<FilterQueryTree> getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.recursiveToStringIntoBuffer(0, stringBuffer);
        return stringBuffer.toString();
    }

    private void recursiveToStringIntoBuffer(int indent, StringBuffer stringBuffer) {
        for (int i = 0; i < indent; ++i) {
            stringBuffer.append(' ');
        }
        if (this.operator == FilterOperator.OR || this.operator == FilterOperator.AND) {
            stringBuffer.append(this.operator);
        } else {
            ArrayList<String> sortedValues = new ArrayList<String>(this.value);
            if (sortedValues.size() == 1) {
                String firstItem = (String)sortedValues.get(0);
                ArrayList<String> firstItemValues = Lists.newArrayList(firstItem.split("\t\t"));
                Collections.sort(firstItemValues);
                sortedValues.set(0, StringUtil.join("\t\t", firstItemValues.toArray(new String[firstItemValues.size()])));
            }
            Collections.sort(sortedValues);
            stringBuffer.append(this.column).append(" ").append(this.operator).append(" ").append(sortedValues);
        }
        if (this.children != null) {
            for (FilterQueryTree child : this.children) {
                stringBuffer.append('\n');
                child.recursiveToStringIntoBuffer(indent + 1, stringBuffer);
            }
        }
    }
}

