/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.request;

import java.util.List;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.FilterOperator;
import org.apache.pinot.common.utils.request.QueryTree;

public class HavingQueryTree
extends QueryTree {
    final List<HavingQueryTree> _children;
    private final AggregationInfo _aggregationInfo;

    public HavingQueryTree(AggregationInfo aggregationInfo, List<String> value, FilterOperator operator, List<HavingQueryTree> children) {
        this._value = value;
        this._aggregationInfo = aggregationInfo;
        this._operator = operator;
        this._children = children;
    }

    public List<HavingQueryTree> getChildren() {
        return this._children;
    }

    public AggregationInfo getAggregationInfo() {
        return this._aggregationInfo;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.recursiveToStringIntoBuffer(0, stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    protected void recursiveToStringIntoBuffer(int indent, StringBuffer stringBuffer) {
        for (int i = 0; i < indent; ++i) {
            stringBuffer.append(' ');
        }
        if (this._operator == FilterOperator.OR || this._operator == FilterOperator.AND) {
            stringBuffer.append(this._operator);
        } else {
            stringBuffer.append(this._aggregationInfo.getAggregationType()).append("(").append(this._aggregationInfo.getAggregationParams().toString()).append(")").append(" ").append(this._operator).append(" ").append(this._value);
        }
        if (this._children != null) {
            for (QueryTree queryTree : this._children) {
                stringBuffer.append('\n');
                queryTree.recursiveToStringIntoBuffer(indent + 1, stringBuffer);
            }
        }
    }
}

