/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.realtime;

import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.pinot.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.$internal.org.apache.pinot.core.query.utils.Pair;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerLeaderLocator {
    private static ControllerLeaderLocator _instance = null;
    public static final Logger LOGGER = LoggerFactory.getLogger(ControllerLeaderLocator.class);
    private final HelixManager _helixManager;
    private final String _clusterName;
    private Pair<String, Integer> _controllerLeaderHostPort = null;
    private volatile boolean _cachedControllerLeaderInvalid = true;
    private volatile long _lastCacheInvalidateMillis = 0L;
    private static final long MILLIS_BETWEEN_INVALIDATE = 30000L;

    ControllerLeaderLocator(HelixManager helixManager) {
        this._helixManager = helixManager;
        this._clusterName = helixManager.getClusterName();
    }

    public static void create(HelixManager helixManager) {
        if (_instance != null) {
            LOGGER.warn("Already created");
            return;
        }
        _instance = new ControllerLeaderLocator(helixManager);
    }

    public static ControllerLeaderLocator getInstance() {
        if (_instance == null) {
            throw new RuntimeException("Not yet created");
        }
        return _instance;
    }

    public synchronized Pair<String, Integer> getControllerLeader() {
        if (!this._cachedControllerLeaderInvalid) {
            return this._controllerLeaderHostPort;
        }
        BaseDataAccessor dataAccessor = this._helixManager.getHelixDataAccessor().getBaseDataAccessor();
        Stat stat = new Stat();
        try {
            ZNRecord znRecord = (ZNRecord)dataAccessor.get("/" + this._clusterName + "/CONTROLLER/LEADER", stat, AccessOption.THROW_EXCEPTION_IFNOTEXIST);
            String leader = znRecord.getId();
            int index = leader.lastIndexOf(95);
            String leaderHost = leader.substring(0, index);
            int leaderPort = Integer.valueOf(leader.substring(index + 1));
            this._controllerLeaderHostPort = new Pair<String, Integer>(leaderHost, leaderPort);
            this._cachedControllerLeaderInvalid = false;
            LOGGER.info("Setting controller leader to be {}:{} as per znode version {}, mtime {}", new Object[]{leaderHost, leaderPort, stat.getVersion(), stat.getMtime()});
            return this._controllerLeaderHostPort;
        }
        catch (Exception e) {
            LOGGER.warn("Could not locate controller leader, exception", (Throwable)e);
            this._cachedControllerLeaderInvalid = true;
            return null;
        }
    }

    public synchronized void invalidateCachedControllerLeader() {
        long now = System.currentTimeMillis();
        long millisSinceLastInvalidate = now - this._lastCacheInvalidateMillis;
        if (millisSinceLastInvalidate < 30000L) {
            LOGGER.info("Millis since last controller cache value invalidate {} is less than allowed frequency {}. Skipping invalidate.", (Object)millisSinceLastInvalidate, (Object)30000L);
        } else {
            LOGGER.info("Invalidating cached controller leader value");
            this._cachedControllerLeaderInvalid = true;
            this._lastCacheInvalidateMillis = now;
        }
    }

    @VisibleForTesting
    protected boolean isCachedControllerLeaderInvalid() {
        return this._cachedControllerLeaderInvalid;
    }

    @VisibleForTesting
    protected long getLastCacheInvalidateMillis() {
        return this._lastCacheInvalidateMillis;
    }

    @VisibleForTesting
    protected long getMillisBetweenInvalidate() {
        return 30000L;
    }

    @VisibleForTesting
    protected void setLastCacheInvalidateMillis(long lastCacheInvalidateMillis) {
        this._lastCacheInvalidateMillis = lastCacheInvalidateMillis;
    }
}

