/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.startree.hll;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.$internal.com.google.common.base.Preconditions;
import org.apache.pinot.$internal.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.pinot.$internal.org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.pinot.common.config.ConfigKey;
import org.apache.pinot.common.utils.EqualityUtils;
import org.apache.pinot.common.utils.JsonUtils;
import org.apache.pinot.startree.hll.HllSizeUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HllConfig {
    @ConfigKey(value="hllLog2m")
    private int hllLog2m = 8;
    @ConfigKey(value="hllFieldSize")
    private int hllFieldSize = HllSizeUtils.getHllFieldSizeFromLog2m(8);
    @ConfigKey(value="hllDeriveColumnSuffix")
    private String hllDeriveColumnSuffix = "_hll";
    private Set<String> columnsToDeriveHllFields = new HashSet<String>();
    private transient Map<String, String> derivedHllFieldToOriginMap;

    public HllConfig() {
    }

    public HllConfig(int hllLog2m) {
        this.hllLog2m = hllLog2m;
    }

    public HllConfig(int hllLog2m, Set<String> columnsToDeriveHllFields, String hllDeriveColumnSuffix) {
        Preconditions.checkNotNull(columnsToDeriveHllFields, "ColumnsToDeriveHllFields should not be null.");
        Preconditions.checkNotNull(hllDeriveColumnSuffix, "HLL Derived Field Suffix should not be null.");
        this.hllLog2m = hllLog2m;
        this.hllFieldSize = HllSizeUtils.getHllFieldSizeFromLog2m(hllLog2m);
        this.hllDeriveColumnSuffix = hllDeriveColumnSuffix;
        this.columnsToDeriveHllFields = columnsToDeriveHllFields;
    }

    public int getHllLog2m() {
        return this.hllLog2m;
    }

    public void setHllLog2m(int hllLog2m) {
        this.hllLog2m = hllLog2m;
        this.hllFieldSize = HllSizeUtils.getHllFieldSizeFromLog2m(hllLog2m);
    }

    public String getHllDeriveColumnSuffix() {
        return this.hllDeriveColumnSuffix;
    }

    public void setHllDeriveColumnSuffix(String hllDeriveColumnSuffix) {
        this.hllDeriveColumnSuffix = hllDeriveColumnSuffix;
    }

    public Set<String> getColumnsToDeriveHllFields() {
        return this.columnsToDeriveHllFields;
    }

    public void setColumnsToDeriveHllFields(Set<String> columnsToDeriveHllFields) {
        this.columnsToDeriveHllFields = columnsToDeriveHllFields;
    }

    @JsonIgnore
    public boolean isEnableHllIndex() {
        return this.columnsToDeriveHllFields.size() > 0;
    }

    @JsonIgnore
    public int getHllFieldSize() {
        return this.hllFieldSize;
    }

    @JsonIgnore
    public Map<String, String> getDerivedHllFieldToOriginMap() {
        if (this.derivedHllFieldToOriginMap == null) {
            this.derivedHllFieldToOriginMap = new HashMap<String, String>();
            for (String columnName : this.columnsToDeriveHllFields) {
                this.derivedHllFieldToOriginMap.put(columnName + this.hllDeriveColumnSuffix, columnName);
            }
        }
        return this.derivedHllFieldToOriginMap;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String toJsonString() throws Exception {
        return JsonUtils.objectToPrettyString(this);
    }

    public static HllConfig fromJsonString(String jsonString) throws IOException {
        return JsonUtils.stringToObject(jsonString, HllConfig.class);
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        HllConfig hllConfig = (HllConfig)o;
        return EqualityUtils.isEqual(this.hllLog2m, hllConfig.hllLog2m) && EqualityUtils.isEqual(this.hllFieldSize, hllConfig.hllFieldSize) && EqualityUtils.isEqual(this.hllDeriveColumnSuffix, hllConfig.hllDeriveColumnSuffix) && EqualityUtils.isEqual(this.columnsToDeriveHllFields, hllConfig.columnsToDeriveHllFields) && EqualityUtils.isEqual(this.derivedHllFieldToOriginMap, hllConfig.derivedHllFieldToOriginMap);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this.hllLog2m);
        result = EqualityUtils.hashCodeOf(result, this.hllFieldSize);
        result = EqualityUtils.hashCodeOf(result, this.hllDeriveColumnSuffix);
        result = EqualityUtils.hashCodeOf(result, this.columnsToDeriveHllFields);
        result = EqualityUtils.hashCodeOf(result, this.derivedHllFieldToOriginMap);
        return result;
    }
}

