/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyType;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LeaderHistory;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.StatusUpdate;
import org.apache.helix.task.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyPathBuilder {
    private static Logger logger = LoggerFactory.getLogger(PropertyPathBuilder.class);
    static final Map<PropertyType, Map<Integer, String>> templateMap = new HashMap<PropertyType, Map<Integer, String>>();
    static final Map<PropertyType, Class<? extends HelixProperty>> typeToClassMapping = new HashMap<PropertyType, Class<? extends HelixProperty>>();
    static Pattern pattern;

    private static void addEntry(PropertyType type, int numKeys, String template) {
        if (!templateMap.containsKey((Object)type)) {
            templateMap.put(type, new HashMap());
        }
        logger.trace("Adding template for type:" + (Object)((Object)type.getType()) + " arguments:" + numKeys + " template:" + template);
        templateMap.get((Object)type).put(numKeys, template);
    }

    public static String getPath(PropertyType type, String clusterName, String ... keys) {
        if (clusterName == null) {
            logger.warn("ClusterName can't be null for type:" + (Object)((Object)type));
            return null;
        }
        if (keys == null) {
            keys = new String[]{};
        }
        String template = null;
        if (templateMap.containsKey((Object)type)) {
            template = templateMap.get((Object)type).get(keys.length + 1);
        }
        String result = null;
        if (template != null) {
            result = template;
            Matcher matcher = pattern.matcher(template);
            int count = 0;
            while (matcher.find()) {
                String var = matcher.group();
                if (++count == 1) {
                    result = result.replace(var, clusterName);
                    continue;
                }
                result = result.replace(var, keys[count - 2]);
            }
        }
        if (result == null || result.indexOf(123) > -1 || result.indexOf(125) > -1) {
            logger.warn("Unable to instantiate template:" + template + " using clusterName:" + clusterName + " and keys:" + Arrays.toString(keys));
        }
        return result;
    }

    public static String getInstanceNameFromPath(String path) {
        String[] split;
        if (path.contains("/" + (Object)((Object)PropertyType.INSTANCES) + "/") && (split = path.split("\\/")).length > 3) {
            return split[3];
        }
        return null;
    }

    public static String idealState(String clusterName) {
        return String.format("/%s/IDEALSTATES", clusterName);
    }

    public static String idealState(String clusterName, String resourceName) {
        return String.format("/%s/IDEALSTATES/%s", clusterName, resourceName);
    }

    public static String stateModelDef(String clusterName) {
        return String.format("/%s/STATEMODELDEFS", clusterName);
    }

    public static String stateModelDef(String clusterName, String stateModelName) {
        return String.format("/%s/STATEMODELDEFS/%s", clusterName, stateModelName);
    }

    public static String externalView(String clusterName) {
        return String.format("/%s/EXTERNALVIEW", clusterName);
    }

    public static String externalView(String clusterName, String resourceName) {
        return String.format("/%s/EXTERNALVIEW/%s", clusterName, resourceName);
    }

    public static String targetExternalView(String clusterName) {
        return String.format("/%s/TARGETEXTERNALVIEW", clusterName);
    }

    public static String targetExternalView(String clusterName, String resourceName) {
        return String.format("/%s/TARGETEXTERNALVIEW/%s", clusterName, resourceName);
    }

    public static String liveInstance(String clusterName) {
        return String.format("/%s/LIVEINSTANCES", clusterName);
    }

    public static String liveInstance(String clusterName, String instanceName) {
        return String.format("/%s/LIVEINSTANCES/%s", clusterName, instanceName);
    }

    public static String instance(String clusterName) {
        return String.format("/%s/INSTANCES", clusterName);
    }

    @Deprecated
    public static String instanceProperty(String clusterName, String instanceName, PropertyType type, String key) {
        return String.format("/%s/INSTANCES/%s/%s/%s", new Object[]{clusterName, instanceName, type, key});
    }

    public static String instance(String clusterName, String instanceName) {
        return String.format("/%s/INSTANCES/%s", clusterName, instanceName);
    }

    public static String instanceMessage(String clusterName, String instanceName) {
        return String.format("/%s/INSTANCES/%s/MESSAGES", clusterName, instanceName);
    }

    public static String instanceMessage(String clusterName, String instanceName, String messageId) {
        return String.format("/%s/INSTANCES/%s/MESSAGES/%s", clusterName, instanceName, messageId);
    }

    public static String instanceCurrentState(String clusterName, String instanceName) {
        return String.format("/%s/INSTANCES/%s/CURRENTSTATES", clusterName, instanceName);
    }

    public static String instanceCurrentState(String clusterName, String instanceName, String sessionId) {
        return String.format("/%s/INSTANCES/%s/CURRENTSTATES/%s", clusterName, instanceName, sessionId);
    }

    public static String instanceCurrentState(String clusterName, String instanceName, String sessionId, String resourceName) {
        return String.format("/%s/INSTANCES/%s/CURRENTSTATES/%s/%s", clusterName, instanceName, sessionId, resourceName);
    }

    public static String instanceError(String clusterName, String instanceName) {
        return String.format("/%s/INSTANCES/%s/ERRORS", clusterName, instanceName);
    }

    public static String instanceError(String clusterName, String instanceName, String sessionId, String resourceName, String partitionName) {
        return String.format("/%s/INSTANCES/%s/ERRORS/%s/%s/%s", clusterName, instanceName, sessionId, resourceName, partitionName);
    }

    public static String instanceHistory(String clusterName, String instanceName) {
        return String.format("/%s/INSTANCES/%s/HISTORY", clusterName, instanceName);
    }

    public static String instanceStatusUpdate(String clusterName, String instanceName) {
        return String.format("/%s/INSTANCES/%s/STATUSUPDATES", clusterName, instanceName);
    }

    public static String propertyStore(String clusterName) {
        return String.format("/%s/PROPERTYSTORE", clusterName);
    }

    public static String clusterConfig(String clusterName) {
        return String.format("/%s/CONFIGS/CLUSTER/%s", clusterName, clusterName);
    }

    public static String instanceConfig(String clusterName) {
        return String.format("/%s/CONFIGS/PARTICIPANT", clusterName);
    }

    public static String instanceConfig(String clusterName, String instanceName) {
        return String.format("/%s/CONFIGS/PARTICIPANT/%s", clusterName, instanceName);
    }

    public static String resourceConfig(String clusterName) {
        return String.format("/%s/CONFIGS/RESOURCE", clusterName);
    }

    public static String controller(String clusterName) {
        return String.format("/%s/CONTROLLER", clusterName);
    }

    public static String controllerLeader(String clusterName) {
        return String.format("/%s/CONTROLLER/LEADER", clusterName);
    }

    public static String controllerMessage(String clusterName) {
        return String.format("/%s/CONTROLLER/MESSAGES", clusterName);
    }

    public static String controllerMessage(String clusterName, String messageId) {
        return String.format("/%s/CONTROLLER/MESSAGES/%s", clusterName, messageId);
    }

    public static String controllerStatusUpdate(String clusterName) {
        return String.format("/%s/CONTROLLER/STATUSUPDATES", clusterName);
    }

    public static String controllerStatusUpdate(String clusterName, String subPath, String recordName) {
        return String.format("/%s/CONTROLLER/STATUSUPDATES/%s/%s", clusterName, subPath, recordName);
    }

    public static String controllerError(String clusterName) {
        return String.format("/%s/CONTROLLER/ERRORS", clusterName);
    }

    public static String controllerHistory(String clusterName) {
        return String.format("/%s/CONTROLLER/HISTORY", clusterName);
    }

    public static String pause(String clusterName) {
        return String.format("/%s/CONTROLLER/PAUSE", clusterName);
    }

    public static String maintenance(String clusterName) {
        return String.format("/%s/CONTROLLER/MAINTENANCE", clusterName);
    }

    static {
        typeToClassMapping.put(PropertyType.LIVEINSTANCES, LiveInstance.class);
        typeToClassMapping.put(PropertyType.IDEALSTATES, IdealState.class);
        typeToClassMapping.put(PropertyType.CONFIGS, InstanceConfig.class);
        typeToClassMapping.put(PropertyType.EXTERNALVIEW, ExternalView.class);
        typeToClassMapping.put(PropertyType.STATEMODELDEFS, StateModelDefinition.class);
        typeToClassMapping.put(PropertyType.MESSAGES, Message.class);
        typeToClassMapping.put(PropertyType.CURRENTSTATES, CurrentState.class);
        typeToClassMapping.put(PropertyType.STATUSUPDATES, StatusUpdate.class);
        typeToClassMapping.put(PropertyType.HISTORY, LeaderHistory.class);
        typeToClassMapping.put(PropertyType.PAUSE, PauseSignal.class);
        typeToClassMapping.put(PropertyType.MAINTENANCE, MaintenanceSignal.class);
        typeToClassMapping.put(PropertyType.WORKFLOWCONTEXT, WorkflowContext.class);
        PropertyPathBuilder.addEntry(PropertyType.CONFIGS, 1, "/{clusterName}/CONFIGS");
        PropertyPathBuilder.addEntry(PropertyType.CONFIGS, 2, "/{clusterName}/CONFIGS/{scope}");
        PropertyPathBuilder.addEntry(PropertyType.CONFIGS, 3, "/{clusterName}/CONFIGS/{scope}/{scopeKey}");
        PropertyPathBuilder.addEntry(PropertyType.LIVEINSTANCES, 1, "/{clusterName}/LIVEINSTANCES");
        PropertyPathBuilder.addEntry(PropertyType.LIVEINSTANCES, 2, "/{clusterName}/LIVEINSTANCES/{instanceName}");
        PropertyPathBuilder.addEntry(PropertyType.INSTANCES, 1, "/{clusterName}/INSTANCES");
        PropertyPathBuilder.addEntry(PropertyType.INSTANCES, 2, "/{clusterName}/INSTANCES/{instanceName}");
        PropertyPathBuilder.addEntry(PropertyType.IDEALSTATES, 1, "/{clusterName}/IDEALSTATES");
        PropertyPathBuilder.addEntry(PropertyType.IDEALSTATES, 2, "/{clusterName}/IDEALSTATES/{resourceName}");
        PropertyPathBuilder.addEntry(PropertyType.EXTERNALVIEW, 1, "/{clusterName}/EXTERNALVIEW");
        PropertyPathBuilder.addEntry(PropertyType.EXTERNALVIEW, 2, "/{clusterName}/EXTERNALVIEW/{resourceName}");
        PropertyPathBuilder.addEntry(PropertyType.TARGETEXTERNALVIEW, 1, "/{clusterName}/TARGETEXTERNALVIEW");
        PropertyPathBuilder.addEntry(PropertyType.TARGETEXTERNALVIEW, 2, "/{clusterName}/TARGETEXTERNALVIEW/{resourceName}");
        PropertyPathBuilder.addEntry(PropertyType.STATEMODELDEFS, 1, "/{clusterName}/STATEMODELDEFS");
        PropertyPathBuilder.addEntry(PropertyType.STATEMODELDEFS, 2, "/{clusterName}/STATEMODELDEFS/{stateModelName}");
        PropertyPathBuilder.addEntry(PropertyType.CONTROLLER, 1, "/{clusterName}/CONTROLLER");
        PropertyPathBuilder.addEntry(PropertyType.PROPERTYSTORE, 1, "/{clusterName}/PROPERTYSTORE");
        PropertyPathBuilder.addEntry(PropertyType.MESSAGES, 2, "/{clusterName}/INSTANCES/{instanceName}/MESSAGES");
        PropertyPathBuilder.addEntry(PropertyType.MESSAGES, 3, "/{clusterName}/INSTANCES/{instanceName}/MESSAGES/{msgId}");
        PropertyPathBuilder.addEntry(PropertyType.CURRENTSTATES, 2, "/{clusterName}/INSTANCES/{instanceName}/CURRENTSTATES");
        PropertyPathBuilder.addEntry(PropertyType.CURRENTSTATES, 3, "/{clusterName}/INSTANCES/{instanceName}/CURRENTSTATES/{sessionId}");
        PropertyPathBuilder.addEntry(PropertyType.CURRENTSTATES, 4, "/{clusterName}/INSTANCES/{instanceName}/CURRENTSTATES/{sessionId}/{resourceName}");
        PropertyPathBuilder.addEntry(PropertyType.CURRENTSTATES, 5, "/{clusterName}/INSTANCES/{instanceName}/CURRENTSTATES/{sessionId}/{resourceName}/{bucketName}");
        PropertyPathBuilder.addEntry(PropertyType.STATUSUPDATES, 2, "/{clusterName}/INSTANCES/{instanceName}/STATUSUPDATES");
        PropertyPathBuilder.addEntry(PropertyType.STATUSUPDATES, 3, "/{clusterName}/INSTANCES/{instanceName}/STATUSUPDATES/{sessionId}");
        PropertyPathBuilder.addEntry(PropertyType.STATUSUPDATES, 4, "/{clusterName}/INSTANCES/{instanceName}/STATUSUPDATES/{sessionId}/{subPath}");
        PropertyPathBuilder.addEntry(PropertyType.STATUSUPDATES, 5, "/{clusterName}/INSTANCES/{instanceName}/STATUSUPDATES/{sessionId}/{subPath}/{recordName}");
        PropertyPathBuilder.addEntry(PropertyType.ERRORS, 2, "/{clusterName}/INSTANCES/{instanceName}/ERRORS");
        PropertyPathBuilder.addEntry(PropertyType.ERRORS, 3, "/{clusterName}/INSTANCES/{instanceName}/ERRORS/{sessionId}");
        PropertyPathBuilder.addEntry(PropertyType.ERRORS, 4, "/{clusterName}/INSTANCES/{instanceName}/ERRORS/{sessionId}/{subPath}");
        PropertyPathBuilder.addEntry(PropertyType.ERRORS, 5, "/{clusterName}/INSTANCES/{instanceName}/ERRORS/{sessionId}/{subPath}/{recordName}");
        PropertyPathBuilder.addEntry(PropertyType.INSTANCE_HISTORY, 2, "/{clusterName}/INSTANCES/{instanceName}/HISTORY");
        PropertyPathBuilder.addEntry(PropertyType.HEALTHREPORT, 2, "/{clusterName}/INSTANCES/{instanceName}/HEALTHREPORT");
        PropertyPathBuilder.addEntry(PropertyType.HEALTHREPORT, 3, "/{clusterName}/INSTANCES/{instanceName}/HEALTHREPORT/{reportName}");
        PropertyPathBuilder.addEntry(PropertyType.MESSAGES_CONTROLLER, 1, "/{clusterName}/CONTROLLER/MESSAGES");
        PropertyPathBuilder.addEntry(PropertyType.MESSAGES_CONTROLLER, 2, "/{clusterName}/CONTROLLER/MESSAGES/{msgId}");
        PropertyPathBuilder.addEntry(PropertyType.ERRORS_CONTROLLER, 1, "/{clusterName}/CONTROLLER/ERRORS");
        PropertyPathBuilder.addEntry(PropertyType.ERRORS_CONTROLLER, 2, "/{clusterName}/CONTROLLER/ERRORS/{errorId}");
        PropertyPathBuilder.addEntry(PropertyType.STATUSUPDATES_CONTROLLER, 1, "/{clusterName}/CONTROLLER/STATUSUPDATES");
        PropertyPathBuilder.addEntry(PropertyType.STATUSUPDATES_CONTROLLER, 2, "/{clusterName}/CONTROLLER/STATUSUPDATES/{subPath}");
        PropertyPathBuilder.addEntry(PropertyType.STATUSUPDATES_CONTROLLER, 3, "/{clusterName}/CONTROLLER/STATUSUPDATES/{subPath}/{recordName}");
        PropertyPathBuilder.addEntry(PropertyType.LEADER, 1, "/{clusterName}/CONTROLLER/LEADER");
        PropertyPathBuilder.addEntry(PropertyType.HISTORY, 1, "/{clusterName}/CONTROLLER/HISTORY");
        PropertyPathBuilder.addEntry(PropertyType.PAUSE, 1, "/{clusterName}/CONTROLLER/PAUSE");
        PropertyPathBuilder.addEntry(PropertyType.MAINTENANCE, 1, "/{clusterName}/CONTROLLER/MAINTENANCE");
        PropertyPathBuilder.addEntry(PropertyType.WORKFLOWCONTEXT, 2, "/{clusterName}/PROPERTYSTORE/TaskRebalancer/{workflowName}/Context");
        pattern = Pattern.compile("(\\{.+?\\})");
    }
}

