/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.api.exceptions.HelixMetaDataAccessException;
import org.apache.helix.api.listeners.ClusterConfigChangeListener;
import org.apache.helix.api.listeners.ControllerChangeListener;
import org.apache.helix.api.listeners.CurrentStateChangeListener;
import org.apache.helix.api.listeners.IdealStateChangeListener;
import org.apache.helix.api.listeners.InstanceConfigChangeListener;
import org.apache.helix.api.listeners.LiveInstanceChangeListener;
import org.apache.helix.api.listeners.MessageListener;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.api.listeners.ResourceConfigChangeListener;
import org.apache.helix.common.ClusterEventBlockingQueue;
import org.apache.helix.common.DedupEventProcessor;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.controller.pipeline.PipelineRegistry;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateCalcStage;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ClusterEventType;
import org.apache.helix.controller.stages.CompatibilityCheckStage;
import org.apache.helix.controller.stages.CurrentStateComputationStage;
import org.apache.helix.controller.stages.ExternalViewComputeStage;
import org.apache.helix.controller.stages.IntermediateStateCalcStage;
import org.apache.helix.controller.stages.MessageGenerationPhase;
import org.apache.helix.controller.stages.MessageSelectionStage;
import org.apache.helix.controller.stages.MessageThrottleStage;
import org.apache.helix.controller.stages.PersistAssignmentStage;
import org.apache.helix.controller.stages.ReadClusterDataStage;
import org.apache.helix.controller.stages.ResourceComputationStage;
import org.apache.helix.controller.stages.ResourceValidationStage;
import org.apache.helix.controller.stages.TargetExteralViewCalcStage;
import org.apache.helix.controller.stages.TaskAssignmentStage;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.MaintenanceSignal;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.monitoring.mbeans.ClusterEventMonitor;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.task.TaskDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericHelixController
implements IdealStateChangeListener,
LiveInstanceChangeListener,
MessageListener,
CurrentStateChangeListener,
ControllerChangeListener,
InstanceConfigChangeListener,
ResourceConfigChangeListener,
ClusterConfigChangeListener {
    private static final Logger logger = LoggerFactory.getLogger((String)GenericHelixController.class.getName());
    private static final long EVENT_THREAD_JOIN_TIMEOUT = 1000L;
    private static final int ASYNC_TASKS_THREADPOOL_SIZE = 10;
    private final PipelineRegistry _registry;
    private final PipelineRegistry _taskRegistry;
    final AtomicReference<Map<String, LiveInstance>> _lastSeenInstances;
    final AtomicReference<Map<String, LiveInstance>> _lastSeenSessions;
    private boolean _isMonitoring = false;
    private final ClusterStatusMonitor _clusterStatusMonitor;
    private final ClusterEventBlockingQueue _eventQueue;
    private final ClusterEventProcessor _eventThread;
    private final ClusterEventBlockingQueue _taskEventQueue;
    private final ClusterEventProcessor _taskEventThread;
    private final Map<AsyncWorkerType, DedupEventProcessor<String, Runnable>> _asyncFIFOWorkerPool;
    private long _continousRebalanceFailureCount = 0L;
    private boolean _paused = false;
    private boolean _inMaintenanceMode;
    Timer _periodicalRebalanceTimer = null;
    Timer _forceRebalanceTimer = null;
    long _timerPeriod = Long.MAX_VALUE;
    private ClusterDataCache _cache;
    private ClusterDataCache _taskCache;
    private ScheduledExecutorService _asyncTasksThreadPool;
    private String _clusterName;

    public GenericHelixController() {
        this(GenericHelixController.createDefaultRegistry(PipelineTypes.DEFAULT.name()), GenericHelixController.createDefaultRegistry(PipelineTypes.TASK.name()));
    }

    public GenericHelixController(String clusterName) {
        this(GenericHelixController.createDefaultRegistry(PipelineTypes.DEFAULT.name()), GenericHelixController.createDefaultRegistry(PipelineTypes.TASK.name()), clusterName);
    }

    private void forceRebalance(HelixManager manager, ClusterEventType eventType) {
        NotificationContext changeContext = new NotificationContext(manager);
        changeContext.setType(NotificationContext.Type.CALLBACK);
        ClusterEvent event = new ClusterEvent(this._clusterName, eventType);
        event.addAttribute(AttributeName.helixmanager.name(), changeContext.getManager());
        event.addAttribute(AttributeName.changeContext.name(), changeContext);
        event.addAttribute(AttributeName.eventData.name(), new ArrayList());
        event.addAttribute(AttributeName.AsyncFIFOWorkerPool.name(), this._asyncFIFOWorkerPool);
        this._taskEventQueue.put(event);
        this._eventQueue.put(event);
        logger.info("Controller rebalance event triggered with event type: " + (Object)((Object)eventType));
    }

    void startRebalancingTimer(long period, HelixManager manager) {
        if (period != this._timerPeriod) {
            logger.info("Controller starting timer at period " + period);
            if (this._periodicalRebalanceTimer != null) {
                this._periodicalRebalanceTimer.cancel();
            }
            this._periodicalRebalanceTimer = new Timer(true);
            this._timerPeriod = period;
            this._periodicalRebalanceTimer.scheduleAtFixedRate((TimerTask)new RebalanceTask(manager, ClusterEventType.PeriodicalRebalance), this._timerPeriod, this._timerPeriod);
        } else {
            logger.info("Controller already has timer at period " + this._timerPeriod);
        }
    }

    void stopRebalancingTimers() {
        if (this._periodicalRebalanceTimer != null) {
            this._periodicalRebalanceTimer.cancel();
            this._periodicalRebalanceTimer = null;
        }
        this._timerPeriod = Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PipelineRegistry createDefaultRegistry(String pipelineName) {
        logger.info("createDefaultRegistry");
        Class<GenericHelixController> clazz = GenericHelixController.class;
        synchronized (GenericHelixController.class) {
            PipelineRegistry registry = new PipelineRegistry();
            Pipeline dataRefresh = new Pipeline(pipelineName);
            dataRefresh.addStage(new ReadClusterDataStage());
            Pipeline dataPreprocess = new Pipeline(pipelineName);
            dataPreprocess.addStage(new ResourceComputationStage());
            dataPreprocess.addStage(new ResourceValidationStage());
            dataPreprocess.addStage(new CurrentStateComputationStage());
            Pipeline rebalancePipeline = new Pipeline(pipelineName);
            rebalancePipeline.addStage(new BestPossibleStateCalcStage());
            rebalancePipeline.addStage(new IntermediateStateCalcStage());
            rebalancePipeline.addStage(new MessageGenerationPhase());
            rebalancePipeline.addStage(new MessageSelectionStage());
            rebalancePipeline.addStage(new MessageThrottleStage());
            rebalancePipeline.addStage(new TaskAssignmentStage());
            rebalancePipeline.addStage(new PersistAssignmentStage());
            rebalancePipeline.addStage(new TargetExteralViewCalcStage());
            Pipeline externalViewPipeline = new Pipeline(pipelineName);
            externalViewPipeline.addStage(new ExternalViewComputeStage());
            Pipeline liveInstancePipeline = new Pipeline(pipelineName);
            liveInstancePipeline.addStage(new CompatibilityCheckStage());
            registry.register(ClusterEventType.IdealStateChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.CurrentStateChange, dataRefresh, dataPreprocess, externalViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.InstanceConfigChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.ResourceConfigChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.ClusterConfigChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.LiveInstanceChange, dataRefresh, liveInstancePipeline, dataPreprocess, externalViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.MessageChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.ExternalViewChange, dataRefresh);
            registry.register(ClusterEventType.Resume, dataRefresh, dataPreprocess, externalViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.PeriodicalRebalance, dataRefresh, dataPreprocess, externalViewPipeline, rebalancePipeline);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registry;
        }
    }

    public GenericHelixController(PipelineRegistry registry, PipelineRegistry taskRegistry) {
        this(registry, taskRegistry, null);
    }

    private GenericHelixController(PipelineRegistry registry, PipelineRegistry taskRegistry, String clusterName) {
        this._registry = registry;
        this._taskRegistry = taskRegistry;
        this._lastSeenInstances = new AtomicReference();
        this._lastSeenSessions = new AtomicReference();
        this._clusterName = clusterName;
        this._asyncTasksThreadPool = Executors.newScheduledThreadPool(10, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "GerenricHelixController-async_task_thread");
            }
        });
        this._eventQueue = new ClusterEventBlockingQueue();
        this._taskEventQueue = new ClusterEventBlockingQueue();
        this._asyncFIFOWorkerPool = new HashMap<AsyncWorkerType, DedupEventProcessor<String, Runnable>>();
        this._cache = new ClusterDataCache(clusterName);
        this._taskCache = new ClusterDataCache(clusterName);
        this._eventThread = new ClusterEventProcessor(this._cache, this._eventQueue);
        this._taskEventThread = new ClusterEventProcessor(this._taskCache, this._taskEventQueue);
        this._forceRebalanceTimer = new Timer();
        this.initializeAsyncFIFOWorkers();
        this.initPipelines(this._eventThread, this._cache, false);
        this.initPipelines(this._taskEventThread, this._taskCache, true);
        this._clusterStatusMonitor = new ClusterStatusMonitor(this._clusterName);
    }

    private void initializeAsyncFIFOWorkers() {
        for (AsyncWorkerType type : AsyncWorkerType.values()) {
            DedupEventProcessor<String, Runnable> worker = new DedupEventProcessor<String, Runnable>(this._clusterName, type.name()){

                @Override
                protected void handleEvent(Runnable event) {
                    event.run();
                }
            };
            worker.start();
            this._asyncFIFOWorkerPool.put(type, worker);
            logger.info("Started async worker {}", (Object)worker.getName());
        }
    }

    private void shutdownAsyncFIFOWorkers() {
        for (DedupEventProcessor<String, Runnable> processor : this._asyncFIFOWorkerPool.values()) {
            processor.shutdown();
            logger.info("Shutdown async worker {}", (Object)processor.getName());
        }
    }

    private boolean isEventQueueEmpty(boolean taskQueue) {
        if (taskQueue) {
            return this._taskEventQueue.isEmpty();
        }
        return this._eventQueue.isEmpty();
    }

    protected void handleEvent(ClusterEvent event, ClusterDataCache cache) {
        List<Pipeline> pipelines;
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        if (manager == null) {
            logger.error("No cluster manager in event:" + (Object)((Object)event.getEventType()));
            return;
        }
        if (!manager.isLeader()) {
            logger.error("Cluster manager: " + manager.getInstanceName() + " is not leader for " + manager.getClusterName() + ". Pipeline will not be invoked");
            return;
        }
        if (this._paused) {
            logger.info("Cluster " + manager.getClusterName() + " is paused. Ignoring the event:" + (Object)((Object)event.getEventType()));
            return;
        }
        NotificationContext context = null;
        if (event.getAttribute(AttributeName.changeContext.name()) != null) {
            context = (NotificationContext)event.getAttribute(AttributeName.changeContext.name());
        }
        if (context != null) {
            if (context.getType() == NotificationContext.Type.FINALIZE) {
                this.stopRebalancingTimers();
                logger.info("Get FINALIZE notification, skip the pipeline. Event :" + (Object)((Object)event.getEventType()));
                return;
            }
            if (this._cache != null) {
                this.checkRebalancingTimer(manager, Collections.EMPTY_LIST, this._cache.getClusterConfig());
            }
            if (this._isMonitoring) {
                event.addAttribute(AttributeName.clusterStatusMonitor.name(), this._clusterStatusMonitor);
            }
        }
        this._cache.setEventId(event.getEventId());
        event.addAttribute(AttributeName.ClusterDataCache.name(), cache);
        List<Pipeline> list = pipelines = cache.isTaskCache() ? this._taskRegistry.getPipelinesForEvent(event.getEventType()) : this._registry.getPipelinesForEvent(event.getEventType());
        if (pipelines == null || pipelines.size() == 0) {
            logger.info(String.format("No % pipeline to run for event: %s %s", new Object[]{GenericHelixController.getPipelineType(cache.isTaskCache()), event.getEventType(), event.getEventId()}));
            return;
        }
        logger.info(String.format("START: Invoking %s controller pipeline for cluster %s event: %s  %s", new Object[]{manager.getClusterName(), GenericHelixController.getPipelineType(cache.isTaskCache()), event.getEventType(), event.getEventId()}));
        long startTime = System.currentTimeMillis();
        boolean rebalanceFail = false;
        for (Pipeline pipeline : pipelines) {
            event.addAttribute(AttributeName.PipelineType.name(), pipeline.getPipelineType());
            try {
                pipeline.handle(event);
                pipeline.finish();
            }
            catch (Exception e) {
                logger.error("Exception while executing " + GenericHelixController.getPipelineType(cache.isTaskCache()) + "pipeline: " + pipeline + "for cluster ." + this._clusterName + ". Will not continue to next pipeline", (Throwable)e);
                if (e instanceof HelixMetaDataAccessException) {
                    rebalanceFail = true;
                    cache.requireFullRefresh();
                    logger.warn("Rebalance pipeline failed due to read failure from zookeeper, cluster: " + this._clusterName);
                    if (this.isEventQueueEmpty(cache.isTaskCache())) {
                        ++this._continousRebalanceFailureCount;
                        long delay = this.getRetryDelay(this._continousRebalanceFailureCount);
                        if (delay == 0L) {
                            this.forceRebalance(manager, ClusterEventType.RetryRebalance);
                        } else {
                            this._asyncTasksThreadPool.schedule(new RebalanceTask(manager, ClusterEventType.RetryRebalance), delay, TimeUnit.MILLISECONDS);
                        }
                        logger.info("Retry rebalance pipeline with delay " + delay + "ms for cluster: " + this._clusterName);
                    }
                }
                this._clusterStatusMonitor.reportRebalanceFailure();
                break;
            }
        }
        if (!rebalanceFail) {
            this._continousRebalanceFailureCount = 0L;
        }
        long endTime = System.currentTimeMillis();
        logger.info(String.format("END: Invoking %s controller pipeline for event: %s %s for cluster %s, took %d ms", new Object[]{GenericHelixController.getPipelineType(cache.isTaskCache()), event.getEventType(), event.getEventId(), manager.getClusterName(), endTime - startTime}));
        if (!cache.isTaskCache()) {
            NotificationContext notificationContext = (NotificationContext)event.getAttribute(AttributeName.changeContext.name());
            long enqueueTime = event.getCreationTime();
            StringBuilder sb = new StringBuilder();
            if (notificationContext != null) {
                long zkCallbackTime = notificationContext.getCreationTime();
                if (this._isMonitoring) {
                    this._clusterStatusMonitor.updateClusterEventDuration(ClusterEventMonitor.PhaseName.Callback.name(), enqueueTime - zkCallbackTime);
                }
                sb.append(String.format("Callback time for event: " + (Object)((Object)event.getEventType()) + " took: " + (enqueueTime - zkCallbackTime) + " ms\n", new Object[0]));
            }
            if (this._isMonitoring) {
                this._clusterStatusMonitor.updateClusterEventDuration(ClusterEventMonitor.PhaseName.InQueue.name(), startTime - enqueueTime);
                this._clusterStatusMonitor.updateClusterEventDuration(ClusterEventMonitor.PhaseName.TotalProcessed.name(), endTime - startTime);
            }
            sb.append(String.format("InQueue time for event: " + (Object)((Object)event.getEventType()) + " took: " + (startTime - enqueueTime) + " ms\n", new Object[0]));
            sb.append(String.format("TotalProcessed time for event: " + (Object)((Object)event.getEventType()) + " took: " + (endTime - startTime) + " ms", new Object[0]));
            logger.info(sb.toString());
        } else if (this._isMonitoring) {
            TaskDriver driver = new TaskDriver(manager);
            this._clusterStatusMonitor.refreshWorkflowsStatus(driver);
            this._clusterStatusMonitor.refreshJobsStatus(driver);
        }
        this.resetClusterStatusMonitor();
    }

    private long getRetryDelay(long failCount) {
        int lowLimit = 5;
        if (failCount <= (long)lowLimit) {
            return 0L;
        }
        long backoff = (long)(Math.pow(2.0, failCount - (long)lowLimit) * 10.0);
        return Math.min(backoff, 1000L);
    }

    @Override
    @PreFetch(enabled=false)
    public void onStateChange(String instanceName, List<CurrentState> statesInfo, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onStateChange()");
        this.notifyCaches(changeContext, HelixConstants.ChangeType.CURRENT_STATE);
        this.pushToEventQueues(ClusterEventType.CurrentStateChange, changeContext, Collections.singletonMap(AttributeName.instanceName.name(), instanceName));
        logger.info("END: GenericClusterController.onStateChange()");
    }

    @Override
    @PreFetch(enabled=false)
    public void onMessage(String instanceName, List<Message> messages, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onMessage() for cluster " + this._clusterName);
        this.notifyCaches(changeContext, HelixConstants.ChangeType.MESSAGE);
        this.pushToEventQueues(ClusterEventType.MessageChange, changeContext, Collections.singletonMap(AttributeName.instanceName.name(), instanceName));
        if (this._isMonitoring && messages != null) {
            this._clusterStatusMonitor.addMessageQueueSize(instanceName, messages.size());
        }
        logger.info("END: GenericClusterController.onMessage() for cluster " + this._clusterName);
    }

    @Override
    public void onLiveInstanceChange(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        logger.info("START: Generic GenericClusterController.onLiveInstanceChange() for cluster " + this._clusterName);
        if (changeContext == null || changeContext.getType() != NotificationContext.Type.CALLBACK) {
            this._cache.requireFullRefresh();
            this._taskCache.requireFullRefresh();
        }
        if (liveInstances == null) {
            liveInstances = Collections.emptyList();
        }
        this._cache.setLiveInstances(liveInstances);
        this._taskCache.setLiveInstances(liveInstances);
        if (changeContext.getType() == NotificationContext.Type.INIT || changeContext.getType() == NotificationContext.Type.CALLBACK) {
            this.checkLiveInstancesObservation(liveInstances, changeContext);
        } else if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info("remove message/current-state listeners. lastSeenInstances: " + this._lastSeenInstances + ", lastSeenSessions: " + this._lastSeenSessions);
            liveInstances = Collections.emptyList();
            this.checkLiveInstancesObservation(liveInstances, changeContext);
        }
        this.pushToEventQueues(ClusterEventType.LiveInstanceChange, changeContext, Collections.singletonMap(AttributeName.eventData.name(), liveInstances));
        logger.info("END: Generic GenericClusterController.onLiveInstanceChange() for cluster " + this._clusterName);
    }

    private void checkRebalancingTimer(HelixManager manager, List<IdealState> idealStates, ClusterConfig clusterConfig) {
        long period;
        if (manager.getConfigAccessor() == null) {
            logger.warn(manager.getInstanceName() + " config accessor doesn't exist. should be in file-based mode.");
            return;
        }
        long minPeriod = Long.MAX_VALUE;
        if (clusterConfig != null && (period = clusterConfig.getRebalanceTimePeriod()) > 0L && minPeriod > period) {
            minPeriod = period;
        }
        for (IdealState idealState : idealStates) {
            long period2 = idealState.getRebalanceTimerPeriod();
            if (period2 <= 0L || minPeriod <= period2) continue;
            minPeriod = period2;
        }
        if (minPeriod != Long.MAX_VALUE) {
            this.startRebalancingTimer(minPeriod, manager);
        }
    }

    @Override
    @PreFetch(enabled=false)
    public void onIdealStateChange(List<IdealState> idealStates, NotificationContext changeContext) {
        logger.info("START: Generic GenericClusterController.onIdealStateChange() for cluster " + this._clusterName);
        this.notifyCaches(changeContext, HelixConstants.ChangeType.IDEAL_STATE);
        this.pushToEventQueues(ClusterEventType.IdealStateChange, changeContext, Collections.emptyMap());
        if (changeContext.getType() != NotificationContext.Type.FINALIZE) {
            this.checkRebalancingTimer(changeContext.getManager(), idealStates, this._cache.getClusterConfig());
        }
        logger.info("END: GenericClusterController.onIdealStateChange() for cluster " + this._clusterName);
    }

    @Override
    @PreFetch(enabled=false)
    public void onInstanceConfigChange(List<InstanceConfig> instanceConfigs, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onInstanceConfigChange() for cluster " + this._clusterName);
        this.notifyCaches(changeContext, HelixConstants.ChangeType.INSTANCE_CONFIG);
        this.pushToEventQueues(ClusterEventType.InstanceConfigChange, changeContext, Collections.emptyMap());
        logger.info("END: GenericClusterController.onInstanceConfigChange() for cluster " + this._clusterName);
    }

    @Override
    @PreFetch(enabled=false)
    public void onResourceConfigChange(List<ResourceConfig> resourceConfigs, NotificationContext context) {
        logger.info("START: GenericClusterController.onResourceConfigChange() for cluster " + this._clusterName);
        this.notifyCaches(context, HelixConstants.ChangeType.RESOURCE_CONFIG);
        this.pushToEventQueues(ClusterEventType.ResourceConfigChange, context, Collections.emptyMap());
        logger.info("END: GenericClusterController.onResourceConfigChange() for cluster " + this._clusterName);
    }

    @Override
    @PreFetch(enabled=false)
    public void onClusterConfigChange(ClusterConfig clusterConfig, NotificationContext context) {
        logger.info("START: GenericClusterController.onClusterConfigChange() for cluster " + this._clusterName);
        this.notifyCaches(context, HelixConstants.ChangeType.CLUSTER_CONFIG);
        this.pushToEventQueues(ClusterEventType.ClusterConfigChange, context, Collections.emptyMap());
        logger.info("END: GenericClusterController.onClusterConfigChange() for cluster " + this._clusterName);
    }

    private void notifyCaches(NotificationContext context, HelixConstants.ChangeType changeType) {
        if (context == null || context.getType() != NotificationContext.Type.CALLBACK) {
            this._cache.requireFullRefresh();
            this._taskCache.requireFullRefresh();
        } else {
            this._cache.notifyDataChange(changeType, context.getPathChanged());
            this._taskCache.notifyDataChange(changeType, context.getPathChanged());
        }
    }

    private void pushToEventQueues(ClusterEventType eventType, NotificationContext changeContext, Map<String, Object> eventAttributes) {
        String uid = UUID.randomUUID().toString().substring(0, 8);
        ClusterEvent event = new ClusterEvent(this._clusterName, eventType, String.format("%s_%s", uid, PipelineTypes.DEFAULT.name()));
        event.addAttribute(AttributeName.helixmanager.name(), changeContext.getManager());
        event.addAttribute(AttributeName.changeContext.name(), changeContext);
        event.addAttribute(AttributeName.AsyncFIFOWorkerPool.name(), this._asyncFIFOWorkerPool);
        for (Map.Entry<String, Object> attr : eventAttributes.entrySet()) {
            event.addAttribute(attr.getKey(), attr.getValue());
        }
        this._eventQueue.put(event);
        this._taskEventQueue.put(event.clone(String.format("%s_%s", uid, PipelineTypes.TASK.name())));
    }

    @Override
    public void onControllerChange(NotificationContext changeContext) {
        boolean controllerIsLeader;
        logger.info("START: GenericClusterController.onControllerChange() for cluster " + this._clusterName);
        this._cache.requireFullRefresh();
        this._taskCache.requireFullRefresh();
        if (changeContext != null && changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info("GenericClusterController.onControllerChange() FINALIZE for cluster " + this._clusterName);
            controllerIsLeader = false;
        } else {
            controllerIsLeader = changeContext.getManager().isLeader();
        }
        HelixManager manager = changeContext.getManager();
        if (controllerIsLeader) {
            HelixDataAccessor accessor = manager.getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            PauseSignal pauseSignal = (PauseSignal)accessor.getProperty(keyBuilder.pause());
            MaintenanceSignal maintenanceSignal = (MaintenanceSignal)accessor.getProperty(keyBuilder.maintenance());
            this._paused = this.updateControllerState(changeContext, pauseSignal, this._paused);
            this._inMaintenanceMode = this.updateControllerState(changeContext, maintenanceSignal, this._inMaintenanceMode);
            this.enableClusterStatusMonitor(true);
            this._clusterStatusMonitor.setEnabled(!this._paused);
            this._clusterStatusMonitor.setPaused(this._paused);
            this._clusterStatusMonitor.setMaintenance(this._inMaintenanceMode);
        } else {
            this.enableClusterStatusMonitor(false);
        }
        logger.info("END: GenericClusterController.onControllerChange() for cluster " + this._clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLiveInstancesObservation(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        HashMap<String, LiveInstance> curInstances = new HashMap<String, LiveInstance>();
        HashMap<String, LiveInstance> curSessions = new HashMap<String, LiveInstance>();
        for (LiveInstance liveInstance : liveInstances) {
            curInstances.put(liveInstance.getInstanceName(), liveInstance);
            curSessions.put(liveInstance.getSessionId(), liveInstance);
        }
        AtomicReference<Map<String, LiveInstance>> atomicReference = this._lastSeenInstances;
        synchronized (atomicReference) {
            String instanceName;
            Map<String, LiveInstance> lastInstances = this._lastSeenInstances.get();
            Map<String, LiveInstance> lastSessions = this._lastSeenSessions.get();
            HelixManager manager = changeContext.getManager();
            PropertyKey.Builder keyBuilder = new PropertyKey.Builder(manager.getClusterName());
            if (lastSessions != null) {
                for (String session : lastSessions.keySet()) {
                    if (curSessions.containsKey(session)) continue;
                    instanceName = lastSessions.get(session).getInstanceName();
                    manager.removeListener(keyBuilder.currentStates(instanceName, session), this);
                }
            }
            if (lastInstances != null) {
                for (String instance : lastInstances.keySet()) {
                    if (curInstances.containsKey(instance)) continue;
                    manager.removeListener(keyBuilder.messages(instance), this);
                }
            }
            for (String session : curSessions.keySet()) {
                if (lastSessions != null && lastSessions.containsKey(session)) continue;
                instanceName = ((LiveInstance)curSessions.get(session)).getInstanceName();
                try {
                    manager.addCurrentStateChangeListener(this, instanceName, session);
                    logger.info(manager.getInstanceName() + " added current-state listener for instance: " + instanceName + ", session: " + session + ", listener: " + this);
                }
                catch (Exception e) {
                    logger.error("Fail to add current state listener for instance: " + instanceName + " with session: " + session, (Throwable)e);
                }
            }
            for (String instance : curInstances.keySet()) {
                if (lastInstances != null && lastInstances.containsKey(instance)) continue;
                try {
                    manager.addMessageListener(this, instance);
                    logger.info(manager.getInstanceName() + " added message listener for " + instance + ", listener: " + this);
                }
                catch (Exception e) {
                    logger.error("Fail to add message listener for instance: " + instance, (Throwable)e);
                }
            }
            this._lastSeenInstances.set(curInstances);
            this._lastSeenSessions.set(curSessions);
        }
    }

    public void shutdown() throws InterruptedException {
        this.stopRebalancingTimers();
        this.terminateEventThread(this._eventThread);
        this.terminateEventThread(this._taskEventThread);
        this._eventQueue.clear();
        this._taskEventQueue.clear();
        this._asyncTasksThreadPool.shutdownNow();
        try {
            this._asyncTasksThreadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            logger.warn("Timeout when terminating async tasks. Some async tasks are still executing.");
        }
        this.shutdownAsyncFIFOWorkers();
        this.enableClusterStatusMonitor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableClusterStatusMonitor(boolean enable) {
        ClusterStatusMonitor clusterStatusMonitor = this._clusterStatusMonitor;
        synchronized (clusterStatusMonitor) {
            if (this._isMonitoring != enable) {
                if (enable) {
                    logger.info("Enable clusterStatusMonitor for cluster " + this._clusterName);
                    this._cache.clearMonitoringRecords();
                    this._taskCache.clearMonitoringRecords();
                    this._clusterStatusMonitor.active();
                } else {
                    logger.info("Disable clusterStatusMonitor for cluster " + this._clusterName);
                }
                this._isMonitoring = enable;
            }
            this.resetClusterStatusMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetClusterStatusMonitor() {
        ClusterStatusMonitor clusterStatusMonitor = this._clusterStatusMonitor;
        synchronized (clusterStatusMonitor) {
            if (!this._isMonitoring) {
                this._clusterStatusMonitor.reset();
            }
        }
    }

    private void terminateEventThread(Thread thread) throws InterruptedException {
        while (thread.isAlive()) {
            thread.interrupt();
            thread.join(1000L);
        }
    }

    private boolean updateControllerState(NotificationContext changeContext, PauseSignal signal, boolean statusFlag) {
        if (signal != null) {
            if (!statusFlag) {
                statusFlag = true;
                logger.info(String.format("controller is now %s", signal instanceof MaintenanceSignal ? "in maintenance mode" : "paused"));
            }
        } else if (statusFlag) {
            statusFlag = false;
            logger.info("controller is now resumed from paused state");
            String uid = UUID.randomUUID().toString().substring(0, 8);
            ClusterEvent event = new ClusterEvent(this._clusterName, ClusterEventType.Resume, String.format("%s_%s", uid, PipelineTypes.DEFAULT.name()));
            event.addAttribute(AttributeName.changeContext.name(), changeContext);
            event.addAttribute(AttributeName.helixmanager.name(), changeContext.getManager());
            event.addAttribute(AttributeName.eventData.name(), signal);
            event.addAttribute(AttributeName.AsyncFIFOWorkerPool.name(), this._asyncFIFOWorkerPool);
            this._eventQueue.put(event);
            this._taskEventQueue.put(event.clone(String.format("%s_%s", uid, PipelineTypes.TASK.name())));
        }
        return statusFlag;
    }

    private void initPipelines(Thread eventThread, ClusterDataCache cache, boolean isTask) {
        cache.setTaskCache(isTask);
        cache.setAsyncTasksThreadPool(this._asyncTasksThreadPool);
        eventThread.setDaemon(true);
        eventThread.start();
    }

    public static String getPipelineType(boolean isTask) {
        return isTask ? PipelineTypes.TASK.name() : PipelineTypes.DEFAULT.name();
    }

    private class ClusterEventProcessor
    extends Thread {
        private final ClusterDataCache _cache;
        private final ClusterEventBlockingQueue _eventBlockingQueue;

        public ClusterEventProcessor(ClusterDataCache cache, ClusterEventBlockingQueue eventBlockingQueue) {
            super("GenericHelixController-event_process");
            this._cache = cache;
            this._eventBlockingQueue = eventBlockingQueue;
        }

        @Override
        public void run() {
            logger.info("START ClusterEventProcessor thread  for cluster " + GenericHelixController.this._clusterName);
            while (!this.isInterrupted()) {
                try {
                    GenericHelixController.this.handleEvent(this._eventBlockingQueue.take(), this._cache);
                }
                catch (InterruptedException e) {
                    logger.warn("ClusterEventProcessor interrupted", (Throwable)e);
                    this.interrupt();
                }
                catch (ZkInterruptedException e) {
                    logger.warn("ClusterEventProcessor caught a ZK connection interrupt", (Throwable)e);
                    this.interrupt();
                }
                catch (ThreadDeath death) {
                    throw death;
                }
                catch (Throwable t) {
                    logger.error("ClusterEventProcessor failed while running the controller pipeline", t);
                }
            }
            logger.info("END ClusterEventProcessor thread");
        }
    }

    class RebalanceTask
    extends TimerTask {
        HelixManager _manager;
        ClusterEventType _clusterEventType;

        public RebalanceTask(HelixManager manager, ClusterEventType clusterEventType) {
            this._manager = manager;
            this._clusterEventType = clusterEventType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this._clusterEventType.equals((Object)ClusterEventType.PeriodicalRebalance)) {
                    GenericHelixController.this._cache.requireFullRefresh();
                    GenericHelixController.this._taskCache.requireFullRefresh();
                    GenericHelixController.this._cache.refresh(this._manager.getHelixDataAccessor());
                    if (GenericHelixController.this._cache.getLiveInstances() != null) {
                        NotificationContext changeContext = new NotificationContext(this._manager);
                        changeContext.setType(NotificationContext.Type.CALLBACK);
                        HelixManager helixManager = this._manager;
                        synchronized (helixManager) {
                            GenericHelixController.this.checkLiveInstancesObservation(new ArrayList<LiveInstance>(GenericHelixController.this._cache.getLiveInstances().values()), changeContext);
                        }
                    }
                }
                GenericHelixController.this.forceRebalance(this._manager, this._clusterEventType);
            }
            catch (Throwable ex) {
                logger.error("Time task failed. Rebalance task type: " + (Object)((Object)this._clusterEventType) + ", cluster: " + GenericHelixController.this._clusterName);
            }
        }
    }

    static enum PipelineTypes {
        DEFAULT,
        TASK;

    }
}

