/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.CardDealer;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.CardDealingAdjustmentAlgorithm;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.ConsistentHashingAdjustmentAlgorithm;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEvenDistributionRebalanceStrategy
implements RebalanceStrategy {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractEvenDistributionRebalanceStrategy.class);
    protected String _resourceName;
    protected int _replica;

    protected abstract RebalanceStrategy getBaseRebalanceStrategy();

    protected CardDealer getCardDealingAlgorithm(Topology topology) {
        return new CardDealingAdjustmentAlgorithm(topology, this._replica);
    }

    @Override
    public void init(String resourceName, List<String> partitions, LinkedHashMap<String, Integer> states, int maximumPerNode) {
        this._resourceName = resourceName;
        this.getBaseRebalanceStrategy().init(resourceName, partitions, states, maximumPerNode);
        this._replica = this.countStateReplicas(states);
    }

    @Override
    public ZNRecord computePartitionAssignment(List<String> allNodes, List<String> liveNodes, Map<String, Map<String, String>> currentMapping, ClusterDataCache clusterData) throws HelixException {
        ZNRecord origAssignment = this.getBaseRebalanceStrategy().computePartitionAssignment(allNodes, allNodes, currentMapping, clusterData);
        Map<String, List<String>> origPartitionMap = origAssignment.getListFields();
        if (!origPartitionMap.isEmpty()) {
            Map<String, List<String>> nodeToPartitionMap = this.convertMap(origPartitionMap);
            Map<String, List<String>> finalPartitionMap = null;
            Topology allNodeTopo = new Topology(allNodes, allNodes, clusterData.getInstanceConfigMap(), clusterData.getClusterConfig());
            CardDealer cardDealer = this.getCardDealingAlgorithm(allNodeTopo);
            if (cardDealer.computeMapping(nodeToPartitionMap, this._resourceName.hashCode())) {
                finalPartitionMap = this.shufflePreferenceList(nodeToPartitionMap);
                if (!liveNodes.containsAll(allNodes)) {
                    try {
                        ConsistentHashingAdjustmentAlgorithm hashPlacement = new ConsistentHashingAdjustmentAlgorithm(allNodeTopo, liveNodes);
                        if (hashPlacement.computeMapping(nodeToPartitionMap, this._resourceName.hashCode())) {
                            Map<String, List<String>> adjustedPartitionMap = this.convertMap(nodeToPartitionMap);
                            for (String partition : adjustedPartitionMap.keySet()) {
                                List<String> preSelectedList = finalPartitionMap.get(partition);
                                HashSet adjustedNodeList = new HashSet(adjustedPartitionMap.get(partition));
                                List<String> finalNodeList = adjustedPartitionMap.get(partition);
                                int index = 0;
                                for (String node : preSelectedList) {
                                    if (!adjustedNodeList.remove(node)) continue;
                                    finalNodeList.set(index++, node);
                                }
                                for (String node : adjustedNodeList) {
                                    finalNodeList.set(index++, node);
                                }
                            }
                            finalPartitionMap = adjustedPartitionMap;
                        } else {
                            finalPartitionMap = null;
                        }
                    }
                    catch (ExecutionException e) {
                        _logger.error("Failed to perform consistent hashing partition assigner.", (Throwable)e);
                        finalPartitionMap = null;
                    }
                }
            }
            if (null != finalPartitionMap) {
                ZNRecord result = new ZNRecord(this._resourceName);
                result.setListFields(finalPartitionMap);
                return result;
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Force even distribution is not possible, using the default strategy: " + this.getBaseRebalanceStrategy().getClass().getSimpleName());
        }
        if (liveNodes.equals(allNodes)) {
            return origAssignment;
        }
        return this.getBaseRebalanceStrategy().computePartitionAssignment(allNodes, liveNodes, currentMapping, clusterData);
    }

    private Map<String, List<String>> shufflePreferenceList(Map<String, List<String>> nodeToPartitionMap) {
        Map<String, List<String>> partitionMap = this.convertMap(nodeToPartitionMap);
        final HashMap<String, Integer> nodeScores = new HashMap<String, Integer>();
        for (String node : nodeToPartitionMap.keySet()) {
            nodeScores.put(node, nodeToPartitionMap.get(node).size());
        }
        for (final String partition : partitionMap.keySet()) {
            List<String> nodes = partitionMap.get(partition);
            Collections.sort(nodes, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int o2Score;
                    int o1Score = (Integer)nodeScores.get(o1);
                    if (o1Score == (o2Score = ((Integer)nodeScores.get(o2)).intValue())) {
                        return new Integer((partition + o1).hashCode()).compareTo((partition + o2).hashCode());
                    }
                    return o1Score - o2Score;
                }
            });
            for (int i = 0; i < nodes.size(); ++i) {
                String nodeName = nodes.get(i);
                nodeScores.put(nodeName, (Integer)nodeScores.get(nodeName) - 1 + (i == 0 ? (int)Math.pow(this._replica, 2.0) : 0));
            }
        }
        return partitionMap;
    }

    private Map<String, List<String>> convertMap(Map<String, List<String>> originalMap) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        for (String originalKey : originalMap.keySet()) {
            for (String originalValue : originalMap.get(originalKey)) {
                if (!resultMap.containsKey(originalValue)) {
                    resultMap.put(originalValue, new ArrayList());
                }
                ((List)resultMap.get(originalValue)).add(originalKey);
            }
        }
        return resultMap;
    }

    private int countStateReplicas(Map<String, Integer> stateCountMap) {
        int total = 0;
        for (Integer count : stateCountMap.values()) {
            total += count.intValue();
        }
        return total;
    }
}

