/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy.crushMapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.CardDealer;
import org.apache.helix.controller.rebalancer.topology.Node;
import org.apache.helix.controller.rebalancer.topology.Topology;

public class CardDealingAdjustmentAlgorithm
implements CardDealer {
    private static int MAX_ADJUSTMENT = 2;
    private int _replica;
    private Map<String, String> _instanceFaultZone = new HashMap<String, String>();
    private Map<String, Long> _instanceWeight = new HashMap<String, Long>();
    private long _totalWeight = 0L;
    private Map<String, Long> _faultZoneWeight = new HashMap<String, Long>();
    private Map<String, Set<String>> _faultZonePartitionMap = new HashMap<String, Set<String>>();

    public CardDealingAdjustmentAlgorithm(Topology topology, int replica) {
        this._replica = replica;
        for (Node zone : topology.getFaultZones()) {
            this._faultZoneWeight.put(zone.getName(), zone.getWeight());
            if (!this._faultZonePartitionMap.containsKey(zone.getName())) {
                this._faultZonePartitionMap.put(zone.getName(), new HashSet());
            }
            for (Node instance : Topology.getAllLeafNodes(zone)) {
                if (instance.isFailed()) continue;
                this._instanceWeight.put(instance.getName(), instance.getWeight());
                this._totalWeight += instance.getWeight();
                this._instanceFaultZone.put(instance.getName(), zone.getName());
            }
        }
    }

    @Override
    public boolean computeMapping(Map<String, List<String>> nodeToPartitionMap, int randomSeed) {
        TreeMap<String, Integer> toBeReassigned = new TreeMap<String, Integer>();
        long totalReplicaCount = 0L;
        for (List<String> partitions : nodeToPartitionMap.values()) {
            totalReplicaCount += (long)partitions.size();
        }
        if (totalReplicaCount == 0L || this._replica > this._faultZoneWeight.size()) {
            return false;
        }
        HashMap<String, Float> targetPartitionCount = new HashMap<String, Float>();
        for (String liveInstance : this._instanceFaultZone.keySet()) {
            long zoneWeight = this._faultZoneWeight.get(this._instanceFaultZone.get(liveInstance));
            float instanceRatioInZone = (float)this._instanceWeight.get(liveInstance).longValue() / (float)zoneWeight;
            float zonePartitions = this._replica == this._faultZoneWeight.size() ? (float)totalReplicaCount / (float)this._faultZoneWeight.size() : (float)totalReplicaCount * (float)zoneWeight / (float)this._totalWeight;
            targetPartitionCount.put(liveInstance, Float.valueOf(instanceRatioInZone * zonePartitions));
        }
        int totalOverflows = (int)totalReplicaCount % this._instanceFaultZone.size();
        HashMap<String, Integer> maxZoneOverflows = new HashMap<String, Integer>();
        for (String faultZoneName : this._faultZoneWeight.keySet()) {
            float zoneWeight = this._faultZoneWeight.get(faultZoneName).longValue();
            maxZoneOverflows.put(faultZoneName, (int)Math.ceil((float)totalOverflows * zoneWeight / (float)this._totalWeight));
        }
        Iterator<String> nodeIter = nodeToPartitionMap.keySet().iterator();
        while (nodeIter.hasNext()) {
            String instance = nodeIter.next();
            if (this._instanceFaultZone.containsKey(instance)) continue;
            List<String> partitions = nodeToPartitionMap.get(instance);
            this.addToReAssignPartition(toBeReassigned, partitions);
            partitions.clear();
            nodeIter.remove();
        }
        ArrayList<String> orderedInstances = new ArrayList<String>(this._instanceFaultZone.keySet());
        Collections.shuffle(orderedInstances, new Random(randomSeed));
        for (String instance : orderedInstances) {
            if (!nodeToPartitionMap.containsKey(instance)) continue;
            List<String> partitions = nodeToPartitionMap.get(instance);
            int target = (int)Math.floor(((Float)targetPartitionCount.get(instance)).floatValue());
            if (partitions.size() > target) {
                int maxZoneOverflow = (Integer)maxZoneOverflows.get(this._instanceFaultZone.get(instance));
                if (maxZoneOverflow > 0 && totalOverflows > 0) {
                    target = (int)Math.ceil(((Float)targetPartitionCount.get(instance)).floatValue());
                    maxZoneOverflows.put(this._instanceFaultZone.get(instance), maxZoneOverflow - 1);
                    --totalOverflows;
                }
                Collections.shuffle(partitions, new Random(instance.hashCode() * 31 + randomSeed));
                this.addToReAssignPartition(toBeReassigned, partitions.subList(target, partitions.size()));
                ArrayList<String> remainingPartitions = new ArrayList<String>(partitions.subList(0, target));
                partitions.clear();
                nodeToPartitionMap.put(instance, remainingPartitions);
            }
            this._faultZonePartitionMap.get(this._instanceFaultZone.get(instance)).addAll((Collection<String>)nodeToPartitionMap.get(instance));
        }
        int adjustment = 0;
        while (!toBeReassigned.isEmpty() && adjustment <= MAX_ADJUSTMENT) {
            this.partitionDealing(this._instanceFaultZone.keySet(), toBeReassigned, this._faultZonePartitionMap, this._instanceFaultZone, nodeToPartitionMap, targetPartitionCount, randomSeed, adjustment++);
        }
        return toBeReassigned.isEmpty();
    }

    private void partitionDealing(Collection<String> instances, TreeMap<String, Integer> toBeReassigned, Map<String, Set<String>> faultZonePartitionMap, Map<String, String> faultZoneMap, final Map<String, List<String>> assignmentMap, Map<String, Float> targetPartitionCount, final int randomSeed, int targetAdjustment) {
        PriorityQueue<String> instanceQueue = new PriorityQueue<String>(instances.size(), new Comparator<String>(){

            @Override
            public int compare(String node1, String node2) {
                int node2Load;
                int node1Load = assignmentMap.containsKey(node1) ? ((List)assignmentMap.get(node1)).size() : 0;
                int n = node2Load = assignmentMap.containsKey(node2) ? ((List)assignmentMap.get(node2)).size() : 0;
                if (node1Load == node2Load) {
                    return new Integer((node1 + randomSeed).hashCode()).compareTo((node2 + randomSeed).hashCode());
                }
                return node1Load - node2Load;
            }
        });
        instanceQueue.addAll(instances);
        while (!toBeReassigned.isEmpty()) {
            boolean anyPartitionAssigned = false;
            Iterator<String> instanceIter = instanceQueue.iterator();
            while (instanceIter.hasNext()) {
                String instance = instanceIter.next();
                instanceIter.remove();
                boolean partitionAssignedToInstance = false;
                String faultZoneStr = faultZoneMap.get(instance);
                List<Object> partitions = assignmentMap.containsKey(instance) ? assignmentMap.get(instance) : new ArrayList();
                int space = (int)Math.floor(targetPartitionCount.get(instance).floatValue()) + targetAdjustment - partitions.size();
                if (space > 0) {
                    for (String pendingPartition : toBeReassigned.navigableKeySet()) {
                        if (faultZonePartitionMap.get(faultZoneStr).contains(pendingPartition)) continue;
                        if (!assignmentMap.containsKey(instance)) {
                            assignmentMap.put(instance, partitions);
                        }
                        partitions.add(pendingPartition);
                        faultZonePartitionMap.get(faultZoneStr).add(pendingPartition);
                        if (toBeReassigned.get(pendingPartition) == 1) {
                            toBeReassigned.remove(pendingPartition);
                        } else {
                            toBeReassigned.put(pendingPartition, toBeReassigned.get(pendingPartition) - 1);
                        }
                        partitionAssignedToInstance = true;
                        break;
                    }
                }
                if (!partitionAssignedToInstance) continue;
                instanceQueue.add(instance);
                anyPartitionAssigned = true;
                break;
            }
            if (anyPartitionAssigned) continue;
            break;
        }
    }

    private void addToReAssignPartition(TreeMap<String, Integer> toBeReassigned, List<String> partitions) {
        for (String partition : partitions) {
            if (!toBeReassigned.containsKey(partition)) {
                toBeReassigned.put(partition, 1);
                continue;
            }
            toBeReassigned.put(partition, toBeReassigned.get(partition) + 1);
        }
    }
}

