/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStateComputationStage
extends AbstractBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(CurrentStateComputationStage.class);
    public final long NOT_RECORDED = -1L;
    public final long TRANSITION_FAILED = -2L;
    public final String TASK_STATE_MODEL_NAME = "Task";

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute(AttributeName.ClusterDataCache.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
        if (cache == null || resourceMap == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires DataCache|RESOURCE");
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        CurrentStateOutput currentStateOutput = new CurrentStateOutput();
        for (LiveInstance instance : liveInstances.values()) {
            String instanceName = instance.getInstanceName();
            String instanceSessionId = instance.getSessionId();
            Map<String, Message> messages = cache.getMessages(instanceName);
            this.updatePendingMessages(instance, messages.values(), currentStateOutput, resourceMap);
            Map<String, CurrentState> currentStateMap = cache.getCurrentState(instanceName, instanceSessionId);
            this.updateCurrentStates(instance, currentStateMap.values(), currentStateOutput, resourceMap);
        }
        if (!cache.isTaskCache()) {
            ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
            this.updateTopStateStatus(cache, clusterStatusMonitor, resourceMap, currentStateOutput);
        }
        event.addAttribute(AttributeName.CURRENT_STATE.name(), currentStateOutput);
    }

    private void updatePendingMessages(LiveInstance instance, Collection<Message> pendingMessages, CurrentStateOutput currentStateOutput, Map<String, Resource> resourceMap) {
        String instanceName = instance.getInstanceName();
        String instanceSessionId = instance.getSessionId();
        for (Message message : pendingMessages) {
            String resourceName;
            Resource resource;
            if (!Message.MessageType.STATE_TRANSITION.name().equalsIgnoreCase(message.getMsgType()) && !Message.MessageType.STATE_TRANSITION_CANCELLATION.name().equalsIgnoreCase(message.getMsgType()) || !instanceSessionId.equals(message.getTgtSessionId()) || (resource = resourceMap.get(resourceName = message.getResourceName())) == null) continue;
            if (!message.getBatchMessageMode()) {
                String partitionName = message.getPartitionName();
                Partition partition = resource.getPartition(partitionName);
                if (partition == null) continue;
                this.setMessageState(currentStateOutput, resourceName, partition, instanceName, message);
                continue;
            }
            List<String> partitionNames = message.getPartitionNames();
            if (partitionNames.isEmpty()) continue;
            for (String partitionName : partitionNames) {
                Partition partition = resource.getPartition(partitionName);
                if (partition == null) continue;
                this.setMessageState(currentStateOutput, resourceName, partition, instanceName, message);
            }
        }
    }

    private void updateCurrentStates(LiveInstance instance, Collection<CurrentState> currentStates, CurrentStateOutput currentStateOutput, Map<String, Resource> resourceMap) {
        String instanceName = instance.getInstanceName();
        String instanceSessionId = instance.getSessionId();
        for (CurrentState currentState : currentStates) {
            if (!instanceSessionId.equals(currentState.getSessionId())) continue;
            String resourceName = currentState.getResourceName();
            String stateModelDefName = currentState.getStateModelDefRef();
            Resource resource = resourceMap.get(resourceName);
            if (resource == null) continue;
            if (stateModelDefName != null) {
                currentStateOutput.setResourceStateModelDef(resourceName, stateModelDefName);
            }
            currentStateOutput.setBucketSize(resourceName, currentState.getBucketSize());
            Map<String, String> partitionStateMap = currentState.getPartitionStateMap();
            for (String partitionName : partitionStateMap.keySet()) {
                Partition partition = resource.getPartition(partitionName);
                if (partition == null) continue;
                currentStateOutput.setCurrentState(resourceName, partition, instanceName, currentState.getState(partitionName));
                currentStateOutput.setRequestedState(resourceName, partition, instanceName, currentState.getRequestedState(partitionName));
                currentStateOutput.setInfo(resourceName, partition, instanceName, currentState.getInfo(partitionName));
                currentStateOutput.setEndTime(resourceName, partition, instanceName, currentState.getEndTime(partitionName));
            }
        }
    }

    private void setMessageState(CurrentStateOutput currentStateOutput, String resourceName, Partition partition, String instanceName, Message message) {
        if (Message.MessageType.STATE_TRANSITION.name().equalsIgnoreCase(message.getMsgType())) {
            currentStateOutput.setPendingState(resourceName, partition, instanceName, message);
        } else {
            currentStateOutput.setCancellationState(resourceName, partition, instanceName, message);
        }
    }

    private void updateTopStateStatus(ClusterDataCache cache, ClusterStatusMonitor clusterStatusMonitor, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) {
        Map<String, Map<String, Long>> missingTopStateMap = cache.getMissingTopStateMap();
        Map<String, Map<String, String>> lastTopStateMap = cache.getLastTopStateLocationMap();
        long durationThreshold = Long.MAX_VALUE;
        if (cache.getClusterConfig() != null) {
            durationThreshold = cache.getClusterConfig().getMissTopStateDurationThreshold();
        }
        missingTopStateMap.keySet().retainAll(resourceMap.keySet());
        lastTopStateMap.keySet().retainAll(resourceMap.keySet());
        for (Resource resource : resourceMap.values()) {
            StateModelDefinition stateModelDef = cache.getStateModelDef(resource.getStateModelDefRef());
            if (stateModelDef == null || resource.getStateModelDefRef().equalsIgnoreCase("Task")) continue;
            String resourceName = resource.getResourceName();
            for (Partition partition : resource.getPartitions()) {
                Map<String, String> stateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
                for (String instance : stateMap.keySet()) {
                    if (!stateMap.get(instance).equals(stateModelDef.getTopState())) continue;
                    if (!lastTopStateMap.containsKey(resourceName)) {
                        lastTopStateMap.put(resourceName, new HashMap());
                    }
                    lastTopStateMap.get(resourceName).put(partition.getPartitionName(), instance);
                    break;
                }
                if (stateMap.values().contains(stateModelDef.getTopState())) {
                    this.reportTopStateComesBack(cache, stateMap, missingTopStateMap, resourceName, partition, clusterStatusMonitor, durationThreshold, stateModelDef.getTopState());
                    continue;
                }
                this.reportNewTopStateMissing(cache, missingTopStateMap, lastTopStateMap, resourceName, partition, stateModelDef.getTopState(), currentStateOutput);
            }
        }
        for (String resourceName : missingTopStateMap.keySet()) {
            for (String partitionName : missingTopStateMap.get(resourceName).keySet()) {
                long startTime = missingTopStateMap.get(resourceName).get(partitionName);
                if (startTime <= 0L || System.currentTimeMillis() - startTime <= durationThreshold) continue;
                missingTopStateMap.get(resourceName).put(partitionName, -2L);
                if (clusterStatusMonitor == null) continue;
                clusterStatusMonitor.updateMissingTopStateDurationStats(resourceName, 0L, false);
            }
        }
        if (clusterStatusMonitor != null) {
            clusterStatusMonitor.resetMaxMissingTopStateGauge();
        }
    }

    private void reportNewTopStateMissing(ClusterDataCache cache, Map<String, Map<String, Long>> missingTopStateMap, Map<String, Map<String, String>> lastTopStateMap, String resourceName, Partition partition, String topState, CurrentStateOutput currentStateOutput) {
        Map<String, Long> partitionMap;
        if (missingTopStateMap.containsKey(resourceName) && missingTopStateMap.get(resourceName).containsKey(partition.getPartitionName())) {
            return;
        }
        long startTime = -1L;
        String missingStateInstance = null;
        if (lastTopStateMap.containsKey(resourceName)) {
            missingStateInstance = lastTopStateMap.get(resourceName).get(partition.getPartitionName());
        }
        if (missingStateInstance != null) {
            Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
            if (liveInstances.containsKey(missingStateInstance)) {
                CurrentState currentState = cache.getCurrentState(missingStateInstance, liveInstances.get(missingStateInstance).getSessionId()).get(resourceName);
                if (currentState != null && currentState.getPreviousState(partition.getPartitionName()) != null && currentState.getPreviousState(partition.getPartitionName()).equalsIgnoreCase(topState)) {
                    startTime = Math.max(startTime, currentState.getStartTime(partition.getPartitionName()));
                }
            } else {
                Map<String, Long> offlineMap = cache.getInstanceOfflineTimeMap();
                if (offlineMap.containsKey(missingStateInstance)) {
                    startTime = Math.max(startTime, offlineMap.get(missingStateInstance));
                }
            }
        }
        if (startTime == -1L) {
            for (Message message : currentStateOutput.getPendingMessageMap(resourceName, partition).values()) {
                if (!message.getToState().equals(topState)) continue;
                startTime = Math.max(startTime, message.getCreateTimeStamp());
            }
        }
        if (startTime == -1L) {
            LogUtil.logWarn(LOG, this._eventId, "Cannot confirm top state missing start time. Use the current system time as the start time.");
            startTime = System.currentTimeMillis();
        }
        if (!missingTopStateMap.containsKey(resourceName)) {
            missingTopStateMap.put(resourceName, new HashMap());
        }
        if (!(partitionMap = missingTopStateMap.get(resourceName)).containsKey(partition.getPartitionName())) {
            partitionMap.put(partition.getPartitionName(), startTime);
        }
    }

    private void reportTopStateComesBack(ClusterDataCache cache, Map<String, String> stateMap, Map<String, Map<String, Long>> missingTopStateMap, String resourceName, Partition partition, ClusterStatusMonitor clusterStatusMonitor, long threshold, String topState) {
        if (!missingTopStateMap.containsKey(resourceName) || !missingTopStateMap.get(resourceName).containsKey(partition.getPartitionName())) {
            return;
        }
        long handOffStartTime = missingTopStateMap.get(resourceName).get(partition.getPartitionName());
        long handOffEndTime = System.currentTimeMillis();
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        for (String instanceName : stateMap.keySet()) {
            CurrentState currentState = cache.getCurrentState(instanceName, liveInstances.get(instanceName).getSessionId()).get(resourceName);
            if (!currentState.getState(partition.getPartitionName()).equalsIgnoreCase(topState)) continue;
            handOffEndTime = Math.min(handOffEndTime, currentState.getEndTime(partition.getPartitionName()));
        }
        if (handOffStartTime > 0L && handOffEndTime - handOffStartTime <= threshold) {
            LogUtil.logInfo(LOG, this._eventId, String.format("Missing topstate duration is %d for partition %s", handOffEndTime - handOffStartTime, partition.getPartitionName()));
            if (clusterStatusMonitor != null) {
                clusterStatusMonitor.updateMissingTopStateDurationStats(resourceName, handOffEndTime - handOffStartTime, true);
            }
        }
        this.removeFromStatsMap(missingTopStateMap, resourceName, partition);
    }

    private void removeFromStatsMap(Map<String, Map<String, Long>> missingTopStateMap, String resourceName, Partition partition) {
        if (missingTopStateMap.containsKey(resourceName)) {
            missingTopStateMap.get(resourceName).remove(partition.getPartitionName());
        }
        if (missingTopStateMap.get(resourceName).size() == 0) {
            missingTopStateMap.remove(resourceName);
        }
    }
}

