/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadClusterDataStage
extends AbstractBaseStage {
    private static final Logger logger = LoggerFactory.getLogger((String)ReadClusterDataStage.class.getName());
    private ClusterDataCache _cache = null;

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        if (manager == null) {
            throw new StageException("HelixManager attribute value is null");
        }
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute(AttributeName.ClusterDataCache.name());
        if (cache == null && this._cache == null) {
            cache = new ClusterDataCache(event.getClusterName());
        }
        this._cache = cache;
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        this._cache.refresh(dataAccessor);
        final ClusterConfig clusterConfig = cache.getClusterConfig();
        if (!this._cache.isTaskCache()) {
            final ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
            ReadClusterDataStage.asyncExecute(this._cache.getAsyncTasksThreadPool(), new Callable<Object>(){

                @Override
                public Object call() {
                    if (clusterStatusMonitor != null) {
                        LogUtil.logDebug(logger, ReadClusterDataStage.this._eventId, "Update cluster status monitors");
                        HashSet instanceSet = Sets.newHashSet();
                        HashSet liveInstanceSet = Sets.newHashSet();
                        HashSet disabledInstanceSet = Sets.newHashSet();
                        HashMap disabledPartitions = Maps.newHashMap();
                        HashMap oldDisabledPartitions = Maps.newHashMap();
                        HashMap tags = Maps.newHashMap();
                        Map<String, LiveInstance> liveInstanceMap = ReadClusterDataStage.this._cache.getLiveInstances();
                        for (Map.Entry<String, InstanceConfig> e : ReadClusterDataStage.this._cache.getInstanceConfigMap().entrySet()) {
                            String instanceName = e.getKey();
                            InstanceConfig config = e.getValue();
                            instanceSet.add(instanceName);
                            if (liveInstanceMap.containsKey(instanceName)) {
                                liveInstanceSet.add(instanceName);
                            }
                            if (!config.getInstanceEnabled() || clusterConfig.getDisabledInstances() != null && clusterConfig.getDisabledInstances().containsKey(instanceName)) {
                                disabledInstanceSet.add(instanceName);
                            }
                            oldDisabledPartitions.put(instanceName, config.getDisabledPartitions());
                            disabledPartitions.put(instanceName, config.getDisabledPartitionsMap());
                            HashSet instanceTags = Sets.newHashSet(config.getTags());
                            tags.put(instanceName, instanceTags);
                        }
                        clusterStatusMonitor.setClusterInstanceStatus(liveInstanceSet, instanceSet, disabledInstanceSet, disabledPartitions, oldDisabledPartitions, tags);
                        LogUtil.logDebug(logger, ReadClusterDataStage.this._eventId, "Complete cluster status monitors update.");
                    }
                    return null;
                }
            });
        }
        event.addAttribute(AttributeName.ClusterDataCache.name(), this._cache);
    }
}

