/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerProperties;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.MessageThrottleStageOutput;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAssignmentStage
extends AbstractBaseStage {
    private static Logger logger = LoggerFactory.getLogger(TaskAssignmentStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        ClusterStatusMonitor clusterStatusMonitor;
        this._eventId = event.getEventId();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        MessageThrottleStageOutput messageOutput = (MessageThrottleStageOutput)event.getAttribute(AttributeName.MESSAGES_THROTTLE.name());
        ClusterDataCache cache = (ClusterDataCache)event.getAttribute(AttributeName.ClusterDataCache.name());
        Map<String, LiveInstance> liveInstanceMap = cache.getLiveInstances();
        if (manager == null || resourceMap == null || messageOutput == null || cache == null || liveInstanceMap == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires HelixManager|RESOURCES|MESSAGES_THROTTLE|DataCache|liveInstanceMap");
        }
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        ArrayList<Message> messagesToSend = new ArrayList<Message>();
        for (String resourceName : resourceMap.keySet()) {
            Resource resource = (Resource)resourceMap.get(resourceName);
            for (Partition partition : resource.getPartitions()) {
                List<Message> messages = messageOutput.getMessages(resourceName, partition);
                messagesToSend.addAll(messages);
            }
        }
        List<Message> outputMessages = this.batchMessage(dataAccessor.keyBuilder(), messagesToSend, resourceMap, liveInstanceMap, manager.getProperties());
        this.sendMessages(dataAccessor, outputMessages);
        if (!cache.isTaskCache() && (clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name())) != null) {
            clusterStatusMonitor.increaseMessageReceived(outputMessages);
        }
        long cacheStart = System.currentTimeMillis();
        cache.cacheMessages(outputMessages);
        long cacheEnd = System.currentTimeMillis();
        LogUtil.logDebug(logger, this._eventId, "Caching messages took " + (cacheEnd - cacheStart) + " ms");
    }

    List<Message> batchMessage(PropertyKey.Builder keyBuilder, List<Message> messages, Map<String, Resource> resourceMap, Map<String, LiveInstance> liveInstanceMap, HelixManagerProperties properties) {
        HashMap<String, Message> batchMessages = new HashMap<String, Message>();
        ArrayList<Message> outputMessages = new ArrayList<Message>();
        for (Message message : messages) {
            String resourceName = message.getResourceName();
            Resource resource = resourceMap.get(resourceName);
            String instanceName = message.getTgtName();
            LiveInstance liveInstance = liveInstanceMap.get(instanceName);
            String participantVersion = null;
            if (liveInstance != null) {
                participantVersion = liveInstance.getHelixVersion();
            }
            if (resource == null || !resource.getBatchMessageMode() || participantVersion == null || !properties.isFeatureSupported("batch_message", participantVersion)) {
                outputMessages.add(message);
                continue;
            }
            String key = keyBuilder.currentState(message.getTgtName(), message.getTgtSessionId(), message.getResourceName()).getPath() + "/" + message.getFromState() + "/" + message.getToState();
            if (!batchMessages.containsKey(key)) {
                Message batchMessage = new Message(message.getRecord());
                batchMessage.setBatchMessageMode(true);
                outputMessages.add(batchMessage);
                batchMessages.put(key, batchMessage);
            }
            ((Message)batchMessages.get(key)).addPartitionName(message.getPartitionName());
        }
        return outputMessages;
    }

    protected void sendMessages(HelixDataAccessor dataAccessor, List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
        for (Message message : messages) {
            LogUtil.logInfo(logger, this._eventId, "Sending Message " + message.getMsgId() + " to " + message.getTgtName() + " transit " + message.getResourceName() + "." + message.getPartitionName() + "|" + message.getPartitionNames() + " from:" + message.getFromState() + " to:" + message.getToState() + ", relayMessages: " + message.getRelayMessages().size());
            if (message.hasRelayMessages()) {
                for (Message msg : message.getRelayMessages().values()) {
                    LogUtil.logInfo(logger, this._eventId, "Sending Relay Message " + msg.getMsgId() + " to " + msg.getTgtName() + " transit " + msg.getResourceName() + "." + msg.getPartitionName() + "|" + msg.getPartitionNames() + " from:" + msg.getFromState() + " to:" + msg.getToState() + ", relayFrom: " + msg.getRelaySrcHost() + ", attached to message: " + message.getMsgId());
                }
            }
            keys.add(keyBuilder.message(message.getTgtName(), message.getId()));
        }
        dataAccessor.createChildren(keys, new ArrayList<Message>(messages));
    }
}

