/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.Map;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveInstance
extends HelixProperty {
    private static final Logger _logger = LoggerFactory.getLogger((String)LiveInstance.class.getName());

    public LiveInstance(String id) {
        super(id);
    }

    public LiveInstance(ZNRecord record) {
        super(record);
    }

    public void setSessionId(String sessionId) {
        this._record.setSimpleField(LiveInstanceProperty.SESSION_ID.toString(), sessionId);
    }

    public String getSessionId() {
        return this._record.getSimpleField(LiveInstanceProperty.SESSION_ID.toString());
    }

    public String getInstanceName() {
        return this._record.getId();
    }

    public String getHelixVersion() {
        return this._record.getSimpleField(LiveInstanceProperty.HELIX_VERSION.toString());
    }

    public void setHelixVersion(String helixVersion) {
        this._record.setSimpleField(LiveInstanceProperty.HELIX_VERSION.toString(), helixVersion);
    }

    public String getLiveInstance() {
        return this._record.getSimpleField(LiveInstanceProperty.LIVE_INSTANCE.toString());
    }

    public void setLiveInstance(String liveInstance) {
        this._record.setSimpleField(LiveInstanceProperty.LIVE_INSTANCE.toString(), liveInstance);
    }

    public Map<String, String> getResourceCapacityMap() {
        return this._record.getMapField(LiveInstanceProperty.RESOURCE_CAPACITY.name());
    }

    public void setResourceCapacityMap(Map<String, String> resourceQuotaMap) {
        this._record.setMapField(LiveInstanceProperty.RESOURCE_CAPACITY.name(), resourceQuotaMap);
    }

    public long getModifiedTime() {
        return this._record.getModifiedTime();
    }

    public String getWebserviceUrl() {
        return this._record.getSimpleField(LiveInstanceProperty.ZKPROPERTYTRANSFERURL.toString());
    }

    public void setWebserviceUrl(String url) {
        this._record.setSimpleField(LiveInstanceProperty.ZKPROPERTYTRANSFERURL.toString(), url);
    }

    @Override
    public boolean isValid() {
        if (this.getSessionId() == null) {
            _logger.error("liveInstance does not have session id. id:" + this._record.getId());
            return false;
        }
        if (this.getHelixVersion() == null) {
            _logger.error("liveInstance does not have CLM verion. id:" + this._record.getId());
            return false;
        }
        return true;
    }

    public static enum InstanceResourceType {
        TASK_EXEC_THREAD;

    }

    public static enum LiveInstanceProperty {
        SESSION_ID,
        HELIX_VERSION,
        LIVE_INSTANCE,
        ZKPROPERTYTRANSFERURL,
        RESOURCE_CAPACITY;

    }
}

