/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.helix.model.Message;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;

public class MessageLatencyMonitor
extends DynamicMBeanProvider {
    private static final String MBEAN_DESCRIPTION = "Helix Message Latency Monitor";
    private final String _sensorName;
    private final String _domainName;
    private final String _participantName;
    private SimpleDynamicMetric<Long> _totalMessageCount;
    private SimpleDynamicMetric<Long> _totalMessageLatency;
    private HistogramDynamicMetric _messageLatencyGauge;

    public MessageLatencyMonitor(String domainName, String participantName) throws JMException {
        this._domainName = domainName;
        this._participantName = participantName;
        this._sensorName = String.format("%s.%s", "ParticipantMessageStatus", "MessageLatency");
        this._messageLatencyGauge = new HistogramDynamicMetric("MessagelatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(3600000L, TimeUnit.MILLISECONDS)));
        this._totalMessageLatency = new SimpleDynamicMetric<Long>("TotalMessageLatency", 0L);
        this._totalMessageCount = new SimpleDynamicMetric<Long>("TotalMessageCount", 0L);
    }

    @Override
    public String getSensorName() {
        return this._sensorName;
    }

    public void updateLatency(Message message) {
        long latency = System.currentTimeMillis() - message.getCreateTimeStamp();
        this._logger.info(String.format("The latency of message %s is %d ms", message.getMsgId(), latency));
        this._totalMessageCount.updateValue(this._totalMessageCount.getValue() + 1L);
        this._totalMessageLatency.updateValue(this._totalMessageLatency.getValue() + latency);
        this._messageLatencyGauge.updateValue(latency);
    }

    @Override
    public MessageLatencyMonitor register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._totalMessageCount);
        attributeList.add(this._totalMessageLatency);
        attributeList.add(this._messageLatencyGauge);
        this.doRegister(attributeList, MBEAN_DESCRIPTION, this._domainName, "ParticipantName", this._participantName, "MonitorType", MessageLatencyMonitor.class.getSimpleName());
        return this;
    }
}

