/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import java.util.Map;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyType;
import org.apache.helix.common.caches.BasicClusterDataCache;
import org.apache.helix.common.caches.CurrentStateCache;
import org.apache.helix.common.caches.TargetExternalViewCache;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoutingDataCache
extends BasicClusterDataCache {
    private static Logger LOG = LoggerFactory.getLogger((String)RoutingDataCache.class.getName());
    private final PropertyType _sourceDataType;
    private CurrentStateCache _currentStateCache;
    private TargetExternalViewCache _targetExternalViewCache;

    public RoutingDataCache(String clusterName, PropertyType sourceDataType) {
        super(clusterName);
        this._sourceDataType = sourceDataType;
        this._currentStateCache = new CurrentStateCache(clusterName);
        this._targetExternalViewCache = new TargetExternalViewCache(clusterName);
        this.requireFullRefresh();
    }

    @Override
    public synchronized void refresh(HelixDataAccessor accessor) {
        long start;
        LOG.info("START: RoutingDataCache.refresh() for cluster " + this._clusterName);
        long startTime = System.currentTimeMillis();
        super.refresh(accessor);
        if (this._sourceDataType.equals((Object)PropertyType.TARGETEXTERNALVIEW) && ((Boolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW)).booleanValue()) {
            start = System.currentTimeMillis();
            this._propertyDataChangedMap.put(HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW, false);
            this._targetExternalViewCache.refresh(accessor);
            LOG.info("Reload " + this._targetExternalViewCache.getExternalViewMap().keySet().size() + " TargetExternalViews. Takes " + (System.currentTimeMillis() - start) + " ms");
        }
        if (this._sourceDataType.equals((Object)PropertyType.CURRENTSTATES) && ((Boolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CURRENT_STATE)).booleanValue()) {
            start = System.currentTimeMillis();
            Map<String, LiveInstance> liveInstanceMap = this.getLiveInstances();
            this._currentStateCache.refresh(accessor, liveInstanceMap);
            LOG.info("Reload CurrentStates. Takes " + (System.currentTimeMillis() - start) + " ms");
        }
        long endTime = System.currentTimeMillis();
        LOG.info("END: RoutingDataCache.refresh() for cluster " + this._clusterName + ", took " + (endTime - startTime) + " ms");
        if (LOG.isDebugEnabled()) {
            LOG.debug("CurrentStates: " + this._currentStateCache);
            LOG.debug("TargetExternalViews: " + this._targetExternalViewCache.getExternalViewMap());
        }
    }

    public Map<String, ExternalView> getTargetExternalViews() {
        return this._targetExternalViewCache.getExternalViewMap();
    }

    public Map<String, Map<String, Map<String, CurrentState>>> getCurrentStatesMap() {
        return this._currentStateCache.getCurrentStatesMap();
    }
}

