/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.common.caches.TaskDataCache;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.assigner.AssignableInstance;
import org.apache.helix.task.assigner.TaskAssignResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignableInstanceManager {
    private static final Logger LOG = LoggerFactory.getLogger(AssignableInstanceManager.class);
    private Map<String, AssignableInstance> _assignableInstanceMap = new ConcurrentHashMap<String, AssignableInstance>();
    private Map<String, TaskAssignResult> _taskAssignResultMap = new ConcurrentHashMap<String, TaskAssignResult>();

    public void buildAssignableInstances(ClusterConfig clusterConfig, TaskDataCache taskDataCache, Map<String, LiveInstance> liveInstances, Map<String, InstanceConfig> instanceConfigs) {
        this._assignableInstanceMap.clear();
        this._taskAssignResultMap.clear();
        for (Map.Entry<String, LiveInstance> liveInstanceEntry : liveInstances.entrySet()) {
            String instanceName = liveInstanceEntry.getKey();
            LiveInstance liveInstance = liveInstanceEntry.getValue();
            if (!instanceConfigs.containsKey(instanceName)) continue;
            InstanceConfig instanceConfig = instanceConfigs.get(instanceName);
            AssignableInstance assignableInstance = new AssignableInstance(clusterConfig, instanceConfig, liveInstance);
            this._assignableInstanceMap.put(instanceConfig.getInstanceName(), assignableInstance);
            LOG.info("AssignableInstance created for instance: {}", (Object)instanceName);
        }
        Map<String, JobConfig> jobConfigMap = taskDataCache.getJobConfigMap();
        for (String jobName : jobConfigMap.keySet()) {
            JobConfig jobConfig = jobConfigMap.get(jobName);
            JobContext jobContext = taskDataCache.getJobContext(jobName);
            if (jobConfig == null || jobContext == null) {
                LOG.warn("JobConfig or JobContext for this job is null. Skipping this job! Job name: {}, JobConfig: {}, JobContext: {}", new Object[]{jobName, jobConfig, jobContext});
                continue;
            }
            String quotaType = jobConfig.getJobType();
            if (quotaType == null) {
                quotaType = "DEFAULT";
            }
            Set<Integer> taskIndices = jobContext.getPartitionSet();
            for (int taskIndex : taskIndices) {
                TaskPartitionState taskState = jobContext.getPartitionState(taskIndex);
                if (taskState != TaskPartitionState.INIT && taskState != TaskPartitionState.RUNNING) continue;
                String assignedInstance = jobContext.getAssignedParticipant(taskIndex);
                String taskId = jobContext.getTaskIdForPartition(taskIndex);
                if (taskId == null) {
                    taskId = String.format("%s_%s", jobConfig.getJobId(), taskIndex);
                }
                if (assignedInstance == null) {
                    LOG.warn("This task's TaskContext does not have an assigned instance! Task will be ignored. Job: {}, TaskId: {}, TaskIndex: {}", new Object[]{jobContext.getName(), taskId, taskIndex});
                    continue;
                }
                if (this._assignableInstanceMap.containsKey(assignedInstance)) {
                    TaskConfig taskConfig = jobConfig.getTaskConfig(taskId);
                    AssignableInstance assignableInstance = this._assignableInstanceMap.get(assignedInstance);
                    TaskAssignResult taskAssignResult = assignableInstance.restoreTaskAssignResult(taskId, taskConfig, quotaType);
                    if (!taskAssignResult.isSuccessful()) continue;
                    this._taskAssignResultMap.put(taskId, taskAssignResult);
                    LOG.info("TaskAssignResult restored for taskId: {}, assigned on instance: {}", (Object)taskId, (Object)assignedInstance);
                    continue;
                }
                LOG.warn("While building AssignableInstance map, discovered that the instance a task is assigned to is no longer a LiveInstance! TaskAssignResult will not be created and no resource will be taken up for this task. Job: {}, TaskId: {}, TaskIndex: {}, Instance: {}", new Object[]{jobContext.getName(), taskId, taskIndex, assignedInstance});
            }
        }
    }

    public void updateAssignableInstances(ClusterConfig clusterConfig, Map<String, LiveInstance> liveInstances, Map<String, InstanceConfig> instanceConfigs) {
        HashSet<AssignableInstance> staleAssignableInstances = new HashSet<AssignableInstance>(this._assignableInstanceMap.values());
        for (Map.Entry<String, LiveInstance> liveInstanceEntry : liveInstances.entrySet()) {
            String instanceName = liveInstanceEntry.getKey();
            LiveInstance liveInstance = liveInstanceEntry.getValue();
            if (!instanceConfigs.containsKey(instanceName)) continue;
            InstanceConfig instanceConfig = instanceConfigs.get(instanceName);
            if (this._assignableInstanceMap.containsKey(instanceName)) {
                this._assignableInstanceMap.get(instanceName).updateConfigs(clusterConfig, instanceConfig, liveInstance);
            } else {
                AssignableInstance assignableInstance = new AssignableInstance(clusterConfig, instanceConfig, liveInstance);
                this._assignableInstanceMap.put(instanceName, assignableInstance);
                LOG.info("AssignableInstance created for instance: {} during updateAssignableInstances", (Object)instanceName);
            }
            staleAssignableInstances.remove(this._assignableInstanceMap.get(instanceName));
        }
        for (AssignableInstance instanceToBeRemoved : staleAssignableInstances) {
            for (String taskToRemove : instanceToBeRemoved.getCurrentAssignments()) {
                if (!this._taskAssignResultMap.containsKey(taskToRemove) || !this._taskAssignResultMap.get(taskToRemove).getAssignableInstance().getInstanceName().equals(instanceToBeRemoved.getInstanceName())) continue;
                this._taskAssignResultMap.remove(taskToRemove);
                LOG.info("TaskAssignResult removed because its assigned instance is no longer live. TaskID: {}, instance: {}", (Object)taskToRemove, (Object)instanceToBeRemoved.getInstanceName());
            }
            this._assignableInstanceMap.remove(instanceToBeRemoved.getInstanceName());
            LOG.info("Non-live AssignableInstance removed for instance: {} during updateAssignableInstances", (Object)instanceToBeRemoved.getInstanceName());
        }
    }

    public Map<String, AssignableInstance> getAssignableInstanceMap() {
        return Collections.unmodifiableMap(this._assignableInstanceMap);
    }

    public Set<AssignableInstance> getAssignableInstancesForQuotaType(String quotaType) {
        return Collections.unmodifiableSet(new HashSet<AssignableInstance>(this._assignableInstanceMap.values()));
    }

    public Map<String, TaskAssignResult> getTaskAssignResultMap() {
        return this._taskAssignResultMap;
    }
}

