/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.AbstractTaskDispatcher;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.FixedTargetTaskAssignmentCalculator;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TargetState;
import org.apache.helix.task.TaskAssignmentCalculator;
import org.apache.helix.task.TaskPartitionState;
import org.apache.helix.task.TaskRebalancer;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.ThreadCountBasedTaskAssignmentCalculator;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.task.assigner.ThreadCountBasedTaskAssigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRebalancer
extends TaskRebalancer {
    private static final Logger LOG = LoggerFactory.getLogger(JobRebalancer.class);
    private static final String PREV_RA_NODE = "PreviousResourceAssignment";

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache clusterData, IdealState taskIs, Resource resource, CurrentStateOutput currStateOutput) {
        Set<String> liveInstances;
        ResourceAssignment prevAssignment;
        String jobName = resource.getResourceName();
        LOG.debug("Computer Best Partition for job: " + jobName);
        JobConfig jobCfg = clusterData.getJobConfig(jobName);
        if (jobCfg == null) {
            LOG.error("Job configuration is NULL for " + jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        String workflowResource = jobCfg.getWorkflow();
        WorkflowConfig workflowCfg = clusterData.getWorkflowConfig(workflowResource);
        if (workflowCfg == null) {
            LOG.error("Workflow configuration is NULL for " + jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        WorkflowContext workflowCtx = clusterData.getWorkflowContext(workflowResource);
        if (workflowCtx == null) {
            LOG.error("Workflow context is NULL for " + jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        TargetState targetState = workflowCfg.getTargetState();
        if (targetState != TargetState.START && targetState != TargetState.STOP) {
            LOG.info("Target state is " + targetState.name() + " for workflow " + workflowResource + ".Stop scheduling job " + jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        TaskState workflowState = workflowCtx.getWorkflowState();
        TaskState jobState = workflowCtx.getJobState(jobName);
        if (workflowState == TaskState.FAILED || workflowState == TaskState.COMPLETED || jobState == TaskState.FAILED || jobState == TaskState.COMPLETED) {
            LOG.info(String.format("Workflow %s or job %s is already failed or completed, workflow state (%s), job state (%s), clean up job IS.", new Object[]{workflowResource, jobName, workflowState, jobState}));
            TaskUtil.cleanupJobIdealStateExtView(this._manager.getHelixDataAccessor(), jobName);
            _rebalanceScheduler.removeScheduledRebalance(jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        if (!this.isWorkflowReadyForSchedule(workflowCfg)) {
            LOG.info("Job is not ready to be run since workflow is not ready " + jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        if (!TaskUtil.isJobStarted(jobName, workflowCtx) && !this.isJobReadyToSchedule(jobName, workflowCfg, workflowCtx, TaskUtil.getInCompleteJobCount(workflowCfg, workflowCtx), clusterData.getJobConfigMap(), clusterData)) {
            LOG.info("Job is not ready to run " + jobName);
            return this.buildEmptyAssignment(jobName, currStateOutput);
        }
        JobContext jobCtx = clusterData.getJobContext(jobName);
        if (jobCtx == null) {
            jobCtx = new JobContext(new ZNRecord("TaskContext"));
            jobCtx.setStartTime(System.currentTimeMillis());
            jobCtx.setName(jobName);
            workflowCtx.setJobState(jobName, TaskState.IN_PROGRESS);
        }
        if (!TaskState.TIMED_OUT.equals((Object)workflowCtx.getJobState(jobName))) {
            this.scheduleRebalanceForTimeout(jobCfg.getJobId(), jobCtx.getStartTime(), jobCfg.getTimeout());
        }
        if ((prevAssignment = this.getPrevResourceAssignment(jobName)) == null) {
            prevAssignment = new ResourceAssignment(jobName);
        }
        Set<String> set = liveInstances = jobCfg.getInstanceGroupTag() == null ? clusterData.getEnabledLiveInstances() : clusterData.getEnabledLiveInstancesWithTag(jobCfg.getInstanceGroupTag());
        if (liveInstances.isEmpty()) {
            LOG.error("No available instance found for job!");
        }
        TargetState jobTgtState = workflowCfg.getTargetState();
        jobState = workflowCtx.getJobState(jobName);
        workflowState = workflowCtx.getWorkflowState();
        if (jobState == TaskState.IN_PROGRESS && (this.isTimeout(jobCtx.getStartTime(), jobCfg.getTimeout()) || TaskState.TIMED_OUT.equals((Object)workflowState))) {
            jobState = TaskState.TIMING_OUT;
            workflowCtx.setJobState(jobName, TaskState.TIMING_OUT);
        } else if (jobState != TaskState.TIMING_OUT && jobState != TaskState.FAILING) {
            if (jobTgtState == TargetState.STOP) {
                if (TaskUtil.checkJobStopped(jobCtx)) {
                    workflowCtx.setJobState(jobName, TaskState.STOPPED);
                } else {
                    workflowCtx.setJobState(jobName, TaskState.STOPPING);
                }
                if (this.isWorkflowStopped(workflowCtx, workflowCfg)) {
                    workflowCtx.setWorkflowState(TaskState.STOPPED);
                } else {
                    workflowCtx.setWorkflowState(TaskState.STOPPING);
                }
            } else {
                workflowCtx.setJobState(jobName, TaskState.IN_PROGRESS);
                workflowCtx.setWorkflowState(TaskState.IN_PROGRESS);
            }
        }
        TreeSet<Integer> partitionsToDrop = new TreeSet<Integer>();
        ResourceAssignment newAssignment = this.computeResourceMapping(jobName, workflowCfg, jobCfg, jobState, jobTgtState, prevAssignment, liveInstances, currStateOutput, workflowCtx, jobCtx, partitionsToDrop, clusterData);
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        PropertyKey propertyKey = accessor.keyBuilder().idealStates(jobName);
        taskIs = clusterData.getIdealState(jobName);
        if (!partitionsToDrop.isEmpty() && taskIs != null) {
            for (Integer pId : partitionsToDrop) {
                taskIs.getRecord().getMapFields().remove(this.pName(jobName, pId));
            }
            accessor.setProperty(propertyKey, taskIs);
        }
        clusterData.updateJobContext(jobName, jobCtx, this._manager.getHelixDataAccessor());
        clusterData.updateWorkflowContext(workflowResource, workflowCtx, this._manager.getHelixDataAccessor());
        this.setPrevResourceAssignment(jobName, newAssignment);
        LOG.debug("Job " + jobName + " new assignment " + Arrays.toString(newAssignment.getMappedPartitions().toArray()));
        return newAssignment;
    }

    private ResourceAssignment computeResourceMapping(String jobResource, WorkflowConfig workflowConfig, JobConfig jobCfg, TaskState jobState, TargetState jobTgtState, ResourceAssignment prevTaskToInstanceStateAssignment, Collection<String> liveInstances, CurrentStateOutput currStateOutput, WorkflowContext workflowCtx, JobContext jobCtx, Set<Integer> partitionsToDropFromIs, ClusterDataCache cache) {
        HashSet<Integer> assignedPartitions = new HashSet<Integer>();
        HashSet<Integer> skippedPartitions = new HashSet<Integer>();
        TreeMap<Integer, AbstractTaskDispatcher.PartitionAssignment> paMap = new TreeMap<Integer, AbstractTaskDispatcher.PartitionAssignment>();
        Set<String> excludedInstances = this.getExcludedInstances(jobResource, workflowConfig, workflowCtx, cache);
        TaskAssignmentCalculator taskAssignmentCal = this.getAssignmentCalculator(jobCfg, cache);
        Set<Integer> allPartitions = taskAssignmentCal.getAllTaskPartitions(jobCfg, jobCtx, workflowConfig, workflowCtx, cache.getIdealStates());
        if (allPartitions == null || allPartitions.isEmpty()) {
            String failureMsg = "Empty task partition mapping for job " + jobResource + ", marked the job as FAILED!";
            LOG.info(failureMsg);
            jobCtx.setInfo(failureMsg);
            this.failJob(jobResource, workflowCtx, jobCtx, workflowConfig, cache.getJobConfigMap(), cache);
            JobRebalancer.markAllPartitionsError(jobCtx, TaskPartitionState.ERROR, false);
            return new ResourceAssignment(jobResource);
        }
        Map<String, SortedSet<Integer>> prevInstanceToTaskAssignments = JobRebalancer.getPrevInstanceToTaskAssignments(liveInstances, prevTaskToInstanceStateAssignment, allPartitions);
        long currentTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("All partitions: " + allPartitions + " taskAssignment: " + prevInstanceToTaskAssignments + " excludedInstances: " + excludedInstances);
        }
        this.updatePreviousAssignedTasksStatus(prevInstanceToTaskAssignments, excludedInstances, jobResource, currStateOutput, jobCtx, jobCfg, prevTaskToInstanceStateAssignment, jobState, assignedPartitions, partitionsToDropFromIs, paMap, jobTgtState, skippedPartitions, cache);
        JobRebalancer.addGiveupPartitions(skippedPartitions, jobCtx, allPartitions, jobCfg);
        if (jobState == TaskState.IN_PROGRESS && skippedPartitions.size() > jobCfg.getFailureThreshold() || jobCfg.getTargetResource() != null && cache.getIdealState(jobCfg.getTargetResource()) != null && !cache.getIdealState(jobCfg.getTargetResource()).isEnabled()) {
            if (this.isJobFinished(jobCtx, jobResource, currStateOutput)) {
                this.failJob(jobResource, workflowCtx, jobCtx, workflowConfig, cache.getJobConfigMap(), cache);
                return this.buildEmptyAssignment(jobResource, currStateOutput);
            }
            workflowCtx.setJobState(jobResource, TaskState.FAILING);
            for (int pId : jobCtx.getPartitionSet()) {
                String instance = jobCtx.getAssignedParticipant(pId);
                if (jobCtx.getPartitionState(pId) != null && !JobRebalancer.isTaskGivenup(jobCtx, jobCfg, pId)) {
                    paMap.put(pId, new AbstractTaskDispatcher.PartitionAssignment(instance, TaskPartitionState.TASK_ABORTED.name()));
                }
                Partition partition = new Partition(this.pName(jobResource, pId));
                Message pendingMessage = currStateOutput.getPendingState(jobResource, partition, instance);
                if (jobCtx.getPartitionState(pId) != TaskPartitionState.INIT || pendingMessage == null) continue;
                paMap.put(pId, new AbstractTaskDispatcher.PartitionAssignment(instance, TaskPartitionState.INIT.name()));
            }
            return this.toResourceAssignment(jobResource, paMap);
        }
        if (jobState == TaskState.FAILING && this.isJobFinished(jobCtx, jobResource, currStateOutput)) {
            this.failJob(jobResource, workflowCtx, jobCtx, workflowConfig, cache.getJobConfigMap(), cache);
            return this.buildEmptyAssignment(jobResource, currStateOutput);
        }
        if (JobRebalancer.isJobComplete(jobCtx, allPartitions, jobCfg)) {
            this.markJobComplete(jobResource, jobCtx, workflowConfig, workflowCtx, cache.getJobConfigMap(), cache);
            this._clusterStatusMonitor.updateJobCounters(jobCfg, TaskState.COMPLETED, jobCtx.getFinishTime() - jobCtx.getStartTime());
            _rebalanceScheduler.removeScheduledRebalance(jobResource);
            TaskUtil.cleanupJobIdealStateExtView(this._manager.getHelixDataAccessor(), jobResource);
            return this.buildEmptyAssignment(jobResource, currStateOutput);
        }
        if (jobState == TaskState.TIMING_OUT && this.isJobFinished(jobCtx, jobResource, currStateOutput)) {
            this.handleJobTimeout(jobCtx, workflowCtx, jobResource, jobCfg);
            return this.buildEmptyAssignment(jobResource, currStateOutput);
        }
        this.scheduleForNextTask(jobResource, jobCtx, currentTime);
        if (jobState != TaskState.TIMING_OUT && jobState != TaskState.TIMED_OUT && jobTgtState == TargetState.START) {
            this.handleAdditionalTaskAssignment(prevInstanceToTaskAssignments, excludedInstances, jobResource, currStateOutput, jobCtx, jobCfg, workflowConfig, workflowCtx, cache, prevTaskToInstanceStateAssignment, assignedPartitions, paMap, skippedPartitions, taskAssignmentCal, allPartitions, currentTime, liveInstances);
        }
        return this.toResourceAssignment(jobResource, paMap);
    }

    private ResourceAssignment toResourceAssignment(String jobResource, Map<Integer, AbstractTaskDispatcher.PartitionAssignment> paMap) {
        ResourceAssignment ra = new ResourceAssignment(jobResource);
        for (Map.Entry<Integer, AbstractTaskDispatcher.PartitionAssignment> e : paMap.entrySet()) {
            AbstractTaskDispatcher.PartitionAssignment pa = e.getValue();
            ra.addReplicaMap(new Partition(this.pName(jobResource, e.getKey())), (Map<String, String>)ImmutableMap.of((Object)pa._instance, (Object)pa._state));
        }
        return ra;
    }

    private boolean isJobFinished(JobContext jobContext, String jobResource, CurrentStateOutput currentStateOutput) {
        for (int pId : jobContext.getPartitionSet()) {
            TaskPartitionState state = jobContext.getPartitionState(pId);
            Partition partition = new Partition(this.pName(jobResource, pId));
            String instance = jobContext.getAssignedParticipant(pId);
            Message pendingMessage = currentStateOutput.getPendingState(jobResource, partition, instance);
            if (state != TaskPartitionState.RUNNING && (state != TaskPartitionState.INIT || pendingMessage == null)) continue;
            return false;
        }
        return true;
    }

    private ResourceAssignment getPrevResourceAssignment(String resourceName) {
        ZNRecord r = (ZNRecord)this._manager.getHelixPropertyStore().get(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)resourceName, new Object[]{PREV_RA_NODE}), null, AccessOption.PERSISTENT);
        return r != null ? new ResourceAssignment(r) : null;
    }

    private void setPrevResourceAssignment(String resourceName, ResourceAssignment ra) {
        this._manager.getHelixPropertyStore().set(Joiner.on((String)"/").join((Object)"/TaskRebalancer", (Object)resourceName, new Object[]{PREV_RA_NODE}), ra.getRecord(), AccessOption.PERSISTENT);
    }

    private static boolean isJobComplete(JobContext ctx, Set<Integer> allPartitions, JobConfig cfg) {
        int numOfGivenUpTasks = 0;
        for (Integer pId : allPartitions) {
            TaskPartitionState state = ctx.getPartitionState(pId);
            if (state == TaskPartitionState.COMPLETED) continue;
            if (!JobRebalancer.isTaskGivenup(ctx, cfg, pId)) {
                return false;
            }
            ++numOfGivenUpTasks;
        }
        return numOfGivenUpTasks <= cfg.getFailureThreshold();
    }

    private static Map<String, SortedSet<Integer>> getPrevInstanceToTaskAssignments(Iterable<String> liveInstances, ResourceAssignment prevAssignment, Set<Integer> allTaskPartitions) {
        HashMap<String, SortedSet<Integer>> result = new HashMap<String, SortedSet<Integer>>();
        for (String instance : liveInstances) {
            result.put(instance, new TreeSet());
        }
        for (Partition partition : prevAssignment.getMappedPartitions()) {
            int pId = TaskUtil.getPartitionId(partition.getPartitionName());
            if (!allTaskPartitions.contains(pId)) continue;
            Map<String, String> replicaMap = prevAssignment.getReplicaMap(partition);
            for (String instance : replicaMap.keySet()) {
                SortedSet pList = (SortedSet)result.get(instance);
                if (pList == null) continue;
                pList.add(pId);
            }
        }
        return result;
    }

    private TaskAssignmentCalculator getAssignmentCalculator(JobConfig jobConfig, ClusterDataCache cache) {
        AssignableInstanceManager assignableInstanceManager = cache.getAssignableInstanceManager();
        if (TaskUtil.isGenericTaskJob(jobConfig)) {
            return new ThreadCountBasedTaskAssignmentCalculator(new ThreadCountBasedTaskAssigner(), assignableInstanceManager);
        }
        return new FixedTargetTaskAssignmentCalculator(assignableInstanceManager);
    }
}

