/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.AbstractTaskDispatcher;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskRebalancer
extends AbstractTaskDispatcher
implements Rebalancer,
MappingCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRebalancer.class);

    @Override
    public void init(HelixManager manager) {
        this._manager = manager;
    }

    @Override
    public abstract ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache var1, IdealState var2, Resource var3, CurrentStateOutput var4);

    protected boolean isWorkflowStopped(WorkflowContext ctx, WorkflowConfig cfg) {
        for (String job : cfg.getJobDag().getAllNodes()) {
            TaskState jobState = ctx.getJobState(job);
            if (jobState == null || !jobState.equals((Object)TaskState.IN_PROGRESS) && !jobState.equals((Object)TaskState.STOPPING)) continue;
            return false;
        }
        return true;
    }

    protected ResourceAssignment buildEmptyAssignment(String name, CurrentStateOutput currStateOutput) {
        ResourceAssignment assignment = new ResourceAssignment(name);
        Set<Partition> partitions = currStateOutput.getCurrentStateMappedPartitions(name);
        for (Partition partition : partitions) {
            Map<String, String> currentStateMap = currStateOutput.getCurrentStateMap(name, partition);
            HashMap replicaMap = Maps.newHashMap();
            for (String instanceName : currentStateMap.keySet()) {
                replicaMap.put(instanceName, HelixDefinedState.DROPPED.toString());
            }
            assignment.addReplicaMap(partition, replicaMap);
        }
        return assignment;
    }

    protected boolean isJobReadyToSchedule(String job, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, int incompleteAllCount, Map<String, JobConfig> jobConfigMap, ClusterDataCache clusterDataCache) {
        int notStartedCount = 0;
        int failedOrTimeoutCount = 0;
        int incompleteParentCount = 0;
        for (String parent : workflowCfg.getJobDag().getDirectParents(job)) {
            TaskState jobState = workflowCtx.getJobState(parent);
            if (jobState == null || jobState == TaskState.NOT_STARTED) {
                ++notStartedCount;
                continue;
            }
            if (jobState == TaskState.FAILED || jobState == TaskState.TIMED_OUT) {
                ++failedOrTimeoutCount;
                continue;
            }
            if (jobState == TaskState.COMPLETED) continue;
            ++incompleteParentCount;
        }
        if (notStartedCount > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Job %s is not ready to start, notStartedParent(s)=%d.", job, notStartedCount));
            }
            return false;
        }
        JobConfig jobConfig = jobConfigMap.get(job);
        if (jobConfig == null) {
            LOG.error(String.format("The job config is missing for job %s", job));
            return false;
        }
        if (failedOrTimeoutCount > 0 && !jobConfig.isIgnoreDependentJobFailure()) {
            this.markJobFailed(job, null, workflowCfg, workflowCtx, jobConfigMap, clusterDataCache);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Job %s is not ready to start, failedCount(s)=%d.", job, failedOrTimeoutCount));
            }
            return false;
        }
        if (workflowCfg.isJobQueue()) {
            if (incompleteAllCount >= workflowCfg.getParallelJobs()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Job %s is not ready to schedule, inCompleteJobs(s)=%d.", job, incompleteAllCount));
                }
                return false;
            }
        } else if (incompleteParentCount > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Job %s is not ready to start, notFinishedParent(s)=%d.", job, incompleteParentCount));
            }
            return false;
        }
        return true;
    }

    protected boolean isWorkflowReadyForSchedule(WorkflowConfig workflowCfg) {
        Date startTime = workflowCfg.getStartTime();
        return startTime == null || startTime.getTime() <= System.currentTimeMillis();
    }

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        return currentIdealState;
    }
}

