/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task.assigner;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.assigner.AssignableInstance;
import org.apache.helix.task.assigner.TaskAssignResult;
import org.apache.helix.task.assigner.TaskAssigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadCountBasedTaskAssigner
implements TaskAssigner {
    private static final Logger logger = LoggerFactory.getLogger(ThreadCountBasedTaskAssigner.class);
    private static final int SCHED_QUEUE_INIT_CAPACITY = 200;
    private static final String DEFAULT_QUOTA_TYPE = "DEFAULT";

    @Override
    public Map<String, TaskAssignResult> assignTasks(Iterable<AssignableInstance> assignableInstances, Iterable<TaskConfig> tasks) {
        return this.assignTasks(assignableInstances, tasks, DEFAULT_QUOTA_TYPE);
    }

    @Override
    public Map<String, TaskAssignResult> assignTasks(Iterable<AssignableInstance> assignableInstances, Iterable<TaskConfig> tasks, String quotaType) {
        if (tasks == null || !tasks.iterator().hasNext()) {
            logger.warn("No task to assign!");
            return Collections.emptyMap();
        }
        if (assignableInstances == null || !assignableInstances.iterator().hasNext()) {
            logger.warn("No instance to assign!");
            return this.buildNoInstanceAssignment(tasks, quotaType);
        }
        if (quotaType == null || quotaType.equals("") || quotaType.equals("null")) {
            logger.warn("Quota type is null. Assigning it as DEFAULT type!");
            quotaType = DEFAULT_QUOTA_TYPE;
        }
        logger.info("Assigning tasks with quota type {}", (Object)quotaType);
        PriorityQueue<AssignableInstance> queue = this.buildSchedQueue(quotaType, assignableInstances);
        HashMap<String, TaskAssignResult> assignResults = new HashMap<String, TaskAssignResult>();
        TaskAssignResult lastFailure = null;
        for (TaskConfig task : tasks) {
            if (assignResults.containsKey(task.getId())) {
                logger.warn("Duplicated task assignment {}", (Object)task);
                continue;
            }
            if (lastFailure != null) {
                assignResults.put(task.getId(), new TaskAssignResult(task, quotaType, null, false, lastFailure.getFitnessScore(), lastFailure.getFailureReason(), lastFailure.getFailureDescription()));
                continue;
            }
            AssignableInstance instance = queue.poll();
            TaskAssignResult result = instance.tryAssign(task, quotaType);
            assignResults.put(task.getId(), result);
            if (!result.isSuccessful()) {
                lastFailure = result;
                continue;
            }
            instance.assign(result);
            queue.offer(instance);
        }
        logger.info("Finished assigning tasks with quota type {}", (Object)quotaType);
        return assignResults;
    }

    private PriorityQueue<AssignableInstance> buildSchedQueue(String quotaType, Iterable<AssignableInstance> instances) {
        AssignableInstanceComparator comparator = new AssignableInstanceComparator(quotaType);
        PriorityQueue<AssignableInstance> queue = new PriorityQueue<AssignableInstance>(200, comparator);
        for (AssignableInstance assignableInstance : instances) {
            queue.offer(assignableInstance);
        }
        return queue;
    }

    private Map<String, TaskAssignResult> buildNoInstanceAssignment(Iterable<TaskConfig> tasks, String quotaType) {
        HashMap<String, TaskAssignResult> result = new HashMap<String, TaskAssignResult>();
        for (TaskConfig taskConfig : tasks) {
            result.put(taskConfig.getId(), new TaskAssignResult(taskConfig, quotaType, null, false, 0, TaskAssignResult.FailureReason.INSUFFICIENT_QUOTA, "No assignable instance to assign"));
        }
        return result;
    }

    private class AssignableInstanceComparator
    implements Comparator<AssignableInstance> {
        private final String RESOURCE_TYPE = LiveInstance.InstanceResourceType.TASK_EXEC_THREAD.name();
        private final String _quotaType;

        public AssignableInstanceComparator(String quotaType) {
            this._quotaType = quotaType;
        }

        @Override
        public int compare(AssignableInstance o1, AssignableInstance o2) {
            Integer o1RemainingCapacity = this.getRemainingUsage(o1.getTotalCapacity(), o1.getUsedCapacity());
            Integer o2RemainingCapacity = this.getRemainingUsage(o2.getTotalCapacity(), o2.getUsedCapacity());
            return o2RemainingCapacity - o1RemainingCapacity;
        }

        private Integer getRemainingUsage(Map<String, Map<String, Integer>> capacity, Map<String, Map<String, Integer>> used) {
            if (capacity.containsKey(this.RESOURCE_TYPE) && capacity.get(this.RESOURCE_TYPE).containsKey(this._quotaType)) {
                return capacity.get(this.RESOURCE_TYPE).get(this._quotaType) - used.get(this.RESOURCE_TYPE).get(this._quotaType);
            }
            return 0;
        }
    }
}

