/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateCalcStage;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ClusterEventType;
import org.apache.helix.controller.stages.CurrentStateComputationStage;
import org.apache.helix.controller.stages.ResourceComputationStage;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.tools.ClusterVerifiers.ZkHelixClusterVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestPossibleExternalViewVerifier
extends ZkHelixClusterVerifier {
    private static Logger LOG = LoggerFactory.getLogger(BestPossibleExternalViewVerifier.class);
    private final Map<String, Map<String, String>> _errStates;
    private final Set<String> _resources;
    private final Set<String> _expectLiveInstances;
    private final ClusterDataCache _clusterDataCache;

    public BestPossibleExternalViewVerifier(String zkAddr, String clusterName, Set<String> resources, Map<String, Map<String, String>> errStates, Set<String> expectLiveInstances) {
        super(zkAddr, clusterName);
        this._errStates = errStates;
        this._resources = resources;
        this._expectLiveInstances = expectLiveInstances;
        this._clusterDataCache = new ClusterDataCache();
    }

    public BestPossibleExternalViewVerifier(ZkClient zkClient, String clusterName, Set<String> resources, Map<String, Map<String, String>> errStates, Set<String> expectLiveInstances) {
        super(zkClient, clusterName);
        this._errStates = errStates;
        this._resources = resources;
        this._expectLiveInstances = expectLiveInstances;
        this._clusterDataCache = new ClusterDataCache();
    }

    @Override
    public boolean verify(long timeout) {
        return this.verifyByZkCallback(timeout);
    }

    @Override
    public boolean verifyByZkCallback(long timeout) {
        ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger> triggers = new ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger>();
        if (this._resources != null && !this._resources.isEmpty()) {
            for (String resource : this._resources) {
                triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.idealStates(resource), true, false, false));
                triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.externalView(resource), true, false, false));
            }
        } else {
            triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.idealStates(), false, true, true));
            triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.externalViews(), false, true, true));
        }
        return this.verifyByCallback(timeout, triggers);
    }

    @Override
    protected synchronized boolean verifyState() {
        try {
            Set<String> actualLiveNodes;
            PropertyKey.Builder keyBuilder = this._accessor.keyBuilder();
            this._clusterDataCache.requireFullRefresh();
            this._clusterDataCache.refresh(this._accessor);
            HashMap<String, IdealState> idealStates = new HashMap<String, IdealState>(this._clusterDataCache.getIdealStates());
            Iterator it = idealStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                if (!((IdealState)pair.getValue()).getStateModelDefRef().equals("Task")) continue;
                it.remove();
            }
            if (this._expectLiveInstances != null && !this._expectLiveInstances.isEmpty() && !this._expectLiveInstances.equals(actualLiveNodes = this._clusterDataCache.getLiveInstances().keySet())) {
                LOG.warn("Live instances are not as expected. Actual live nodes: " + actualLiveNodes.toString());
                return false;
            }
            Map<String, Object> extViews = this._accessor.getChildValuesMap(keyBuilder.externalViews());
            if (extViews == null) {
                extViews = Collections.emptyMap();
            }
            if (this._resources != null && !this._resources.isEmpty()) {
                idealStates.keySet().retainAll(this._resources);
                extViews.keySet().retainAll(this._resources);
            }
            for (String resource : extViews.keySet()) {
                if (idealStates.containsKey(resource)) continue;
                ExternalView ev = (ExternalView)extViews.get(resource);
                IdealState is = new IdealState(resource);
                is.getRecord().setSimpleFields(ev.getRecord().getSimpleFields());
                idealStates.put(resource, is);
            }
            BestPossibleStateOutput bestPossOutput = this.calcBestPossState(this._clusterDataCache, this._resources);
            Map<String, Map<Partition, Map<String, String>>> bestPossStateMap = bestPossOutput.getStateMap();
            if (this._errStates != null) {
                for (String resourceName : this._errStates.keySet()) {
                    Map<String, String> partErrStates = this._errStates.get(resourceName);
                    for (String partitionName : partErrStates.keySet()) {
                        String instanceName = partErrStates.get(partitionName);
                        if (!bestPossStateMap.containsKey(resourceName)) {
                            bestPossStateMap.put(resourceName, new HashMap());
                        }
                        Partition partition = new Partition(partitionName);
                        if (!bestPossStateMap.get(resourceName).containsKey(partition)) {
                            bestPossStateMap.get(resourceName).put(partition, new HashMap());
                        }
                        bestPossStateMap.get(resourceName).get(partition).put(instanceName, HelixDefinedState.ERROR.toString());
                    }
                }
            }
            for (String resourceName : idealStates.keySet()) {
                IdealState is = (IdealState)idealStates.get(resourceName);
                ExternalView extView = (ExternalView)extViews.get(resourceName);
                if (extView == null) {
                    if (is.isExternalViewDisabled()) continue;
                    LOG.warn("externalView for " + resourceName + " is not available, check if best possible state is available.");
                    extView = new ExternalView(resourceName);
                }
                PartitionStateMap bpStateMap = bestPossOutput.getPartitionStateMap(resourceName);
                StateModelDefinition stateModelDef = this._clusterDataCache.getStateModelDef(is.getStateModelDefRef());
                if (stateModelDef == null) {
                    LOG.error("State model definition " + is.getStateModelDefRef() + " for resource not found!" + is.getResourceName());
                    return false;
                }
                boolean result = this.verifyExternalView(extView, bpStateMap, stateModelDef);
                if (result) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("verifyExternalView fails for " + resourceName + "! ExternalView: " + extView + " BestPossibleState: " + bpStateMap);
                } else {
                    LOG.warn("verifyExternalView fails for " + resourceName + "! ExternalView does not match BestPossibleState");
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("exception in verification", (Throwable)e);
            return false;
        }
    }

    private boolean verifyExternalView(ExternalView externalView, PartitionStateMap bestPossibleState, StateModelDefinition stateModelDef) {
        HashSet<String> ignoreStates = new HashSet<String>(Arrays.asList(stateModelDef.getInitialState(), HelixDefinedState.DROPPED.toString()));
        Map<String, Map<String, String>> bestPossibleStateMap = this.convertBestPossibleState(bestPossibleState);
        this.removeEntryWithIgnoredStates(bestPossibleStateMap.entrySet().iterator(), ignoreStates);
        Map<String, Map<String, String>> externalViewMap = externalView.getRecord().getMapFields();
        this.removeEntryWithIgnoredStates(externalViewMap.entrySet().iterator(), ignoreStates);
        return externalViewMap.equals(bestPossibleStateMap);
    }

    private void removeEntryWithIgnoredStates(Iterator<Map.Entry<String, Map<String, String>>> partitionInstanceStateMapIter, Set<String> ignoredStates) {
        while (partitionInstanceStateMapIter.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = partitionInstanceStateMapIter.next();
            Map<String, String> instanceStateMap = entry.getValue();
            if (instanceStateMap.isEmpty()) {
                partitionInstanceStateMapIter.remove();
                continue;
            }
            Iterator<Map.Entry<String, String>> insIter = instanceStateMap.entrySet().iterator();
            while (insIter.hasNext()) {
                String state = insIter.next().getValue();
                if (!ignoredStates.contains(state)) continue;
                insIter.remove();
            }
        }
    }

    private Map<String, Map<String, String>> convertBestPossibleState(PartitionStateMap bestPossibleState) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Partition partition : bestPossibleState.getStateMap().keySet()) {
            result.put(partition.getPartitionName(), bestPossibleState.getPartitionMap(partition));
        }
        return result;
    }

    private BestPossibleStateOutput calcBestPossState(ClusterDataCache cache, Set<String> resources) throws Exception {
        ClusterEvent event = new ClusterEvent(ClusterEventType.StateVerifier);
        event.addAttribute(AttributeName.ClusterDataCache.name(), cache);
        this.runStage(event, new ResourceComputationStage());
        if (resources != null && !resources.isEmpty()) {
            Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.name());
            resourceMap.keySet().retainAll(resources);
            event.addAttribute(AttributeName.RESOURCES.name(), resourceMap);
            Map resourceMapToRebalance = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
            resourceMapToRebalance.keySet().retainAll(resources);
            event.addAttribute(AttributeName.RESOURCES_TO_REBALANCE.name(), resourceMapToRebalance);
        }
        this.runStage(event, new CurrentStateComputationStage());
        this.runStage(event, new BestPossibleStateCalcStage());
        BestPossibleStateOutput output = (BestPossibleStateOutput)event.getAttribute(AttributeName.BEST_POSSIBLE_STATE.name());
        return output;
    }

    private void runStage(ClusterEvent event, Stage stage) throws Exception {
        StageContext context = new StageContext();
        stage.init(context);
        stage.preProcess();
        stage.process(event);
        stage.postProcess();
    }

    public String toString() {
        String verifierName = this.getClass().getSimpleName();
        return verifierName + "(" + this._clusterName + "@" + this._zkClient + "@resources[" + (this._resources != null ? Arrays.toString(this._resources.toArray()) : "") + "])";
    }

    public static class Builder {
        private String _clusterName;
        private Map<String, Map<String, String>> _errStates;
        private Set<String> _resources;
        private Set<String> _expectLiveInstances;
        private String _zkAddr;
        private ZkClient _zkClient;

        public Builder(String clusterName) {
            this._clusterName = clusterName;
        }

        public BestPossibleExternalViewVerifier build() {
            if (this._clusterName == null || this._zkAddr == null && this._zkClient == null) {
                throw new IllegalArgumentException("Cluster name or zookeeper info is missing!");
            }
            if (this._zkClient != null) {
                return new BestPossibleExternalViewVerifier(this._zkClient, this._clusterName, this._resources, this._errStates, this._expectLiveInstances);
            }
            return new BestPossibleExternalViewVerifier(this._zkAddr, this._clusterName, this._resources, this._errStates, this._expectLiveInstances);
        }

        public String getClusterName() {
            return this._clusterName;
        }

        public Map<String, Map<String, String>> getErrStates() {
            return this._errStates;
        }

        public Builder setErrStates(Map<String, Map<String, String>> errStates) {
            this._errStates = errStates;
            return this;
        }

        public Set<String> getResources() {
            return this._resources;
        }

        public Builder setResources(Set<String> resources) {
            this._resources = resources;
            return this;
        }

        public Set<String> getExpectLiveInstances() {
            return this._expectLiveInstances;
        }

        public Builder setExpectLiveInstances(Set<String> expectLiveInstances) {
            this._expectLiveInstances = expectLiveInstances;
            return this;
        }

        public String getZkAddr() {
            return this._zkAddr;
        }

        public Builder setZkAddr(String zkAddr) {
            this._zkAddr = zkAddr;
            return this;
        }

        public ZkClient getZkClient() {
            return this._zkClient;
        }

        public Builder setZkClient(ZkClient zkClient) {
            this._zkClient = zkClient;
            return this;
        }
    }
}

