/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.ClusterVerifiers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.tools.ClusterVerifiers.ZkHelixClusterVerifier;

public class ClusterLiveNodesVerifier
extends ZkHelixClusterVerifier {
    final Set<String> _expectLiveNodes;

    public ClusterLiveNodesVerifier(ZkClient zkclient, String clusterName, List<String> expectLiveNodes) {
        super(zkclient, clusterName);
        this._expectLiveNodes = new HashSet<String>(expectLiveNodes);
    }

    @Override
    public boolean verifyByZkCallback(long timeout) {
        ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger> triggers = new ArrayList<ZkHelixClusterVerifier.ClusterVerifyTrigger>();
        triggers.add(new ZkHelixClusterVerifier.ClusterVerifyTrigger(this._keyBuilder.liveInstances(), false, true, true));
        return this.verifyByCallback(timeout, triggers);
    }

    @Override
    protected boolean verifyState() throws Exception {
        HashSet<String> actualLiveNodes = new HashSet<String>(this._accessor.getChildNames(this._keyBuilder.liveInstances()));
        return this._expectLiveNodes.equals(actualLiveNodes);
    }
}

