/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.store.PropertyJsonComparator;
import org.apache.helix.store.PropertyJsonSerializer;
import org.apache.helix.store.PropertyStoreException;
import org.apache.helix.tools.TestCommand;
import org.apache.helix.tools.TestTrigger;
import org.apache.helix.tools.ZnodeOpArg;
import org.apache.helix.tools.ZnodeValue;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecutor {
    private static Logger logger = LoggerFactory.getLogger(TestExecutor.class);
    private static final long SLEEP_TIME = 500L;
    private static final PropertyJsonComparator<String> STRING_COMPARATOR = new PropertyJsonComparator<String>(String.class);
    private static final PropertyJsonSerializer<ZNRecord> ZNRECORD_SERIALIZER = new PropertyJsonSerializer<ZNRecord>(ZNRecord.class);

    private static ZnodeModValueType getValueType(ZnodePropertyType type, String key) {
        ZnodeModValueType valueType = ZnodeModValueType.INVALID;
        switch (type) {
            case SIMPLE: {
                if (key == null) {
                    logger.warn("invalid key for simple field: key is null");
                    break;
                }
                String[] keyParts = key.split("/");
                if (keyParts.length != 1) {
                    logger.warn("invalid key for simple field: " + key + ", expect 1 part: key1 (no slash)");
                    break;
                }
                valueType = ZnodeModValueType.SINGLE_VALUE;
                break;
            }
            case LIST: {
                if (key == null) {
                    logger.warn("invalid key for simple field: key is null");
                    break;
                }
                String[] keyParts = key.split("/");
                if (keyParts.length < 1 || keyParts.length > 2) {
                    logger.warn("invalid key for list field: " + key + ", expect 1 or 2 parts: key1 or key1/index)");
                    break;
                }
                if (keyParts.length == 1) {
                    valueType = ZnodeModValueType.LIST_VALUE;
                    break;
                }
                try {
                    int index = Integer.parseInt(keyParts[1]);
                    if (index < 0) {
                        logger.warn("invalid key for list field: " + key + ", index < 0");
                        break;
                    }
                    valueType = ZnodeModValueType.SINGLE_VALUE;
                }
                catch (NumberFormatException e) {
                    logger.warn("invalid key for list field: " + key + ", part-2 is NOT an integer");
                }
                break;
            }
            case MAP: {
                if (key == null) {
                    logger.warn("invalid key for simple field: key is null");
                    break;
                }
                String[] keyParts = key.split("/");
                if (keyParts.length < 1 || keyParts.length > 2) {
                    logger.warn("invalid key for map field: " + key + ", expect 1 or 2 parts: key1 or key1/key2)");
                    break;
                }
                if (keyParts.length == 1) {
                    valueType = ZnodeModValueType.MAP_VALUE;
                    break;
                }
                valueType = ZnodeModValueType.SINGLE_VALUE;
                break;
            }
            case ZNODE: {
                valueType = ZnodeModValueType.ZNODE_VALUE;
            }
        }
        return valueType;
    }

    private static String getSingleValue(ZNRecord record, ZnodePropertyType type, String key) {
        if (record == null || key == null) {
            return null;
        }
        String value = null;
        String[] keyParts = key.split("/");
        switch (type) {
            case SIMPLE: {
                value = record.getSimpleField(key);
                break;
            }
            case LIST: {
                List<String> list = record.getListField(keyParts[0]);
                if (list == null) {
                    logger.warn("invalid key for list field: " + key + ", map for key part-1 doesn't exist");
                    return null;
                }
                int idx = Integer.parseInt(keyParts[1]);
                value = list.get(idx);
                break;
            }
            case MAP: {
                Map<String, String> map = record.getMapField(keyParts[0]);
                if (map == null) {
                    logger.warn("invalid key for map field: " + key + ", map for key part-1 doesn't exist");
                    return null;
                }
                value = map.get(keyParts[1]);
                break;
            }
        }
        return value;
    }

    private static List<String> getListValue(ZNRecord record, String key) {
        if (record == null) {
            return null;
        }
        return record.getListField(key);
    }

    private static Map<String, String> getMapValue(ZNRecord record, String key) {
        return record.getMapField(key);
    }

    private static boolean compareSingleValue(String actual, String expect, String key, ZNRecord diff) {
        boolean ret;
        boolean bl = ret = STRING_COMPARATOR.compare(actual, expect) == 0;
        if (diff != null) {
            diff.setSimpleField(key + "/expect", expect);
            diff.setSimpleField(key + "/actual", actual);
        }
        return ret;
    }

    private static boolean compareListValue(List<String> actualList, List<String> expectList, String key, ZNRecord diff) {
        boolean ret = true;
        if (actualList == null && expectList == null) {
            ret = true;
        } else if (actualList == null && expectList != null) {
            ret = false;
            if (diff != null) {
                diff.setListField(key + "/expect", expectList);
            }
        } else if (actualList != null && expectList == null) {
            ret = false;
            if (diff != null) {
                diff.setListField(key + "/actual", actualList);
            }
        } else {
            String actual;
            Iterator<String> itrActual = actualList.iterator();
            Iterator<String> itrExpect = expectList.iterator();
            if (diff != null && diff.getListField(key + "/expect") == null) {
                diff.setListField(key + "/expect", new ArrayList<String>());
            }
            if (diff != null && diff.getListField(key + "/actual") == null) {
                diff.setListField(key + "/actual", new ArrayList<String>());
            }
            while (itrActual.hasNext() && itrExpect.hasNext()) {
                String expect;
                actual = itrActual.next();
                if (STRING_COMPARATOR.compare(actual, expect = itrExpect.next()) == 0) continue;
                ret = false;
                if (diff == null) continue;
                diff.getListField(key + "/expect").add(expect);
                diff.getListField(key + "/actual").add(actual);
            }
            while (itrActual.hasNext()) {
                actual = itrActual.next();
                if (diff == null) continue;
                diff.getListField(key + "/actual").add(actual);
            }
            while (itrExpect.hasNext()) {
                String expect = itrExpect.next();
                if (diff == null) continue;
                diff.getListField(key + "/expect").add(expect);
            }
        }
        return ret;
    }

    private static void setMapField(ZNRecord record, String key1, String key2, String value) {
        if (record.getMapField(key1) == null) {
            record.setMapField(key1, new TreeMap<String, String>());
        }
        record.getMapField(key1).put(key2, value);
    }

    private static boolean compareMapValue(Map<String, String> actualMap, Map<String, String> expectMap, String mapKey, ZNRecord diff) {
        boolean ret = true;
        if (actualMap == null && expectMap == null) {
            ret = true;
        } else if (actualMap == null && expectMap != null) {
            ret = false;
            if (diff != null) {
                diff.setMapField(mapKey + "/expect", expectMap);
            }
        } else if (actualMap != null && expectMap == null) {
            ret = false;
            if (diff != null) {
                diff.setMapField(mapKey + "/actual", actualMap);
            }
        } else {
            for (String key : actualMap.keySet()) {
                String actual = actualMap.get(key);
                if (!expectMap.containsKey(key)) {
                    ret = false;
                    if (diff == null) continue;
                    TestExecutor.setMapField(diff, mapKey + "/actual", key, actual);
                    continue;
                }
                String expect = expectMap.get(key);
                if (STRING_COMPARATOR.compare(actual, expect) == 0) continue;
                ret = false;
                if (diff == null) continue;
                TestExecutor.setMapField(diff, mapKey + "/actual", key, actual);
                TestExecutor.setMapField(diff, mapKey + "/expect", key, expect);
            }
            for (String key : expectMap.keySet()) {
                String expect = expectMap.get(key);
                if (!actualMap.containsKey(key)) {
                    ret = false;
                    if (diff == null) continue;
                    TestExecutor.setMapField(diff, mapKey + "/expect", key, expect);
                    continue;
                }
                String actual = actualMap.get(key);
                if (STRING_COMPARATOR.compare(actual, expect) == 0) continue;
                ret = false;
                if (diff == null) continue;
                TestExecutor.setMapField(diff, mapKey + "/actual", key, actual);
                TestExecutor.setMapField(diff, mapKey + "/expect", key, expect);
            }
        }
        return ret;
    }

    private static void setZNRecord(ZNRecord diff, ZNRecord record, String keySuffix) {
        if (diff == null || record == null) {
            return;
        }
        for (String key : record.getSimpleFields().keySet()) {
            diff.setSimpleField(key + "/" + keySuffix, record.getSimpleField(key));
        }
        for (String key : record.getListFields().keySet()) {
            diff.setListField(key + "/" + keySuffix, record.getListField(key));
        }
        for (String key : record.getMapFields().keySet()) {
            diff.setMapField(key + "/" + keySuffix, record.getMapField(key));
        }
    }

    private static boolean compareZnodeValue(ZNRecord actual, ZNRecord expect, ZNRecord diff) {
        boolean ret = true;
        if (actual == null && expect == null) {
            ret = true;
        } else if (actual == null && expect != null) {
            ret = false;
            if (diff != null) {
                TestExecutor.setZNRecord(diff, expect, "expect");
            }
        } else if (actual != null && expect == null) {
            ret = false;
            if (diff != null) {
                TestExecutor.setZNRecord(diff, actual, "actual");
            }
        } else {
            for (String key : actual.getSimpleFields().keySet()) {
                if (TestExecutor.compareSingleValue(actual.getSimpleField(key), expect.getSimpleField(key), key, diff)) continue;
                ret = false;
            }
            for (String key : expect.getMapFields().keySet()) {
                if (!actual.getMapFields().containsKey(key)) {
                    if (diff == null) continue;
                    ret = false;
                    diff.setMapField(key + "/expect", expect.getMapField(key));
                    continue;
                }
                if (TestExecutor.compareMapValue(actual.getMapField(key), expect.getMapField(key), key, diff)) continue;
                ret = false;
            }
            for (String key : actual.getMapFields().keySet()) {
                if (!expect.getMapFields().containsKey(key)) {
                    if (diff == null) continue;
                    ret = false;
                    diff.setMapField(key + "/actual", actual.getMapField(key));
                    continue;
                }
                if (TestExecutor.compareMapValue(actual.getMapField(key), expect.getMapField(key), key, diff)) continue;
                ret = false;
            }
        }
        return ret;
    }

    private static void resetZNRecord(ZNRecord record) {
        if (record != null) {
            record.getSimpleFields().clear();
            record.getListFields().clear();
            record.getMapFields().clear();
        }
    }

    private static boolean isValueExpected(ZNRecord current, ZnodePropertyType type, String key, ZnodeValue expect, ZNRecord diff) {
        if (expect == null) {
            return true;
        }
        boolean result = false;
        TestExecutor.resetZNRecord(diff);
        ZnodeModValueType valueType = TestExecutor.getValueType(type, key);
        switch (valueType) {
            case SINGLE_VALUE: {
                String singleValue = TestExecutor.getSingleValue(current, type, key);
                result = TestExecutor.compareSingleValue(singleValue, expect._singleValue, key, diff);
                break;
            }
            case LIST_VALUE: {
                List<String> listValue = TestExecutor.getListValue(current, key);
                result = TestExecutor.compareListValue(listValue, expect._listValue, key, diff);
                break;
            }
            case MAP_VALUE: {
                Map<String, String> mapValue = TestExecutor.getMapValue(current, key);
                result = TestExecutor.compareMapValue(mapValue, expect._mapValue, key, diff);
                break;
            }
            case ZNODE_VALUE: {
                result = TestExecutor.compareZnodeValue(current, expect._znodeValue, diff);
                break;
            }
            case INVALID: {
                break;
            }
        }
        return result;
    }

    private static void setSingleValue(ZNRecord record, ZnodePropertyType type, String key, String value) {
        String[] keyParts = key.split("/");
        switch (type) {
            case SIMPLE: {
                record.setSimpleField(key, value);
                break;
            }
            case LIST: {
                List<String> list = record.getListField(keyParts[0]);
                if (list == null) {
                    logger.warn("invalid key for list field: " + key + ", value for key part-1 doesn't exist");
                    return;
                }
                int idx = Integer.parseInt(keyParts[1]);
                list.remove(idx);
                list.add(idx, value);
                break;
            }
            case MAP: {
                Map<String, String> map = record.getMapField(keyParts[0]);
                if (map == null) {
                    logger.warn("invalid key for map field: " + key + ", value for key part-1 doesn't exist");
                    return;
                }
                map.put(keyParts[1], value);
                break;
            }
        }
    }

    private static void setListValue(ZNRecord record, String key, List<String> value) {
        record.setListField(key, value);
    }

    private static void setMapValue(ZNRecord record, String key, Map<String, String> value) {
        record.setMapField(key, value);
    }

    private static void removeSingleValue(ZNRecord record, ZnodePropertyType type, String key) {
        if (record == null) {
            return;
        }
        String[] keyParts = key.split("/");
        switch (type) {
            case SIMPLE: {
                record.getSimpleFields().remove(key);
                break;
            }
            case LIST: {
                List<String> list = record.getListField(keyParts[0]);
                if (list == null) {
                    logger.warn("invalid key for list field: " + key + ", value for key part-1 doesn't exist");
                    return;
                }
                int idx = Integer.parseInt(keyParts[1]);
                list.remove(idx);
                break;
            }
            case MAP: {
                Map<String, String> map = record.getMapField(keyParts[0]);
                if (map == null) {
                    logger.warn("invalid key for map field: " + key + ", value for key part-1 doesn't exist");
                    return;
                }
                map.remove(keyParts[1]);
                break;
            }
        }
    }

    private static void removeListValue(ZNRecord record, String key) {
        if (record == null || record.getListFields() == null) {
            record.getListFields().remove(key);
        }
    }

    private static void removeMapValue(ZNRecord record, String key) {
        record.getMapFields().remove(key);
    }

    private static boolean executeVerifier(ZNRecord actual, TestCommand command, ZNRecord diff) {
        ZnodeOpArg arg = command._znodeOpArg;
        ZnodeValue expectValue = command._trigger._expectValue;
        boolean result = TestExecutor.isValueExpected(actual, arg._propertyType, arg._key, expectValue, diff);
        String operation = arg._operation;
        if (operation.equals("!=")) {
            result = !result;
        } else if (!operation.equals("==")) {
            logger.warn("fail to execute (unsupport operation=" + operation + "):" + operation);
            result = false;
        }
        return result;
    }

    private static boolean compareAndSetZnode(ZnodeValue expect, ZnodeOpArg arg, ZkClient zkClient, ZNRecord diff) {
        String path = arg._znodePath;
        ZnodePropertyType type = arg._propertyType;
        String key = arg._key;
        boolean success = true;
        long backoffTime = 20L;
        for (int i = 0; i < 3; ++i) {
            block30: {
                try {
                    Stat stat = new Stat();
                    ZNRecord record = (ZNRecord)zkClient.readDataAndStat(path, stat, true);
                    if (!TestExecutor.isValueExpected(record, type, key, expect, diff)) break block30;
                    if (arg._operation.compareTo("+") == 0) {
                        if (record == null) {
                            record = new ZNRecord("default");
                        }
                        ZnodeModValueType valueType = TestExecutor.getValueType(arg._propertyType, arg._key);
                        switch (valueType) {
                            case SINGLE_VALUE: {
                                TestExecutor.setSingleValue(record, arg._propertyType, arg._key, arg._updateValue._singleValue);
                                break;
                            }
                            case LIST_VALUE: {
                                TestExecutor.setListValue(record, arg._key, arg._updateValue._listValue);
                                break;
                            }
                            case MAP_VALUE: {
                                TestExecutor.setMapValue(record, arg._key, arg._updateValue._mapValue);
                                break;
                            }
                            case ZNODE_VALUE: {
                                record = ZNRECORD_SERIALIZER.deserialize(ZNRECORD_SERIALIZER.serialize(arg._updateValue._znodeValue));
                                break;
                            }
                            case INVALID: {
                                break;
                            }
                        }
                    } else if (arg._operation.compareTo("-") == 0) {
                        ZnodeModValueType valueType = TestExecutor.getValueType(arg._propertyType, arg._key);
                        switch (valueType) {
                            case SINGLE_VALUE: {
                                TestExecutor.removeSingleValue(record, arg._propertyType, arg._key);
                                break;
                            }
                            case LIST_VALUE: {
                                TestExecutor.removeListValue(record, arg._key);
                                break;
                            }
                            case MAP_VALUE: {
                                TestExecutor.removeMapValue(record, arg._key);
                                break;
                            }
                            case ZNODE_VALUE: {
                                record = null;
                                break;
                            }
                            case INVALID: {
                                break;
                            }
                        }
                    } else {
                        logger.warn("fail to execute (unsupport operation): " + arg._operation);
                        success = false;
                    }
                    if (success) {
                        if (record == null) {
                            zkClient.delete(path);
                        } else {
                            try {
                                zkClient.createPersistent(path, true);
                            }
                            catch (ZkNodeExistsException e) {
                                // empty catch block
                            }
                            zkClient.writeData(path, record, stat.getVersion());
                        }
                        return true;
                    }
                    return false;
                }
                catch (ZkBadVersionException e) {
                }
                catch (PropertyStoreException e) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(backoffTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            backoffTime *= 2L;
        }
        return false;
    }

    private static Map<TestCommand, Boolean> executeTestHelper(List<TestCommand> commandList, String zkAddr, CountDownLatch countDown) {
        ConcurrentHashMap<TestCommand, Boolean> testResults = new ConcurrentHashMap<TestCommand, Boolean>();
        ZkClient zkClient = null;
        zkClient = new ZkClient(zkAddr, 60000);
        zkClient.setZkSerializer(new ZNRecordSerializer());
        Collections.sort(commandList, new Comparator<TestCommand>(){

            @Override
            public int compare(TestCommand o1, TestCommand o2) {
                return (int)(o1._trigger._startTime - o2._trigger._startTime);
            }
        });
        for (TestCommand command : commandList) {
            testResults.put(command, new Boolean(false));
            TestTrigger trigger = command._trigger;
            command._startTimestamp = System.currentTimeMillis() + trigger._startTime;
            new Thread(new ExecuteCommand(command._startTimestamp, command, countDown, zkClient, testResults)).start();
        }
        return testResults;
    }

    public static void executeTestAsync(List<TestCommand> commandList, String zkAddr) throws InterruptedException {
        CountDownLatch countDown = new CountDownLatch(commandList.size());
        TestExecutor.executeTestHelper(commandList, zkAddr, countDown);
    }

    public static Map<TestCommand, Boolean> executeTest(List<TestCommand> commandList, String zkAddr) throws InterruptedException {
        CountDownLatch countDown = new CountDownLatch(commandList.size());
        Map<TestCommand, Boolean> testResults = TestExecutor.executeTestHelper(commandList, zkAddr, countDown);
        countDown.await();
        return testResults;
    }

    private static class ExecuteCommand
    implements Runnable {
        private final TestCommand _command;
        private final long _startTime;
        private final ZkClient _zkClient;
        private final CountDownLatch _countDown;
        private final Map<TestCommand, Boolean> _testResults;

        public ExecuteCommand(long startTime, TestCommand command, CountDownLatch countDown, ZkClient zkClient, Map<TestCommand, Boolean> testResults) {
            this._startTime = startTime;
            this._command = command;
            this._countDown = countDown;
            this._zkClient = zkClient;
            this._testResults = testResults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean result = false;
            long now = System.currentTimeMillis();
            long timeout = now + this._command._trigger._timeout;
            ZNRecord diff = new ZNRecord("diff");
            try {
                if (now < this._startTime) {
                    Thread.sleep(this._startTime - now);
                }
                do {
                    ZnodeOpArg arg;
                    if (this._command._commandType == TestCommand.CommandType.MODIFY) {
                        ZnodeValue expectValue = this._command._trigger._expectValue;
                        arg = this._command._znodeOpArg;
                        result = TestExecutor.compareAndSetZnode(expectValue, arg, this._zkClient, diff);
                        if (result) {
                            this._command._finishTimestamp = System.currentTimeMillis();
                            this._testResults.put(this._command, true);
                            break;
                        }
                    } else if (this._command._commandType == TestCommand.CommandType.VERIFY) {
                        arg = this._command._znodeOpArg;
                        String znodePath = arg._znodePath;
                        ZNRecord record = (ZNRecord)this._zkClient.readData(znodePath, true);
                        result = TestExecutor.executeVerifier(record, this._command, diff);
                        if (result) {
                            this._command._finishTimestamp = System.currentTimeMillis();
                            this._testResults.put(this._command, true);
                            break;
                        }
                    } else {
                        if (this._command._commandType == TestCommand.CommandType.START) {
                            Thread thread = this._command._nodeOpArg._thread;
                            thread.start();
                            result = true;
                            this._command._finishTimestamp = System.currentTimeMillis();
                            logger.info("result:" + result + ", " + this._command.toString());
                            this._testResults.put(this._command, true);
                            break;
                        }
                        if (this._command._commandType == TestCommand.CommandType.STOP) {
                            HelixManager manager = this._command._nodeOpArg._manager;
                            manager.disconnect();
                            Thread thread = this._command._nodeOpArg._thread;
                            thread.interrupt();
                            result = true;
                            this._command._finishTimestamp = System.currentTimeMillis();
                            logger.info("result:" + result + ", " + this._command.toString());
                            this._testResults.put(this._command, true);
                            break;
                        }
                        throw new IllegalArgumentException("Unsupport command type (was " + (Object)((Object)this._command._commandType) + ")");
                    }
                    Thread.sleep(500L);
                } while ((now = System.currentTimeMillis()) <= timeout);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (!result) {
                    this._command._finishTimestamp = System.currentTimeMillis();
                    logger.error("result:" + result + ", diff: " + diff);
                }
                this._countDown.countDown();
                if (this._countDown.getCount() == 0L && this._zkClient != null && this._zkClient.getConnection() != null) {
                    this._zkClient.close();
                }
            }
        }
    }

    private static enum ZnodeModValueType {
        INVALID,
        SINGLE_VALUE,
        LIST_VALUE,
        MAP_VALUE,
        ZNODE_VALUE;

    }

    public static enum ZnodePropertyType {
        SIMPLE,
        LIST,
        MAP,
        ZNODE;

    }
}

