/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.commandtools;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.helix.AccessOption;
import org.apache.helix.manager.zk.ByteArraySerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkCopy {
    private static Logger logger = LoggerFactory.getLogger(ZkCopy.class);
    private static final String src = "src";
    private static final String dst = "dst";

    private static Options constructCmdLineOpt() {
        OptionBuilder.withLongOpt((String)src);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"source-URI (e.g. zk://localhost:2181/src-path");
        OptionBuilder.withDescription((String)"Provide source URI");
        Option srcOpt = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)dst);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withArgName((String)"destination-URI (e.g. zk://localhost:2181/dst-path");
        OptionBuilder.withDescription((String)"Provide destination URI");
        Option dstOpt = OptionBuilder.create();
        Options options = new Options();
        options.addOption(srcOpt);
        options.addOption(dstOpt);
        return options;
    }

    private static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + ZkCopy.class.getName(), cliOptions);
    }

    private static String concatenate(String path, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return path;
        }
        if (path.endsWith("/") || suffix.startsWith("/")) {
            return path + suffix;
        }
        return path + "/" + suffix;
    }

    private static void copy(ZkClient srcClient, String srcRootPath, ZkClient dstClient, String dstRootPath, List<String> paths) {
        ZkBaseDataAccessor srcAccessor = new ZkBaseDataAccessor(srcClient);
        ArrayList<String> readPaths = new ArrayList<String>();
        for (String path : paths) {
            readPaths.add(ZkCopy.concatenate(srcRootPath, path));
        }
        ArrayList<Stat> stats = new ArrayList<Stat>();
        List readData = srcAccessor.get(readPaths, stats, 0);
        ArrayList<String> writePaths = new ArrayList<String>();
        ArrayList writeData = new ArrayList();
        for (int i = 0; i < paths.size(); ++i) {
            if (((Stat)stats.get(i)).getEphemeralOwner() != 0L) {
                logger.warn("Skip copying ephemeral znode: " + (String)readPaths.get(i));
                continue;
            }
            writePaths.add(ZkCopy.concatenate(dstRootPath, paths.get(i)));
            writeData.add(readData.get(i));
        }
        if (writePaths.size() > 0) {
            ZkBaseDataAccessor dstAccessor = new ZkBaseDataAccessor(dstClient);
            boolean[] success = dstAccessor.createChildren(writePaths, writeData, AccessOption.PERSISTENT);
            ArrayList successPaths = new ArrayList();
            ArrayList failPaths = new ArrayList();
            for (int i = 0; i < success.length; ++i) {
                if (success[i]) {
                    successPaths.add(writePaths.get(i));
                    continue;
                }
                failPaths.add(writePaths.get(i));
            }
            if (!successPaths.isEmpty()) {
                System.out.println("Copy " + successPaths);
            }
            if (!failPaths.isEmpty()) {
                System.out.println("Skip " + failPaths);
            }
        }
    }

    private static void zkCopy(ZkClient srcClient, String srcRootPath, ZkClient dstClient, String dstRootPath) {
        if (!srcRootPath.equals("/") && srcRootPath.endsWith("/")) {
            srcRootPath = srcRootPath.substring(0, srcRootPath.length() - 1);
        }
        if (!dstRootPath.equals("/") && dstRootPath.endsWith("/")) {
            dstRootPath = dstRootPath.substring(0, dstRootPath.length() - 1);
        }
        PathUtils.validatePath((String)srcRootPath);
        PathUtils.validatePath((String)dstRootPath);
        if (srcRootPath.equals(dstRootPath)) {
            logger.info("srcPath == dstPath. Skip copying");
            return;
        }
        if (srcRootPath.startsWith(dstRootPath) || dstRootPath.startsWith(srcRootPath)) {
            throw new IllegalArgumentException("srcPath/dstPath can't be prefix of dstPath/srcPath, was srcPath: " + srcRootPath + ", dstPath: " + dstRootPath);
        }
        LinkedList<String> queue = new LinkedList<String>();
        String root = "";
        ZkCopy.copy(srcClient, srcRootPath, dstClient, dstRootPath, Arrays.asList(root));
        queue.add(root);
        while (!queue.isEmpty()) {
            String path = (String)queue.remove(0);
            String fromPath = ZkCopy.concatenate(srcRootPath, path);
            List<String> children = srcClient.getChildren(fromPath);
            ArrayList<String> paths = new ArrayList<String>();
            if (children == null || children.size() <= 0) continue;
            for (String child : children) {
                String childPath = ZkCopy.concatenate(path, child);
                paths.add(childPath);
            }
            ZkCopy.copy(srcClient, srcRootPath, dstClient, dstRootPath, paths);
            queue.addAll(paths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options cliOptions = ZkCopy.constructCmdLineOpt();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(cliOptions, args);
        }
        catch (ParseException pe) {
            System.err.println("CommandLineClient: failed to parse command-line options: " + pe.toString());
            ZkCopy.printUsage(cliOptions);
            System.exit(1);
        }
        URI srcUri = new URI(cmd.getOptionValue(src));
        URI dstUri = new URI(cmd.getOptionValue(dst));
        ZkCopyScheme srcScheme = ZkCopyScheme.valueOf(srcUri.getScheme());
        ZkCopyScheme dstScheme = ZkCopyScheme.valueOf(dstUri.getScheme());
        if (srcScheme == ZkCopyScheme.zk && dstScheme == ZkCopyScheme.zk) {
            String srcZkAddr = srcUri.getAuthority();
            String dstZkAddr = dstUri.getAuthority();
            org.apache.helix.manager.zk.zookeeper.ZkClient srcClient = null;
            org.apache.helix.manager.zk.zookeeper.ZkClient dstClient = null;
            try {
                if (srcZkAddr.equals(dstZkAddr)) {
                    srcClient = dstClient = new ZkClient(srcZkAddr, 30000, 60000, new ByteArraySerializer());
                } else {
                    srcClient = new ZkClient(srcZkAddr, 30000, 60000, new ByteArraySerializer());
                    dstClient = new ZkClient(dstZkAddr, 30000, 60000, new ByteArraySerializer());
                }
                String srcPath = srcUri.getPath();
                String dstPath = dstUri.getPath();
                ZkCopy.zkCopy((ZkClient)srcClient, srcPath, (ZkClient)dstClient, dstPath);
            }
            finally {
                if (srcClient != null) {
                    srcClient.close();
                }
                if (dstClient != null) {
                    dstClient.close();
                }
            }
        } else {
            System.err.println("Unsupported scheme. srcScheme: " + (Object)((Object)srcScheme) + ", dstScheme: " + (Object)((Object)dstScheme));
            System.exit(1);
        }
    }

    static enum ZkCopyScheme {
        zk;

    }
}

