/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.FileResource;

public class ResourcePath {
    final Package packageName;
    final String name;

    public ResourcePath(String string) {
        this.packageName = null;
        this.name = string;
    }

    public ResourcePath(Class<?> clazz, String string) {
        this.packageName = clazz.getPackage();
        this.name = string;
    }

    public ResourcePath(Package package_, String string) {
        this.packageName = package_;
        this.name = string;
    }

    public URL getURL() {
        if (this.packageName != null) {
            return FileResource.find(this.packageName, this.name);
        }
        return FileResource.find(this.name);
    }

    public InputStream openBinaryStream() throws XerialException, IOException {
        URL uRL = this.getURL();
        if (uRL == null) {
            throw new XerialException((ErrorCode)XerialErrorCode.RESOURCE_NOT_FOUND, this.toString());
        }
        return uRL.openStream();
    }

    public BufferedReader openCharacterStream() throws XerialException, IOException {
        return new BufferedReader(new InputStreamReader(this.openBinaryStream()));
    }

    public String getPath() {
        String string = this.packageName != null ? this.packageName.getName().replaceAll("\\.", "/") + "/" : "";
        return String.format("%s%s", string, this.name);
    }

    public String toString() {
        return this.getPath();
    }
}

