/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xerial.util.graph.Edge;

class EdgeTable<EdgeLabel> {
    private static final long serialVersionUID = 1L;
    TreeMap<Integer, EdgeLabel> _edgeTable = new TreeMap();
    TreeMap<Edge, Integer> _edgeIndex = new TreeMap();
    HashMap<Integer, TreeSet<Integer>> _outNodeListOfEachNode = new HashMap();
    HashMap<Integer, TreeSet<Integer>> _inNodeListOfEachNode = new HashMap();

    EdgeTable() {
    }

    public Collection<Integer> getEdgeIDSet() {
        return this._edgeTable.keySet();
    }

    protected int add(int n, EdgeLabel EdgeLabel, Edge edge) {
        Set<Integer> set = this.destNodeIDSet(edge.srcNodeID);
        Set<Integer> set2 = this.sourceNodeIDSet(edge.destNodeID);
        set.add(edge.destNodeID);
        set2.add(edge.srcNodeID);
        this._edgeIndex.put(edge, n);
        this._edgeTable.put(n, EdgeLabel);
        return n;
    }

    public int add(Edge edge, EdgeLabel EdgeLabel) {
        if (this.hasEdge(edge)) {
            return this.getEdgeID(edge);
        }
        int n = this._edgeIndex.size() + 1;
        return this.add(n, EdgeLabel, edge);
    }

    public void setEdge(Edge edge, EdgeLabel EdgeLabel) {
        if (!this.hasEdge(edge)) {
            this.add(edge, EdgeLabel);
            return;
        }
        int n = this.getEdgeID(edge);
        this._edgeTable.put(n, EdgeLabel);
    }

    public boolean hasEdge(Edge edge) {
        return this.destNodeIDSet(edge.srcNodeID).contains(edge.destNodeID);
    }

    public EdgeLabel getEdgeLabel(int n) {
        return this._edgeTable.get(n);
    }

    public EdgeLabel getEdgeLabel(Edge edge) {
        return this.getEdgeLabel(this.getEdgeID(edge));
    }

    public int getEdgeID(Edge edge) {
        Integer n = this._edgeIndex.get(edge);
        if (n == null) {
            throw new NoSuchElementException(String.format("edge %s not found", edge));
        }
        return n;
    }

    public Set<Integer> destNodeIDSet(int n) {
        TreeSet<Integer> treeSet = this._outNodeListOfEachNode.get(n);
        if (treeSet == null) {
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            this._outNodeListOfEachNode.put(n, treeSet2);
            return treeSet2;
        }
        return treeSet;
    }

    public Set<Integer> sourceNodeIDSet(int n) {
        TreeSet<Integer> treeSet = this._inNodeListOfEachNode.get(n);
        if (treeSet == null) {
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            this._inNodeListOfEachNode.put(n, treeSet2);
            return treeSet2;
        }
        return treeSet;
    }

    public void clear() {
        this._edgeTable.clear();
        this._edgeIndex.clear();
        this._outNodeListOfEachNode.clear();
        this._inNodeListOfEachNode.clear();
    }
}

