/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io.SevenZip.Compression.LZ;

import java.io.IOException;
import org.xerial.util.io.SevenZip.Compression.LZ.InWindow;

public class BinTree
extends InWindow {
    int _cyclicBufferPos;
    int _cyclicBufferSize = 0;
    int _matchMaxLen;
    int[] _son;
    int[] _hash;
    int _cutValue = 255;
    int _hashMask;
    int _hashSizeSum = 0;
    boolean HASH_ARRAY = true;
    static final int kHash2Size = 1024;
    static final int kHash3Size = 65536;
    static final int kBT2HashSize = 65536;
    static final int kStartMaxLen = 1;
    static final int kHash3Offset = 1024;
    static final int kEmptyHashValue = 0;
    static final int kMaxValForNormalize = 0x3FFFFFFF;
    int kNumHashDirectBytes = 0;
    int kMinMatchCheck = 4;
    int kFixHashSize = 66560;
    private static final int[] CrcTable = new int[256];

    public void SetType(int n) {
        boolean bl = this.HASH_ARRAY = n > 2;
        if (this.HASH_ARRAY) {
            this.kNumHashDirectBytes = 0;
            this.kMinMatchCheck = 4;
            this.kFixHashSize = 66560;
        } else {
            this.kNumHashDirectBytes = 2;
            this.kMinMatchCheck = 3;
            this.kFixHashSize = 0;
        }
    }

    @Override
    public void Init() throws IOException {
        super.Init();
        for (int i = 0; i < this._hashSizeSum; ++i) {
            this._hash[i] = 0;
        }
        this._cyclicBufferPos = 0;
        this.ReduceOffsets(-1);
    }

    @Override
    public void MovePos() throws IOException {
        if (++this._cyclicBufferPos >= this._cyclicBufferSize) {
            this._cyclicBufferPos = 0;
        }
        super.MovePos();
        if (this._pos == 0x3FFFFFFF) {
            this.Normalize();
        }
    }

    public boolean Create(int n, int n2, int n3, int n4) {
        if (n > 0x3FFFFEFF) {
            return false;
        }
        this._cutValue = 16 + (n3 >> 1);
        int n5 = (n + n2 + n3 + n4) / 2 + 256;
        super.Create(n + n2, n3 + n4, n5);
        this._matchMaxLen = n3;
        int n6 = n + 1;
        if (this._cyclicBufferSize != n6) {
            this._cyclicBufferSize = n6;
            this._son = new int[this._cyclicBufferSize * 2];
        }
        int n7 = 65536;
        if (this.HASH_ARRAY) {
            n7 = n - 1;
            n7 |= n7 >> 1;
            n7 |= n7 >> 2;
            n7 |= n7 >> 4;
            n7 |= n7 >> 8;
            n7 >>= 1;
            if ((n7 |= 0xFFFF) > 0x1000000) {
                n7 >>= 1;
            }
            this._hashMask = n7++;
            n7 += this.kFixHashSize;
        }
        if (n7 != this._hashSizeSum) {
            this._hashSizeSum = n7;
            this._hash = new int[this._hashSizeSum];
        }
        return true;
    }

    public int GetMatches(int[] nArray) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this._pos + this._matchMaxLen <= this._streamPos) {
            n6 = this._matchMaxLen;
        } else {
            n6 = this._streamPos - this._pos;
            if (n6 < this.kMinMatchCheck) {
                this.MovePos();
                return 0;
            }
        }
        int n7 = 0;
        int n8 = this._pos > this._cyclicBufferSize ? this._pos - this._cyclicBufferSize : 0;
        int n9 = this._bufferOffset + this._pos;
        int n10 = 1;
        int n11 = 0;
        int n12 = 0;
        if (this.HASH_ARRAY) {
            n5 = CrcTable[this._bufferBase[n9] & 0xFF] ^ this._bufferBase[n9 + 1] & 0xFF;
            n11 = n5 & 0x3FF;
            n12 = (n5 ^= (this._bufferBase[n9 + 2] & 0xFF) << 8) & 0xFFFF;
            n4 = (n5 ^ CrcTable[this._bufferBase[n9 + 3] & 0xFF] << 5) & this._hashMask;
        } else {
            n4 = this._bufferBase[n9] & 0xFF ^ (this._bufferBase[n9 + 1] & 0xFF) << 8;
        }
        n5 = this._hash[this.kFixHashSize + n4];
        if (this.HASH_ARRAY) {
            n3 = this._hash[n11];
            n2 = this._hash[1024 + n12];
            this._hash[n11] = this._pos;
            this._hash[1024 + n12] = this._pos;
            if (n3 > n8 && this._bufferBase[this._bufferOffset + n3] == this._bufferBase[n9]) {
                int n13 = n7++;
                n10 = 2;
                nArray[n13] = 2;
                nArray[n7++] = this._pos - n3 - 1;
            }
            if (n2 > n8 && this._bufferBase[this._bufferOffset + n2] == this._bufferBase[n9]) {
                if (n2 == n3) {
                    n7 -= 2;
                }
                int n14 = n7++;
                n10 = 3;
                nArray[n14] = 3;
                nArray[n7++] = this._pos - n2 - 1;
                n3 = n2;
            }
            if (n7 != 0 && n3 == n5) {
                n7 -= 2;
                n10 = 1;
            }
        }
        this._hash[this.kFixHashSize + n4] = this._pos;
        n3 = (this._cyclicBufferPos << 1) + 1;
        n2 = this._cyclicBufferPos << 1;
        int n15 = n = this.kNumHashDirectBytes;
        if (this.kNumHashDirectBytes != 0 && n5 > n8 && this._bufferBase[this._bufferOffset + n5 + this.kNumHashDirectBytes] != this._bufferBase[n9 + this.kNumHashDirectBytes]) {
            nArray[n7++] = n10 = this.kNumHashDirectBytes;
            nArray[n7++] = this._pos - n5 - 1;
        }
        int n16 = this._cutValue;
        while (true) {
            if (n5 <= n8 || n16-- == 0) {
                this._son[n2] = 0;
                this._son[n3] = 0;
                break;
            }
            int n17 = this._pos - n5;
            int n18 = (n17 <= this._cyclicBufferPos ? this._cyclicBufferPos - n17 : this._cyclicBufferPos - n17 + this._cyclicBufferSize) << 1;
            int n19 = this._bufferOffset + n5;
            int n20 = Math.min(n15, n);
            if (this._bufferBase[n19 + n20] == this._bufferBase[n9 + n20]) {
                while (++n20 != n6 && this._bufferBase[n19 + n20] == this._bufferBase[n9 + n20]) {
                }
                if (n10 < n20) {
                    nArray[n7++] = n10 = n20;
                    nArray[n7++] = n17 - 1;
                    if (n20 == n6) {
                        this._son[n2] = this._son[n18];
                        this._son[n3] = this._son[n18 + 1];
                        break;
                    }
                }
            }
            if ((this._bufferBase[n19 + n20] & 0xFF) < (this._bufferBase[n9 + n20] & 0xFF)) {
                this._son[n2] = n5;
                n2 = n18 + 1;
                n5 = this._son[n2];
                n = n20;
                continue;
            }
            this._son[n3] = n5;
            n3 = n18;
            n5 = this._son[n3];
            n15 = n20;
        }
        this.MovePos();
        return n7;
    }

    public void Skip(int n) throws IOException {
        do {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            if (this._pos + this._matchMaxLen <= this._streamPos) {
                n7 = this._matchMaxLen;
            } else {
                n7 = this._streamPos - this._pos;
                if (n7 < this.kMinMatchCheck) {
                    this.MovePos();
                    continue;
                }
            }
            int n8 = this._pos > this._cyclicBufferSize ? this._pos - this._cyclicBufferSize : 0;
            int n9 = this._bufferOffset + this._pos;
            if (this.HASH_ARRAY) {
                n6 = CrcTable[this._bufferBase[n9] & 0xFF] ^ this._bufferBase[n9 + 1] & 0xFF;
                n5 = n6 & 0x3FF;
                this._hash[n5] = this._pos;
                n4 = (n6 ^= (this._bufferBase[n9 + 2] & 0xFF) << 8) & 0xFFFF;
                this._hash[1024 + n4] = this._pos;
                n3 = (n6 ^ CrcTable[this._bufferBase[n9 + 3] & 0xFF] << 5) & this._hashMask;
            } else {
                n3 = this._bufferBase[n9] & 0xFF ^ (this._bufferBase[n9 + 1] & 0xFF) << 8;
            }
            n6 = this._hash[this.kFixHashSize + n3];
            this._hash[this.kFixHashSize + n3] = this._pos;
            n5 = (this._cyclicBufferPos << 1) + 1;
            n4 = this._cyclicBufferPos << 1;
            int n10 = n2 = this.kNumHashDirectBytes;
            int n11 = this._cutValue;
            while (true) {
                if (n6 <= n8 || n11-- == 0) {
                    this._son[n4] = 0;
                    this._son[n5] = 0;
                    break;
                }
                int n12 = this._pos - n6;
                int n13 = (n12 <= this._cyclicBufferPos ? this._cyclicBufferPos - n12 : this._cyclicBufferPos - n12 + this._cyclicBufferSize) << 1;
                int n14 = this._bufferOffset + n6;
                int n15 = Math.min(n10, n2);
                if (this._bufferBase[n14 + n15] == this._bufferBase[n9 + n15]) {
                    while (++n15 != n7 && this._bufferBase[n14 + n15] == this._bufferBase[n9 + n15]) {
                    }
                    if (n15 == n7) {
                        this._son[n4] = this._son[n13];
                        this._son[n5] = this._son[n13 + 1];
                        break;
                    }
                }
                if ((this._bufferBase[n14 + n15] & 0xFF) < (this._bufferBase[n9 + n15] & 0xFF)) {
                    this._son[n4] = n6;
                    n4 = n13 + 1;
                    n6 = this._son[n4];
                    n2 = n15;
                    continue;
                }
                this._son[n5] = n6;
                n5 = n13;
                n6 = this._son[n5];
                n10 = n15;
            }
            this.MovePos();
        } while (--n != 0);
    }

    void NormalizeLinks(int[] nArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            n3 = n3 <= n2 ? 0 : (n3 -= n2);
            nArray[i] = n3;
        }
    }

    void Normalize() {
        int n = this._pos - this._cyclicBufferSize;
        this.NormalizeLinks(this._son, this._cyclicBufferSize * 2, n);
        this.NormalizeLinks(this._hash, this._hashSizeSum, n);
        this.ReduceOffsets(n);
    }

    public void SetCutValue(int n) {
        this._cutValue = n;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) != 0) {
                    n = n >>> 1 ^ 0xEDB88320;
                    continue;
                }
                n >>>= 1;
            }
            BinTree.CrcTable[i] = n;
        }
    }
}

