/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.tree.impl;

import java.util.Collection;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.util.ArrayDeque;
import org.xerial.util.Deque;
import org.xerial.util.tree.TreeEvent;

public class TreeEventQueue {
    private Deque<TreeEvent> eventQueue = new ArrayDeque<TreeEvent>();
    private Deque<String> nodeNameStack = new ArrayDeque<String>();
    private static final String EMPTY_STRING = new String();

    public void push(TreeEvent treeEvent) {
        switch (treeEvent.event) {
            case VISIT: {
                this.nodeNameStack.addLast(treeEvent.nodeName == null ? EMPTY_STRING : treeEvent.nodeName);
                break;
            }
            case LEAVE: {
                this.nodeNameStack.removeLast();
            }
        }
        this.eventQueue.addLast(treeEvent);
    }

    public TreeEvent peekFirst() {
        return this.eventQueue.peekFirst();
    }

    public TreeEvent peekLast() {
        return this.eventQueue.peekLast();
    }

    public void push(Collection<TreeEvent> collection) {
        for (TreeEvent treeEvent : collection) {
            this.push(treeEvent);
        }
    }

    public void replaceLast(TreeEvent treeEvent) {
        if (treeEvent.event != this.eventQueue.peekLast().event) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_STATE, String.format("replace Last must be applied for the same event type: %s, %s", new Object[]{treeEvent.event, this.eventQueue.getLast().event}));
        }
        this.eventQueue.removeLast();
        this.eventQueue.addLast(treeEvent);
    }

    public String getContextNodeName() {
        if (this.nodeNameStack.isEmpty()) {
            return null;
        }
        String string = this.nodeNameStack.getLast();
        if (string == EMPTY_STRING) {
            return null;
        }
        return string;
    }

    public TreeEvent pop() {
        return this.eventQueue.removeFirst();
    }

    public boolean isEmpty() {
        return this.eventQueue.isEmpty();
    }

    public String toString() {
        return this.eventQueue.toString();
    }
}

