/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import scala.Array$;
import scala.collection.mutable.ArrayBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import xerial.larray.LSeq;
import xerial.larray.UnsafeUtil$;

public abstract class LSeq$class {
    public static long byteLength(LSeq $this) {
        return (long)$this.elementByteSize() * $this.size();
    }

    public static ByteBuffer[] toDirectByteBuffer(LSeq $this) {
        long len;
        ArrayBuilder b = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(ByteBuffer.class));
        long limit = $this.byteLength();
        for (long pos = 0L; pos < limit; pos += len) {
            len = package$.MODULE$.min(limit - pos, Integer.MAX_VALUE);
            ByteBuffer d = UnsafeUtil$.MODULE$.newDirectByteBuffer($this.address() + pos, (int)len);
            b.$plus$eq((Object)d.order(ByteOrder.nativeOrder()));
        }
        return (ByteBuffer[])b.result();
    }

    public static File saveTo(LSeq $this, File f) {
        FileChannel fout = new FileOutputStream(f).getChannel();
        try {
            fout.write($this.toDirectByteBuffer());
            return f;
        }
        finally {
            fout.close();
        }
    }

    public static byte getByte(LSeq $this, long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getByte($this.address() + offset);
    }

    public static char getChar(LSeq $this, long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getChar($this.address() + offset);
    }

    public static short getShort(LSeq $this, long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getShort($this.address() + offset);
    }

    public static int getInt(LSeq $this, long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getInt($this.address() + offset);
    }

    public static float getFloat(LSeq $this, long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getFloat($this.address() + offset);
    }

    public static long getLong(LSeq $this, long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getLong($this.address() + offset);
    }

    public static double getDouble(LSeq $this, long offset) {
        return UnsafeUtil$.MODULE$.unsafe().getDouble($this.address() + offset);
    }

    public static void $init$(LSeq $this) {
    }
}

