/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.pinot.udf;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.codec.binary.Hex;

public class PinotFunctions {
    private PinotFunctions() {
    }

    @Description(value="pinot binary decimal to double")
    @ScalarFunction(value="pinot_binary_decimal_to_double")
    @SqlNullable
    @SqlType(value="double")
    public static Double pinotBinaryDecimalToDouble(@SqlType(value="varbinary") Slice input, @SqlType(value="integer") long bigIntegerRadix, @SqlType(value="integer") long scale, @SqlType(value="boolean") boolean returnZeroOnNull) {
        if (input == null || input.getBytes().length == 0) {
            if (returnZeroOnNull) {
                return 0.0;
            }
            return null;
        }
        return new BigDecimal(new BigInteger(Hex.encodeHexString((byte[])input.getBytes()), (int)bigIntegerRadix), (int)scale).doubleValue();
    }
}

