/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.base.security;

import com.facebook.presto.plugin.base.security.FileBasedAccessControl;
import com.facebook.presto.plugin.base.security.FileBasedAccessControlConfig;
import com.facebook.presto.plugin.base.security.ForwardingConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.google.common.base.Suppliers;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.configuration.ConfigBinder;
import io.airlift.log.Logger;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class FileBasedAccessControlModule
implements Module {
    private static final Logger log = Logger.get(FileBasedAccessControlModule.class);

    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(FileBasedAccessControlConfig.class);
    }

    @Inject
    @Provides
    public ConnectorAccessControl getConnectorAccessControl(FileBasedAccessControlConfig config) {
        if (config.getRefreshPeriod() != null) {
            return ForwardingConnectorAccessControl.of((Supplier<ConnectorAccessControl>)Suppliers.memoizeWithExpiration(() -> {
                log.info("Refreshing system access control from %s", new Object[]{config.getConfigFile()});
                return new FileBasedAccessControl(config);
            }, (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        return new FileBasedAccessControl(config);
    }
}

