/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.airlift.log.Logger;
import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requires;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class AlterTableTests
extends ProductTest {
    private static final String TABLE_NAME = "table_name";
    private static final String RENAMED_TABLE_NAME = "renamed_table_name";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTables() {
        try {
            QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", RENAMED_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        }
        catch (Exception e) {
            Logger.get(((Object)((Object)this)).getClass()).warn((Throwable)e, "failed to drop table");
        }
    }

    @Test(groups={"alter_table", "smoke"})
    public void renameTable() {
        QueryExecutor.query((String)String.format("CREATE TABLE %s AS SELECT * FROM nation", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("ALTER TABLE %s RENAME TO %s", TABLE_NAME, RENAMED_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", RENAMED_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("ALTER TABLE %s RENAME TO %s", RENAMED_TABLE_NAME, TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
    }

    @Test(groups={"alter_table", "smoke"})
    public void renameColumn() {
        QueryExecutor.query((String)String.format("CREATE TABLE %s AS SELECT * FROM nation", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("ALTER TABLE %s RENAME COLUMN n_nationkey TO nationkey", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(nationkey) FROM %s", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("ALTER TABLE %s RENAME COLUMN nationkey TO nATIoNkEy", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'nationkey' already exists");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("ALTER TABLE %s RENAME COLUMN nationkey TO n_regionkeY", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'n_regionkey' already exists");
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("ALTER TABLE %s RENAME COLUMN nationkey TO n_nationkey", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]));
    }

    @Test(groups={"alter_table", "smoke"})
    public void addColumn() {
        QueryExecutor.query((String)String.format("CREATE TABLE %s AS SELECT * FROM nation", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(1) FROM %s", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("ALTER TABLE %s ADD COLUMN some_new_column BIGINT", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("ALTER TABLE %s ADD COLUMN n_nationkey BIGINT", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'n_nationkey' already exists");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("ALTER TABLE %s ADD COLUMN n_naTioNkEy BIGINT", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'n_naTioNkEy' already exists");
    }

    @Test(groups={"alter_table", "smoke"})
    public void dropColumn() {
        QueryExecutor.query((String)String.format("CREATE TABLE %s AS SELECT n_nationkey, n_regionkey, n_name FROM nation", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(n_nationkey) FROM %s", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("ALTER TABLE %s DROP COLUMN n_name", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("ALTER TABLE %s DROP COLUMN n_nationkey", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("ALTER TABLE %s DROP COLUMN n_regionkey", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot drop the only column in a table");
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }
}

