/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.tests.utils.QueryExecutors;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requires;
import io.prestodb.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestodb.tempto.hadoop.hdfs.HdfsClient;
import io.prestodb.tempto.query.QueryExecutor;
import org.testng.Assert;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class ImpersonationTests
extends ProductTest {
    private QueryExecutor aliceExecutor;
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.alice@presto.jdbc_user")
    private String aliceJdbcUser;
    @Inject
    @Named(value="databases.presto.configured_hdfs_user")
    private String configuredHdfsUser;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectoryPath;

    @BeforeTestWithContext
    public void setup() {
        this.aliceExecutor = QueryExecutors.connectToPresto("alice@presto");
        QueryExecutor.query((String)String.format("GRANT SELECT ON NATION TO %s", this.aliceJdbcUser), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hdfs_no_impersonation", "profile_specific_tests"})
    public void testHdfsImpersonationDisabled() {
        String tableName = "check_hdfs_impersonation_disabled";
        this.checkTableOwner(tableName, this.configuredHdfsUser, this.aliceExecutor);
    }

    @Test(groups={"hdfs_impersonation", "profile_specific_tests"})
    public void testHdfsImpersonationEnabled() {
        String tableName = "check_hdfs_impersonation_enabled";
        this.checkTableOwner(tableName, this.aliceJdbcUser, this.aliceExecutor);
    }

    private String getTableLocation(String tableName) {
        return this.warehouseDirectoryPath + '/' + tableName;
    }

    private void checkTableOwner(String tableName, String expectedOwner, QueryExecutor executor) {
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        executor.executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM NATION", tableName), new QueryExecutor.QueryParam[0]);
        String tableLocation = this.getTableLocation(tableName);
        String owner = this.hdfsClient.getOwner(tableLocation);
        Assert.assertEquals((String)owner, (String)expectedOwner);
        executor.executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }
}

