/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.Requires;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.context.ThreadLocalTestContextHolder;
import io.prestodb.tempto.fulfillment.table.ImmutableTableRequirement;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class SimpleQueryTest
extends ProductTest {
    @BeforeTestWithContext
    public void beforeTest() {
        Assertions.assertThat((boolean)ThreadLocalTestContextHolder.testContextIfSet().isPresent()).isTrue();
    }

    @AfterTestWithContext
    public void afterTest() {
        Assertions.assertThat((boolean)ThreadLocalTestContextHolder.testContextIfSet().isPresent()).isTrue();
    }

    @Test(groups={"simple", "smoke"})
    @Requires(value={SimpleTestRequirements.class})
    public void selectAllFromNation() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select * from nation", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(25);
    }

    @Test(groups={"simple", "smoke"})
    @Requires(value={SimpleTestRequirements.class})
    public void selectCountFromNation() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"select count(*) from nation", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
    }

    private static class SimpleTestRequirements
    implements RequirementsProvider {
        private SimpleTestRequirements() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return new ImmutableTableRequirement((TableDefinition)TpchTableDefinitions.NATION);
        }
    }
}

