/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.ResponseHandlerUtils;
import com.facebook.airlift.http.client.jetty.JettyHttpClient;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Closer;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SqlCancelTests
extends ProductTest {
    private ExecutorService executor;
    private QueryCanceller queryCanceller;
    private Closer closer;
    @Inject
    @Named(value="databases.presto.server_address")
    private String serverAddress;

    @BeforeTestWithContext
    public void setUp() {
        this.closer = Closer.create();
        this.executor = Executors.newSingleThreadExecutor();
        this.closer.register(this.executor::shutdownNow);
        this.queryCanceller = (QueryCanceller)this.closer.register((Closeable)new QueryCanceller(this.serverAddress));
    }

    @AfterTestWithContext
    public void cleanUp() throws IOException {
        this.closer.close();
    }

    @Test(groups={"cancel_query"}, timeOut=60000L)
    public void cancelCreateTable() throws Exception {
        String tableName = "cancel_createtable_" + System.nanoTime();
        String sql = String.format("CREATE TABLE %s AS SELECT * FROM tpch.sf1.lineitem", tableName);
        this.runAndCancelQuery(sql);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT * from " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Table hive.default.%s does not exist", tableName));
    }

    @Test(groups={"cancel_query"}, timeOut=60000L)
    public void cancelInsertInto() throws Exception {
        String tableName = "cancel_insertinto_" + System.nanoTime();
        QueryExecutor.query((String)String.format("CREATE TABLE %s (orderkey BIGINT, partkey BIGINT, shipinstruct VARCHAR(25)) ", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String sql = String.format("INSERT INTO %s SELECT orderkey, partkey, shipinstruct FROM tpch.sf1.lineitem", tableName);
        this.runAndCancelQuery(sql);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * from " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"cancel_query"}, timeOut=60000L)
    public void cancelSelect() throws Exception {
        this.runAndCancelQuery("SELECT * FROM tpch.sf1.lineitem AS cancel_select_" + System.nanoTime());
    }

    private void runAndCancelQuery(String sql) throws Exception {
        Future<QueryResult> queryExecution = this.executor.submit(() -> QueryExecutor.query((String)sql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]));
        this.cancelQuery(sql);
        try {
            queryExecution.get(30L, TimeUnit.SECONDS);
            Assert.fail((String)"Query failure was expected");
        }
        catch (TimeoutException e) {
            queryExecution.cancel(true);
            throw e;
        }
        catch (ExecutionException expected) {
            Assertions.assertThat((Throwable)expected.getCause()).hasMessageEndingWith("Query was canceled");
        }
    }

    private void cancelQuery(String sql) throws InterruptedException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (stopwatch.elapsed(TimeUnit.SECONDS) < 30L) {
            String findQuerySql = "SELECT query_id from system.runtime.queries WHERE query = '%s' and state = 'RUNNING' LIMIT 2";
            QueryResult queryResult = QueryExecutor.query((String)String.format(findQuerySql, sql), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            Preconditions.checkState((queryResult.getRowsCount() < 2 ? 1 : 0) != 0, (Object)"Query is executed multiple times");
            if (queryResult.getRowsCount() == 1) {
                String queryId = (String)queryResult.row(0).get(0);
                Response response = this.queryCanceller.cancel(queryId);
                Assertions.assertThat((int)response.getStatusCode()).isEqualTo(HttpStatus.NO_CONTENT.code());
                return;
            }
            TimeUnit.MILLISECONDS.sleep(100L);
        }
        throw new IllegalStateException("Query did not reach running state or maybe it was too quick.");
    }

    private static class QueryCanceller
    implements Closeable {
        private final HttpClient httpClient = new JettyHttpClient(new HttpClientConfig());
        private final URI uri;

        QueryCanceller(String uri) {
            this.uri = URI.create(Objects.requireNonNull(uri, "uri is null"));
        }

        public Response cancel(String queryId) {
            Objects.requireNonNull(queryId, "queryId is null");
            URI cancelUri = HttpUriBuilder.uriBuilderFrom((URI)this.uri).appendPath("/v1/query").appendPath(queryId).build();
            Request request = Request.Builder.prepareDelete().setUri(cancelUri).build();
            return (Response)this.httpClient.execute(request, (ResponseHandler)new ResponseHandler<Response, RuntimeException>(){

                public Response handleException(Request request, Exception exception) {
                    throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
                }

                public Response handle(Request request, Response response) {
                    return response;
                }
            });
        }

        @Override
        public void close() {
            this.httpClient.close();
        }
    }
}

