/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests;

import com.facebook.presto.tests.utils.QueryExecutors;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TlsTests {
    @Inject(optional=true)
    @Named(value="databases.presto.http_port")
    private Integer httpPort;
    @Inject(optional=true)
    @Named(value="databases.presto.https_port")
    private Integer httpsPort;

    @Test(groups={"tls", "profile_specific_tests"})
    public void testHttpPortIsClosed() throws Exception {
        Assertions.assertThat((Integer)this.httpPort).isNotNull();
        Assertions.assertThat((Integer)this.httpsPort).isNotNull();
        this.waitForNodeRefresh();
        List<String> activeNodesUrls = this.getActiveNodesUrls();
        Assertions.assertThat(activeNodesUrls).hasSize(3);
        List hosts = activeNodesUrls.stream().map(uri -> URI.create(uri).getHost()).collect(Collectors.toList());
        for (String host : hosts) {
            TlsTests.assertPortIsOpen(host, this.httpsPort);
            TlsTests.assertPortIsClosed(host, this.httpPort);
        }
    }

    private void waitForNodeRefresh() throws InterruptedException {
        long deadline = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
        while (System.currentTimeMillis() < deadline) {
            if (this.getActiveNodesUrls().size() == 3) {
                return;
            }
            Thread.sleep(100L);
        }
        Assertions.fail((String)"Worker nodes haven't been discovered in 1 minutes.");
    }

    private List<String> getActiveNodesUrls() {
        QueryResult queryResult = QueryExecutors.onPresto().executeQuery("SELECT http_uri FROM system.runtime.nodes", new QueryExecutor.QueryParam[0]);
        return queryResult.rows().stream().map(row -> row.get(0).toString()).collect(Collectors.toList());
    }

    private static void assertPortIsClosed(String host, Integer port) {
        if (TlsTests.isPortOpen(host, port)) {
            Assertions.fail((String)String.format("Port %d at %s is expected to be closed", port, host));
        }
    }

    private static void assertPortIsOpen(String host, Integer port) {
        if (!TlsTests.isPortOpen(host, port)) {
            Assertions.fail((String)String.format("Port %d at %s is expected to be open", port, host));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortOpen(String host, Integer port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(InetAddress.getByName(host), (int)port), 1000);
            boolean bl = true;
            return bl;
        }
        catch (ConnectException | SocketTimeoutException e) {
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

