/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.cassandra;

import com.facebook.presto.tests.cassandra.CassandraTpchTableDefinitions;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.query.QueryExecutor;
import org.testng.annotations.Test;

public class TestInvalidSelect
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)CassandraTpchTableDefinitions.CASSANDRA_NATION);
    }

    @Test(groups={"cassandra"})
    public void testInvalidTable() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Table %s does not exist", tableName));
    }

    @Test(groups={"cassandra"})
    public void testInvalidSchema() {
        String tableName = String.format("%s.%s.%s", "cassandra", "does_not_exist", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Schema does_not_exist does not exist");
    }

    @Test(groups={"cassandra"})
    public void testInvalidColumn() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT bogus FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'bogus' cannot be resolved");
    }
}

