/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.cli;

import com.facebook.presto.cli.Presto;
import com.facebook.presto.tests.cli.PrestoCliProcess;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.prestodb.tempto.ProductTest;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class PrestoCliLauncher
extends ProductTest {
    protected static final long TIMEOUT = 300000L;
    protected static final String EXIT_COMMAND = "exit";
    protected final List<String> nationTableInteractiveLines = Resources.readLines((URL)Resources.getResource((String)"com/facebook/presto/tests/cli/interactive_query.results"), (Charset)StandardCharsets.UTF_8);
    protected final List<String> nationTableBatchLines = Resources.readLines((URL)Resources.getResource((String)"com/facebook/presto/tests/cli/batch_query.results"), (Charset)StandardCharsets.UTF_8);
    private static final String CLASSPATH = System.getProperty("java.class.path");
    private static final String JAVA_BIN = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    @Inject
    @Named(value="databases.presto.host")
    protected String serverHost;
    @Inject
    @Named(value="databases.presto.server_address")
    protected String serverAddress;
    protected PrestoCliProcess presto;

    protected PrestoCliLauncher() throws IOException {
    }

    protected void stopPresto() throws InterruptedException {
        if (this.presto != null) {
            this.presto.getProcessInput().println(EXIT_COMMAND);
            PrestoCliLauncher.stopPrestoIgnoreQueryFailure(this.presto);
        }
    }

    protected void launchPrestoCli(String ... arguments) throws IOException {
        this.launchPrestoCli(Arrays.asList(arguments));
    }

    protected void launchPrestoCli(List<String> arguments) throws IOException {
        this.presto = new PrestoCliProcess(this.getProcessBuilder(arguments).start());
    }

    protected ProcessBuilder getProcessBuilder(List<String> arguments) {
        return new ProcessBuilder((List<String>)ImmutableList.builder().add((Object[])new String[]{JAVA_BIN, "-cp", CLASSPATH, Presto.class.getCanonicalName()}).addAll(arguments).build());
    }

    public static void stopPrestoIgnoreQueryFailure(PrestoCliProcess presto) throws InterruptedException {
        block2: {
            try {
                presto.waitForWithTimeoutAndKill();
            }
            catch (RuntimeException ex) {
                if (ex.getMessage().contains("Child process exited with non-zero code: 1")) break block2;
                throw ex;
            }
        }
    }
}

