/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.functions.operators;

import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class Comparison
extends ProductTest {
    @DataProvider(name="operands")
    public static Object[][] operandsProvider() {
        return new Object[][]{{"false", "true", "boolean"}, {"0", "1", "double"}, {"0", "1", "bigint"}, {"date '1991-01-01'", "date '1991-01-02'", "date"}, {"time '01:02:03.456'", "time '01:02:03.457'", "time"}, {"time '01:02:03.456 America/Los_Angeles'", "time '01:02:03.457 America/Los_Angeles'", "TIME WITH TIME ZONE"}, {"TIMESTAMP '2001-08-22 03:04:05.321'", "TIMESTAMP '2001-08-22 03:04:05.322'", "TIMESTAMP"}, {"TIMESTAMP '2001-08-22 03:04:05.321 America/Los_Angeles'", "TIMESTAMP '2001-08-22 03:04:05.322 America/Los_Angeles'", "TIMESTAMP WITH TIME ZONE"}};
    }

    @Test(groups={"comparison", "qe"}, dataProvider="operands")
    public void testLessThanOperatorExists(String leftOperand, String rightOperand, String typeName) {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select cast(%s as %s) < cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{true})});
    }

    @Test(groups={"comparison", "qe"}, dataProvider="operands")
    public void testGreaterThanOperatorExists(String leftOperand, String rightOperand, String typeName) {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select cast(%s as %s) > cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{false})});
    }

    @Test(groups={"comparison", "qe"}, dataProvider="operands")
    public void testLessThanOrEqualOperatorExists(String leftOperand, String rightOperand, String typeName) {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select cast(%s as %s) <= cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{true})});
    }

    @Test(groups={"comparison", "qe"}, dataProvider="operands")
    public void testGreaterThanOrEqualOperatorExists(String leftOperand, String rightOperand, String typeName) {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select cast(%s as %s) >= cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{false})});
    }

    @Test(groups={"comparison", "qe"}, dataProvider="operands")
    public void testEqualOperatorExists(String leftOperand, String rightOperand, String typeName) {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select cast(%s as %s) = cast(%s as %s)", leftOperand, typeName, rightOperand, typeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{false})});
    }

    @Test(groups={"comparison", "qe"}, dataProvider="operands")
    public void testBetweenOperatorExists(String leftOperand, String rightOperand, String typeName) {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select cast(%s as %s) BETWEEN cast(%s as %s) AND cast(%s as %s)", leftOperand, typeName, leftOperand, typeName, rightOperand, typeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{true})});
    }
}

