/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.context.ThreadLocalTestContextHolder;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import org.testng.annotations.Test;

public class TestAvroSchemaEvolution
extends ProductTest {
    private static final String TABLE_NAME = "product_tests_avro_table";
    private static final String ORIGINAL_SCHEMA = "file:///docker/volumes/presto-product-tests/avro/original_schema.avsc";
    private static final String CREATE_TABLE = String.format("CREATE TABLE %s (dummy_col VARCHAR)WITH (format='AVRO', avro_schema_url='%s')", "product_tests_avro_table", "file:///docker/volumes/presto-product-tests/avro/original_schema.avsc");
    private static final String RENAMED_COLUMN_SCHEMA = "file:///docker/volumes/presto-product-tests/avro/rename_column_schema.avsc";
    private static final String REMOVED_COLUMN_SCHEMA = "file:///docker/volumes/presto-product-tests/avro/remove_column_schema.avsc";
    private static final String ADDED_COLUMN_SCHEMA = "file:///docker/volumes/presto-product-tests/avro/add_column_schema.avsc";
    private static final String CHANGE_COLUMN_TYPE_SCHEMA = "file:///docker/volumes/presto-product-tests/avro/change_column_type_schema.avsc";
    private static final String INCOMPATIBLE_TYPE_SCHEMA = "file:///docker/volumes/presto-product-tests/avro/incompatible_type_schema.avsc";
    private static final String SELECT_STAR = "SELECT * FROM product_tests_avro_table";
    private static final String COLUMNS_IN_TABLE = "SHOW COLUMNS IN product_tests_avro_table";

    @BeforeTestWithContext
    public void createAndLoadTable() {
        QueryExecutor.query((String)CREATE_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("INSERT INTO %s VALUES ('string0', 0)", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @AfterTestWithContext
    public void dropTestTable() {
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"avro"})
    public void testSelectTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT string_col FROM %s", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0"})});
    }

    @Test(groups={"avro"})
    public void testInsertAfterSchemaEvolution() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0", 0})});
        this.alterTableSchemaTo(ADDED_COLUMN_SCHEMA);
        QueryExecutor.query((String)String.format("INSERT INTO %s VALUES ('string1', 1, 101)", TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0", 0, 100}), QueryAssert.Row.row((Object[])new Object[]{"string1", 1, 101})});
    }

    @Test(groups={"avro"})
    public void testSchemaEvolutionWithIncompatibleType() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)COLUMNS_IN_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0", 0})});
        this.alterTableSchemaTo(INCOMPATIBLE_TYPE_SCHEMA);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Found int, expecting string");
    }

    @Test(groups={"avro"})
    public void testSchemaEvolution() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)COLUMNS_IN_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0", 0})});
        this.alterTableSchemaTo(CHANGE_COLUMN_TYPE_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)COLUMNS_IN_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "bigint", "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0", 0})});
        this.alterTableSchemaTo(ADDED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)COLUMNS_IN_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col_added", "integer", "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0", 0, 100})});
        this.alterTableSchemaTo(REMOVED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)COLUMNS_IN_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
        this.alterTableSchemaTo(RENAMED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)COLUMNS_IN_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col_renamed", "integer", "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0", null})});
    }

    @Test(groups={"avro"})
    public void testSchemaWhenUrlIsUnset() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)COLUMNS_IN_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)SELECT_STAR, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0", 0})});
        TestAvroSchemaEvolution.executeHiveQuery(String.format("ALTER TABLE %s UNSET TBLPROPERTIES('avro.schema.url')", TABLE_NAME));
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)COLUMNS_IN_TABLE, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"dummy_col", "varchar", "", ""})});
    }

    @Test(groups={"avro"})
    public void testCreateTableLike() {
        String createTableLikeName = "test_avro_like";
        QueryExecutor.query((String)String.format("CREATE TABLE %s (LIKE %s INCLUDING PROPERTIES)", createTableLikeName, TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("INSERT INTO %s VALUES ('string0', 0)", createTableLikeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT string_col FROM %s", createTableLikeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"string0"})});
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + createTableLikeName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private void alterTableSchemaTo(String schema) {
        TestAvroSchemaEvolution.executeHiveQuery(String.format("ALTER TABLE %s SET TBLPROPERTIES('avro.schema.url'='%s')", TABLE_NAME, schema));
    }

    private static void executeHiveQuery(String query) {
        ((QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "hive")).executeQuery(query, new QueryExecutor.QueryParam[0]);
    }
}

