/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.presto.tests.utils.QueryExecutors;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.hadoop.hdfs.HdfsClient;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.io.InputStream;
import java.net.URL;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestAvroSchemaUrl
extends ProductTest {
    @Inject
    private HdfsClient hdfsClient;

    @BeforeTestWithContext
    public void setup() throws Exception {
        this.hdfsClient.createDirectory("/user/hive/warehouse/TestAvroSchemaUrl/schemas");
        try (InputStream inputStream = Resources.asByteSource((URL)Resources.getResource((String)"avro/original_schema.avsc")).openStream();){
            this.hdfsClient.saveFile("/user/hive/warehouse/TestAvroSchemaUrl/schemas/original_schema.avsc", inputStream);
        }
    }

    @AfterTestWithContext
    public void cleanup() {
        this.hdfsClient.delete("/user/hive/warehouse/TestAvroSchemaUrl/schemas");
    }

    @DataProvider
    public Object[][] avroSchemaLocations() {
        return new Object[][]{{"file:///docker/volumes/presto-product-tests/avro/original_schema.avsc"}, {"hdfs://hadoop-master:9000/user/hive/warehouse/TestAvroSchemaUrl/schemas/original_schema.avsc"}, {"hdfs:///user/hive/warehouse/TestAvroSchemaUrl/schemas/original_schema.avsc"}, {"/user/hive/warehouse/TestAvroSchemaUrl/schemas/original_schema.avsc"}};
    }

    @Test(dataProvider="avroSchemaLocations", groups={"avro"})
    public void testHiveCreatedTable(String schemaLocation) {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_avro_schema_url_hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE test_avro_schema_url_hive ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.avro.AvroSerDe' STORED AS INPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat' TBLPROPERTIES ('avro.schema.url'='%s')", schemaLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO test_avro_schema_url_hive VALUES ('some text', 123042)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM test_avro_schema_url_hive", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM test_avro_schema_url_hive", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryExecutors.onHive().executeQuery("DROP TABLE test_avro_schema_url_hive", new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="avroSchemaLocations", groups={"avro"})
    public void testPrestoCreatedTable(String schemaLocation) {
        QueryExecutors.onPresto().executeQuery("DROP TABLE IF EXISTS test_avro_schema_url_presto", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE test_avro_schema_url_presto (dummy_col VARCHAR) WITH (format='AVRO', avro_schema_url='%s')", schemaLocation), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("INSERT INTO test_avro_schema_url_presto VALUES ('some text', 123042)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM test_avro_schema_url_presto", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM test_avro_schema_url_presto", new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some text", 123042})});
        QueryExecutors.onPresto().executeQuery("DROP TABLE test_avro_schema_url_presto", new QueryExecutor.QueryParam[0]);
    }
}

