/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.presto.tests.hive.HiveTableDefinitions;
import com.facebook.presto.tests.utils.QueryExecutors;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.Requirements;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.MutableTablesState;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableInstance;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import org.testng.annotations.Test;

public class TestExternalHiveTable
extends ProductTest
implements RequirementsProvider {
    private static final String EXTERNAL_TABLE_NAME = "target_table";

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.mutableTable((TableDefinition)TpchTableDefinitions.NATION), TableRequirements.mutableTable((TableDefinition)HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY)});
    }

    @Test
    public void testShowStatisticsForExternalTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase() + " LOCATION '/tmp/" + EXTERNAL_TABLE_NAME + "_" + nation.getNameInDatabase() + "'", new QueryExecutor.QueryParam[0]);
        this.insertNationPartition(nation, 1);
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE target_table PARTITION (p_regionkey) COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SHOW STATS FOR target_table", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE target_table PARTITION (p_regionkey) COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SHOW STATS FOR target_table", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
    }

    @Test
    public void testAnalyzeExternalTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase() + " LOCATION '/tmp/" + EXTERNAL_TABLE_NAME + "_" + nation.getNameInDatabase() + "'", new QueryExecutor.QueryParam[0]);
        this.insertNationPartition(nation, 1);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"ANALYZE hive.default.target_table", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
    }

    @Test
    public void testInsertIntoExternalTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(TpchTableDefinitions.NATION.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase(), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("INSERT INTO hive.default.target_table SELECT * FROM hive.default." + nation.getNameInDatabase(), new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot write to non-managed Hive table");
    }

    @Test
    public void testDeleteFromExternalTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(TpchTableDefinitions.NATION.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase(), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("DELETE FROM hive.default.target_table", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot delete from non-managed Hive table");
    }

    @Test
    public void testDeleteFromExternalPartitionedTableTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase() + " LOCATION '/tmp/" + EXTERNAL_TABLE_NAME + "_" + nation.getNameInDatabase() + "'", new QueryExecutor.QueryParam[0]);
        this.insertNationPartition(nation, 1);
        this.insertNationPartition(nation, 2);
        this.insertNationPartition(nation, 3);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM target_table", new QueryExecutor.QueryParam[0])).hasRowsCount(15);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("DELETE FROM hive.default.target_table WHERE p_name IS NOT NULL", new QueryExecutor.QueryParam[0])).failsWithMessage("This connector only supports delete where one or more partitions are deleted entirely");
        QueryExecutors.onPresto().executeQuery("DELETE FROM hive.default.target_table WHERE p_regionkey = 1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM target_table", new QueryExecutor.QueryParam[0])).hasRowsCount(10);
        QueryExecutors.onPresto().executeQuery("DELETE FROM hive.default.target_table", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM target_table", new QueryExecutor.QueryParam[0])).hasRowsCount(0);
    }

    private void insertNationPartition(TableInstance nation, int partition) {
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE target_table PARTITION (p_regionkey=" + partition + ") SELECT p_nationkey, p_name, p_comment FROM " + nation.getNameInDatabase() + " WHERE p_regionkey=" + partition, new QueryExecutor.QueryParam[0]);
    }
}

