/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.tests.utils.QueryExecutors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.context.ContextDsl;
import io.prestodb.tempto.context.ContextProvider;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import io.prestodb.tempto.sql.SqlContexts;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public class TestGrantRevoke
extends ProductTest {
    private static final Set<String> PREDEFINED_ROLES = ImmutableSet.of((Object)"admin", (Object)"public");
    private String tableName;
    private String viewName;
    private QueryExecutor aliceExecutor;
    private QueryExecutor bobExecutor;

    @BeforeTestWithContext
    public void setup() {
        this.tableName = "alice_owned_table";
        this.viewName = "alice_view";
        this.aliceExecutor = QueryExecutors.connectToPresto("alice@presto");
        this.bobExecutor = QueryExecutors.connectToPresto("bob@presto");
        this.aliceExecutor.executeQuery(String.format("DROP TABLE IF EXISTS %s", this.tableName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("CREATE TABLE %s(month bigint, day bigint)", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        TestGrantRevoke.assertAccessDeniedOnAllOperationsOnTable(this.bobExecutor, this.tableName);
    }

    @AfterTestWithContext
    public void cleanup() {
        try {
            this.aliceExecutor.executeQuery(String.format("DROP TABLE IF EXISTS %s", this.tableName), new QueryExecutor.QueryParam[0]);
            this.aliceExecutor.executeQuery(String.format("DROP VIEW IF EXISTS %s", this.viewName), new QueryExecutor.QueryParam[0]);
            this.cleanupRoles();
        }
        catch (Exception e) {
            Logger.get(((Object)((Object)this)).getClass()).warn((Throwable)e, "failed to drop table/view");
        }
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    private void cleanupRoles() {
        for (String role : this.listRoles()) {
            if (PREDEFINED_ROLES.contains(role)) continue;
            QueryExecutors.onHive().executeQuery(String.format("DROP ROLE %s", role), new QueryExecutor.QueryParam[0]);
        }
    }

    private Set<String> listRoles() {
        return ImmutableSet.copyOf((Collection)QueryExecutors.onHive().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0]).rows().stream().map(row -> row.get(0).toString()).collect(Collectors.toSet()));
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testGrantRevoke() {
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob WITH GRANT OPTION", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        this.aliceExecutor.executeQuery(String.format("GRANT INSERT, SELECT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("INSERT INTO %s VALUES (3, 22)", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("DELETE FROM %s WHERE day=3", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot delete from table default.%s", this.tableName));
        this.aliceExecutor.executeQuery(String.format("REVOKE INSERT ON %s FROM bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("INSERT INTO %s VALUES (1, 5)", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot insert into table default.%s", this.tableName));
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        this.aliceExecutor.executeQuery(String.format("REVOKE INSERT, SELECT ON %s FROM bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testShowGrants() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery(String.format("GRANT SELECT ON %s TO ROLE role1", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO bob WITH GRANT OPTION", this.tableName), new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("GRANT INSERT ON %s TO bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SHOW GRANTS ON %s", this.tableName), new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "bob", "USER", "hive", "default", "alice_owned_table", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "bob", "USER", "hive", "default", "alice_owned_table", "INSERT", "NO", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"hdfs", "USER", "role1", "ROLE", "hive", "default", "alice_owned_table", "SELECT", "NO", null})));
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testAll() {
        this.aliceExecutor.executeQuery(String.format("GRANT ALL PRIVILEGES ON %s TO USER bob", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("INSERT INTO %s VALUES (4, 13)", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        this.bobExecutor.executeQuery(String.format("DELETE FROM %s", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        this.aliceExecutor.executeQuery(String.format("REVOKE ALL PRIVILEGES ON %s FROM USER bob", this.tableName), new QueryExecutor.QueryParam[0]);
        TestGrantRevoke.assertAccessDeniedOnAllOperationsOnTable(this.bobExecutor, this.tableName);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SHOW GRANTS ON %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testPublic() {
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO ROLE PUBLIC", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        this.aliceExecutor.executeQuery(String.format("REVOKE SELECT ON %s FROM ROLE PUBLIC", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testCustomRole() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO ROLE role1", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        this.aliceExecutor.executeQuery(String.format("REVOKE SELECT ON %s FROM ROLE role1", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testTransitiveRole() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO ROLE role2", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        this.aliceExecutor.executeQuery(String.format("REVOKE SELECT ON %s FROM ROLE role2", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testDropRoleWithPermissionsGranted() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0]);
        this.aliceExecutor.executeQuery(String.format("GRANT SELECT ON %s TO ROLE role1", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryExecutors.onPresto().executeQuery("DROP ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> this.bobExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", this.tableName));
        QueryAssert.assertThat((QueryResult)this.aliceExecutor.executeQuery(String.format("SELECT * FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).hasNoRows();
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testTableOwnerPrivileges() {
        QueryExecutors.onHive().executeQuery("set role admin;", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery(String.format("SHOW GRANT USER alice ON TABLE %s", this.tableName), new QueryExecutor.QueryParam[0]).project(new int[]{7, 8})).containsOnly(this.ownerGrants());
    }

    @Test(groups={"authorization", "profile_specific_tests"})
    public void testViewOwnerPrivileges() {
        QueryExecutors.onHive().executeQuery("set role admin;", new QueryExecutor.QueryParam[0]);
        ContextDsl.executeWith((ContextProvider)SqlContexts.createViewAs((String)this.viewName, (String)String.format("SELECT * FROM %s", this.tableName), (QueryExecutor)this.aliceExecutor), view -> QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery(String.format("SHOW GRANT USER alice ON %s", this.viewName), new QueryExecutor.QueryParam[0]).project(new int[]{7, 8})).containsOnly(this.ownerGrants()));
    }

    private ImmutableList<QueryAssert.Row> ownerGrants() {
        return ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"SELECT", Boolean.TRUE}), (Object)QueryAssert.Row.row((Object[])new Object[]{"INSERT", Boolean.TRUE}), (Object)QueryAssert.Row.row((Object[])new Object[]{"UPDATE", Boolean.TRUE}), (Object)QueryAssert.Row.row((Object[])new Object[]{"DELETE", Boolean.TRUE}));
    }

    private static void assertAccessDeniedOnAllOperationsOnTable(QueryExecutor queryExecutor, String tableName) {
        QueryAssert.assertThat(() -> queryExecutor.executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot select from table default.%s", tableName));
        QueryAssert.assertThat(() -> queryExecutor.executeQuery(String.format("INSERT INTO %s VALUES (3, 22)", tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot insert into table default.%s", tableName));
        QueryAssert.assertThat(() -> queryExecutor.executeQuery(String.format("DELETE FROM %s WHERE day=3", tableName), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Access Denied: Cannot delete from table default.%s", tableName));
    }
}

