/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.presto.tests.utils.JdbcDriverUtils;
import com.facebook.presto.tests.utils.QueryExecutors;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.Requirements;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.MutableTableRequirement;
import io.prestodb.tempto.fulfillment.table.MutableTablesState;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableDefinitionsRepository;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.prestodb.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.sql.Connection;
import java.sql.SQLException;
import org.testng.annotations.Test;

public class TestHiveBucketedTables
extends ProductTest
implements RequirementsProvider {
    @TableDefinitionsRepository.RepositoryTableDefinition
    public static final HiveTableDefinition BUCKETED_PARTITIONED_NATION = HiveTableDefinition.builder((String)"bucket_partition_nation").setCreateTableDDLTemplate("CREATE TABLE %NAME%(n_nationkey     BIGINT,n_name          STRING,n_regionkey     BIGINT,n_comment       STRING) PARTITIONED BY (part_key STRING) CLUSTERED BY (n_regionkey) INTO 2 BUCKETS ROW FORMAT DELIMITED FIELDS TERMINATED BY '|'").setNoData().build();
    @TableDefinitionsRepository.RepositoryTableDefinition
    public static final HiveTableDefinition PARTITIONED_NATION = HiveTableDefinition.builder((String)"partitioned_nation").setCreateTableDDLTemplate("CREATE TABLE %NAME%(n_nationkey     BIGINT,n_name          STRING,n_regionkey     BIGINT,n_comment       STRING) PARTITIONED BY (part_key STRING) ROW FORMAT DELIMITED FIELDS TERMINATED BY '|'").setNoData().build();

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{MutableTableRequirement.builder((TableDefinition)BUCKETED_PARTITIONED_NATION).withState(MutableTableRequirement.State.CREATED).build(), TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION)});
    }

    @Test(groups={"big_query"})
    public void testIgnorePartitionBucketingIfNotBucketed() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_1'");
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_2'");
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s NOT CLUSTERED", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(DISTINCT n_nationkey), count(*) FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25, 50})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
    }

    @Test(groups={"big_query"})
    public void testAllowMultipleFilesPerBucket() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)BUCKETED_PARTITIONED_NATION).getNameInDatabase();
        for (int i = 0; i < 3; ++i) {
            TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert'");
        }
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(DISTINCT n_nationkey), count(*) FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasRowsCount(1).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25, 75})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
    }

    @Test(groups={"big_query"})
    public void testIgnorePartitionBucketingIfBucketedExecutionDisabled() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)PARTITIONED_NATION).getNameInDatabase();
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_1'");
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CLUSTERED BY regionkey INTO 2 BUCKETS", tableName), new QueryExecutor.QueryParam[0]);
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_2'");
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CLUSTERED BY regionkey INTO 5 BUCKETS", tableName), new QueryExecutor.QueryParam[0]);
        TestHiveBucketedTables.populateHivePartitionedTable(tableName, TpchTableDefinitions.NATION.getName(), "part_key = 'insert_3'");
        TestHiveBucketedTables.disableBucketedExecution();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
    }

    @Test(groups={"big_query"})
    public void testIgnoreTableBucketingIfBucketedExecutionDisabled() {
        String tableName = MutableTablesState.mutableTablesState().get((TableDefinition)TpchTableDefinitions.NATION).getNameInDatabase();
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CLUSTERED BY regionkey INTO 2 BUCKETS", tableName), new QueryExecutor.QueryParam[0]);
        TestHiveBucketedTables.populateHiveUnpartitionedTable(tableName, TpchTableDefinitions.NATION.getName());
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CLUSTERED BY regionkey INTO 5 BUCKETS", tableName), new QueryExecutor.QueryParam[0]);
        TestHiveBucketedTables.disableBucketedExecution();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT count(*) FROM %s WHERE n_nationkey = 1", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
    }

    private static void populateHivePartitionedTable(String destination, String source, String partition) {
        String queryStatement = String.format("INSERT INTO TABLE %s PARTITION (%s) SELECT * FROM %s", destination, partition, source);
        QueryExecutors.onHive().executeQuery("set hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.enforce.sorting = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(queryStatement, new QueryExecutor.QueryParam[0]);
    }

    private static void populateHiveUnpartitionedTable(String destination, String source) {
        String queryStatement = String.format("INSERT INTO TABLE %s SELECT * FROM %s", destination, source);
        QueryExecutors.onHive().executeQuery("set hive.enforce.bucketing = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.enforce.sorting = true", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(queryStatement, new QueryExecutor.QueryParam[0]);
    }

    private static void disableBucketedExecution() {
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        try {
            JdbcDriverUtils.setSessionProperty(connection, "bucketed_execution_enabled", "false");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

