/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.jdbc.PrestoArray;
import com.facebook.presto.tests.utils.JdbcDriverUtils;
import com.facebook.presto.tests.utils.QueryExecutors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.Requires;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.context.ThreadLocalTestContextHolder;
import io.prestodb.tempto.fulfillment.table.MutableTableRequirement;
import io.prestodb.tempto.fulfillment.table.MutableTablesState;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableHandle;
import io.prestodb.tempto.fulfillment.table.TableInstance;
import io.prestodb.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.sql.Connection;
import java.sql.JDBCType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCoercion
extends ProductTest {
    public static final HiveTableDefinition HIVE_COERCION_TEXTFILE = TestHiveCoercion.tableDefinitionBuilder("TEXTFILE", Optional.empty(), Optional.of("DELIMITED FIELDS TERMINATED BY '|'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_PARQUET = TestHiveCoercion.tableDefinitionBuilder("PARQUET", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_AVRO = TestHiveCoercion.avroTableDefinitionBuilder().setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_ORC = TestHiveCoercion.tableDefinitionBuilder("ORC", Optional.empty(), Optional.empty()).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCTEXT = TestHiveCoercion.tableDefinitionBuilder("RCFILE", Optional.of("RCTEXT"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe'")).setNoData().build();
    public static final HiveTableDefinition HIVE_COERCION_RCBINARY = TestHiveCoercion.tableDefinitionBuilder("RCFILE", Optional.of("RCBINARY"), Optional.of("SERDE 'org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe'")).setNoData().build();

    private static HiveTableDefinition.HiveTableDefinitionBuilder tableDefinitionBuilder(String fileFormat, Optional<String> recommendTableName, Optional<String> rowFormat) {
        String tableName = String.format("%s_hive_coercion", recommendTableName.orElse(fileFormat).toLowerCase(Locale.ENGLISH));
        String floatToDoubleType = fileFormat.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "FLOAT";
        return HiveTableDefinition.builder((String)tableName).setCreateTableDDLTemplate("CREATE TABLE %NAME%(    tinyint_to_smallint        TINYINT,    tinyint_to_int             TINYINT,    tinyint_to_bigint          TINYINT,    smallint_to_int            SMALLINT,    smallint_to_bigint         SMALLINT,    int_to_bigint              INT,    bigint_to_varchar          BIGINT,    float_to_double            " + floatToDoubleType + ",    row_to_row                 STRUCT<keep: STRING, ti2si: TINYINT, si2int: SMALLINT, int2bi: INT, bi2vc: BIGINT>,    list_to_list               ARRAY<STRUCT<ti2int: TINYINT, si2bi: SMALLINT, bi2vc: BIGINT, remove: STRING>>,    map_to_map                 MAP<TINYINT, STRUCT<ti2bi: TINYINT, int2bi: INT, float2double: " + floatToDoubleType + ">>) PARTITIONED BY (id BIGINT) " + rowFormat.map(s -> String.format("ROW FORMAT %s ", s)).orElse("") + "STORED AS " + fileFormat);
    }

    private static HiveTableDefinition.HiveTableDefinitionBuilder avroTableDefinitionBuilder() {
        return HiveTableDefinition.builder((String)"avro_hive_coercion").setCreateTableDDLTemplate("CREATE TABLE %NAME%(    int_to_bigint              INT,    float_to_double            DOUBLE) PARTITIONED BY (id BIGINT) STORED AS AVRO");
    }

    @Requires(value={TextRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionTextFile() {
        this.doTestHiveCoercion(HIVE_COERCION_TEXTFILE);
    }

    @Requires(value={OrcRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionOrc() {
        this.doTestHiveCoercion(HIVE_COERCION_ORC);
    }

    @Requires(value={RcTextRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionRcText() {
        this.doTestHiveCoercion(HIVE_COERCION_RCTEXT);
    }

    @Requires(value={RcBinaryRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionRcBinary() {
        this.doTestHiveCoercion(HIVE_COERCION_RCBINARY);
    }

    @Requires(value={ParquetRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionParquet() {
        this.doTestHiveCoercion(HIVE_COERCION_PARQUET);
    }

    @Requires(value={AvroRequirements.class})
    @Test(groups={"hive_coercion", "jdbc"})
    public void testHiveCoercionAvro() {
        String tableName = TestHiveCoercion.mutableTableInstanceOf((TableDefinition)HIVE_COERCION_AVRO).getNameInDatabase();
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s PARTITION (id=1) VALUES(2323, 0.5),(-2323, -1.5)", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW COLUMNS FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
        QueryResult queryResult = QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.BIGINT, JDBCType.DOUBLE, JDBCType.BIGINT});
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2323L, 0.5, 1}), QueryAssert.Row.row((Object[])new Object[]{-2323L, -1.5, 1})});
    }

    private void doTestHiveCoercion(HiveTableDefinition tableDefinition) {
        ImmutableList expectedRows;
        String tableName = TestHiveCoercion.mutableTableInstanceOf((TableDefinition)tableDefinition).getNameInDatabase();
        String floatToDoubleType = tableName.toLowerCase(Locale.ENGLISH).contains("parquet") ? "DOUBLE" : "REAL";
        QueryExecutor.query((String)String.format("INSERT INTO %s\nVALUES\n  (TINYINT '-1', TINYINT '2', TINYINT '-3', SMALLINT '100', SMALLINT '-101', INTEGER '2323', 12345, REAL '0.5',\n    CAST(ROW ('as is', -1, 100, 2323, 12345) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT)),\n    ARRAY [CAST(ROW (2, -101, 12345, 'removed') AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],\n    MAP (ARRAY [TINYINT '2'], ARRAY [CAST(ROW (-3, 2323, REAL '0.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %s))]),\n    1),\n  (TINYINT '1', TINYINT '-2', NULL, SMALLINT '-100', SMALLINT '101', INTEGER '-2323', -12345, REAL '-1.5',\n    CAST(ROW (NULL, 1, -100, -2323, -12345) AS ROW(keep VARCHAR, ti2si TINYINT, si2int SMALLINT, int2bi INTEGER, bi2vc BIGINT)),\n    ARRAY [CAST(ROW (-2, 101, -12345, NULL) AS ROW (ti2int TINYINT, si2bi SMALLINT, bi2vc BIGINT, remove VARCHAR))],\n    MAP (ARRAY [TINYINT '-2'], ARRAY [CAST(ROW (null, -2323, REAL '-1.5') AS ROW (ti2bi TINYINT, int2bi INTEGER, float2double %s))]),\n    1)", tableName, floatToDoubleType, floatToDoubleType), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestHiveCoercion.alterTableColumnTypes(tableName);
        this.assertProperAlteredTableSchema(tableName);
        QueryResult queryResult = QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        this.assertColumnTypes(queryResult);
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        if (JdbcDriverUtils.usingPrestoJdbcDriver(connection)) {
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{-1, 2, -3L, 100, -101L, 2323L, "12345", 0.5, TestHiveCoercion.asMap("keep", "as is", "ti2si", (short)-1, "si2int", 100, "int2bi", 2323L, "bi2vc", "12345"), ImmutableList.of(TestHiveCoercion.asMap("ti2int", 2, "si2bi", -101L, "bi2vc", "12345")), TestHiveCoercion.asMap(2, TestHiveCoercion.asMap("ti2bi", -3L, "int2bi", 2323L, "float2double", 0.5, "add", null)), 1}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, -2, null, -100, 101L, -2323L, "-12345", -1.5, TestHiveCoercion.asMap("keep", null, "ti2si", (short)1, "si2int", -100, "int2bi", -2323L, "bi2vc", "-12345"), ImmutableList.of(TestHiveCoercion.asMap("ti2int", -2, "si2bi", 101L, "bi2vc", "-12345")), ImmutableMap.of((Object)-2, TestHiveCoercion.asMap("ti2bi", null, "int2bi", -2323L, "float2double", -1.5, "add", null)), 1}));
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(connection)) {
            expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{-1, 2, -3L, 100, -101L, 2323L, "12345", 0.5, "[\"as is\",-1,100,2323,\"12345\"]", "[[2,-101,\"12345\"]]", "{\"2\":[-3,2323,0.5,null]}", 1}), (Object)QueryAssert.Row.row((Object[])new Object[]{1, -2, null, -100, 101L, -2323L, "-12345", -1.5, "[null,1,-100,-2323,\"-12345\"]", "[[-2,101,\"-12345\"]]", "{\"-2\":[null,-2323,-1.5,null]}", 1}));
        } else {
            throw new IllegalStateException();
        }
        QueryAssert.assertThat((QueryResult)queryResult.project(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 12})).containsOnly(TestHiveCoercion.project((List<QueryAssert.Row>)expectedRows, 1, 2, 3, 4, 5, 6, 7, 8, 12));
        Assertions.assertEqualsIgnoreOrder((Iterable)queryResult.column(9), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, 9), (String)"row_to_row field is not equal");
        if (JdbcDriverUtils.usingPrestoJdbcDriver(connection)) {
            Assertions.assertEqualsIgnoreOrder(TestHiveCoercion.extract(queryResult.column(10)), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, 10), (String)"list_to_list field is not equal");
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(connection)) {
            Assertions.assertEqualsIgnoreOrder((Iterable)queryResult.column(10), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, 10), (String)"list_to_list field is not equal");
        } else {
            throw new IllegalStateException();
        }
        Assertions.assertEqualsIgnoreOrder((Iterable)queryResult.column(11), TestHiveCoercion.column((List<QueryAssert.Row>)expectedRows, 11), (String)"map_to_map field is not equal");
    }

    private void assertProperAlteredTableSchema(String tableName) {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW COLUMNS FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).project(new int[]{1, 2})).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"tinyint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_int", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"smallint_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"int_to_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"bigint_to_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"float_to_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"row_to_row", "row(\"keep\" varchar, \"ti2si\" smallint, \"si2int\" integer, \"int2bi\" bigint, \"bi2vc\" varchar)"}), QueryAssert.Row.row((Object[])new Object[]{"list_to_list", "array(row(\"ti2int\" integer, \"si2bi\" bigint, \"bi2vc\" varchar))"}), QueryAssert.Row.row((Object[])new Object[]{"map_to_map", "map(integer, row(\"ti2bi\" bigint, \"int2bi\" bigint, \"float2double\" double, \"add\" tinyint))"}), QueryAssert.Row.row((Object[])new Object[]{"id", "bigint"})});
    }

    private void assertColumnTypes(QueryResult queryResult) {
        Connection connection = QueryExecutor.defaultQueryExecutor().getConnection();
        if (JdbcDriverUtils.usingPrestoJdbcDriver(connection)) {
            QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.VARCHAR, JDBCType.DOUBLE, JDBCType.JAVA_OBJECT, JDBCType.ARRAY, JDBCType.JAVA_OBJECT, JDBCType.BIGINT});
        } else if (JdbcDriverUtils.usingTeradataJdbcDriver(connection)) {
            QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.BIGINT, JDBCType.VARCHAR, JDBCType.DOUBLE, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.BIGINT});
        } else {
            throw new IllegalStateException();
        }
    }

    private static void alterTableColumnTypes(String tableName) {
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_smallint tinyint_to_smallint smallint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_int tinyint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN tinyint_to_bigint tinyint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_int smallint_to_int int", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN smallint_to_bigint smallint_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN int_to_bigint int_to_bigint bigint", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN bigint_to_varchar bigint_to_varchar string", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN float_to_double float_to_double double", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN row_to_row row_to_row struct<keep:string, ti2si:smallint, si2int:int, int2bi:bigint, bi2vc:string>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN list_to_list list_to_list array<struct<ti2int:int, si2bi:bigint, bi2vc:string>>", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN map_to_map map_to_map map<int,struct<ti2bi:bigint, int2bi:bigint, float2double:double, add:tinyint>>", tableName), new QueryExecutor.QueryParam[0]);
    }

    private static TableInstance mutableTableInstanceOf(TableDefinition tableDefinition) {
        if (tableDefinition.getDatabase().isPresent()) {
            return TestHiveCoercion.mutableTableInstanceOf(tableDefinition, (String)tableDefinition.getDatabase().get());
        }
        return TestHiveCoercion.mutableTableInstanceOf(TestHiveCoercion.tableHandleInSchema(tableDefinition));
    }

    private static TableInstance mutableTableInstanceOf(TableDefinition tableDefinition, String database) {
        return TestHiveCoercion.mutableTableInstanceOf(TestHiveCoercion.tableHandleInSchema(tableDefinition).inDatabase(database));
    }

    private static TableInstance mutableTableInstanceOf(TableHandle tableHandle) {
        return ((MutableTablesState)ThreadLocalTestContextHolder.testContext().getDependency(MutableTablesState.class)).get(tableHandle);
    }

    private static TableHandle tableHandleInSchema(TableDefinition tableDefinition) {
        TableHandle tableHandle = TableHandle.tableHandle((String)tableDefinition.getName());
        if (tableDefinition.getSchema().isPresent()) {
            tableHandle = tableHandle.inSchema((String)tableDefinition.getSchema().get());
        }
        return tableHandle;
    }

    private static Map<Object, Object> asMap(Object ... objects) {
        Assert.assertEquals((int)(objects.length % 2), (int)0, (String)"number of objects must be even");
        HashMap<Object, Object> struct = new HashMap<Object, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            struct.put(objects[i], objects[i + 1]);
        }
        return struct;
    }

    private static QueryAssert.Row project(QueryAssert.Row row, int ... columns) {
        return new QueryAssert.Row(Arrays.stream(columns).mapToObj(column -> row.getValues().get(column - 1)).collect(Collectors.toList()));
    }

    private static List<QueryAssert.Row> project(List<QueryAssert.Row> rows, int ... columns) {
        return (List)rows.stream().map(row -> TestHiveCoercion.project(row, columns)).collect(ImmutableList.toImmutableList());
    }

    private static List<?> column(List<QueryAssert.Row> rows, int sqlColumnIndex) {
        return rows.stream().map(row -> TestHiveCoercion.project(row, sqlColumnIndex).getValues().get(0)).collect(Collectors.toList());
    }

    private static List<List<?>> extract(List<PrestoArray> arrays) {
        return (List)arrays.stream().map(prestoArray -> Arrays.asList((Object[])prestoArray.getArray())).collect(ImmutableList.toImmutableList());
    }

    public static final class AvroRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_AVRO).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class ParquetRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_PARQUET).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcBinaryRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCBINARY).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class RcTextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_RCTEXT).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class OrcRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_ORC).withState(MutableTableRequirement.State.CREATED).build();
        }
    }

    public static final class TextRequirements
    implements RequirementsProvider {
        public Requirement getRequirements(Configuration configuration) {
            return MutableTableRequirement.builder((TableDefinition)HIVE_COERCION_TEXTFILE).withState(MutableTableRequirement.State.CREATED).build();
        }
    }
}

