/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.presto.tests.hive.util.TemporaryHiveTable;
import com.facebook.presto.tests.utils.JdbcDriverUtils;
import com.facebook.presto.tests.utils.QueryExecutors;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.query.QueryExecutionException;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.testng.annotations.Test;

public class TestHivePartitionSchemaEvolution
extends ProductTest {
    @BeforeTestWithContext
    public void useColumnMappingByName() throws SQLException {
        JdbcDriverUtils.setSessionProperty(QueryExecutors.onPresto().getConnection(), "hive.parquet_use_column_names", "true");
    }

    @Test(groups={"hive_partitioning"})
    public void testParquet() {
        this.test(() -> TestHivePartitionSchemaEvolution.createTable("PARQUET"));
    }

    private void test(Supplier<TemporaryHiveTable> temporaryHiveTableSupplier) {
        try (TemporaryHiveTable table = temporaryHiveTableSupplier.get();){
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (float_column float, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1.1, "imjalpreet", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1, "imjalpreet", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, float_column float)", QueryAssert.Row.row((Object[])new Object[]{1, 1.1, 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (tiny_column tinyint, int_column int, float_column float, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{null, 1, 1.1, "imjalpreet", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, tiny_column tinyint, float_column float, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1, null, 1.1, "imjalpreet", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, float_column float, varchar_column varchar(20), tiny_column tinyint)", QueryAssert.Row.row((Object[])new Object[]{1, 1.1, "imjalpreet", null, 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column int, tiny_column tinyint, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1, null, "imjalpreet", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (int_column bigint, float_column double, varchar_column varchar(20))", QueryAssert.Row.row((Object[])new Object[]{1, 1.1, "imjalpreet", 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (varchar_column varchar(20), float_column double, int_column bigint)", QueryAssert.Row.row((Object[])new Object[]{"imjalpreet", 1.1, 1, 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (float_column double, int_column bigint)", QueryAssert.Row.row((Object[])new Object[]{1.1, 1, 1}));
            this.testEvolution(table, "ALTER TABLE %s REPLACE COLUMNS (varchar_column varchar(20), tiny_column tinyint, float_column double, int_column bigint)", QueryAssert.Row.row((Object[])new Object[]{"imjalpreet", null, 1.1, 1, 1}));
        }
    }

    private void testEvolution(TemporaryHiveTable table, String sql, QueryAssert.Row row) {
        if (TestHivePartitionSchemaEvolution.tryExecuteOnHive(String.format(sql, table.getName()))) {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM " + table.getName(), new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{row});
        }
    }

    private static boolean tryExecuteOnHive(String sql) {
        try {
            QueryExecutors.onHive().executeQuery(sql, new QueryExecutor.QueryParam[0]);
            return true;
        }
        catch (QueryExecutionException e) {
            String message = e.getMessage();
            if (message.contains("Unable to alter table. The following columns have types incompatible with the existing columns in their respective positions") || message.contains("Replacing columns cannot drop columns") || message.contains("Replace columns is not supported for")) {
                return false;
            }
            throw e;
        }
    }

    private static TemporaryHiveTable createTable(String format) {
        String tableName = "schema_evolution_" + TemporaryHiveTable.randomTableSuffix();
        TestHivePartitionSchemaEvolution.tryExecuteOnHive(String.format("CREATE TABLE %s (  int_column int,  float_column float,  varchar_column varchar(20)) PARTITIONED BY (partition_column bigint) STORED AS %s", tableName, format));
        TemporaryHiveTable temporaryHiveTable = TemporaryHiveTable.temporaryHiveTable(tableName);
        try {
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (1, 1.1, 'imjalpreet', 1)", tableName), new QueryExecutor.QueryParam[0]);
        }
        catch (Exception e) {
            temporaryHiveTable.closeQuietly(e);
            throw e;
        }
        return temporaryHiveTable;
    }
}

