/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.google.common.math.IntMath;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.Requirements;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.MutableTableRequirement;
import io.prestodb.tempto.fulfillment.table.MutableTablesState;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.fulfillment.table.hive.HiveDataSource;
import io.prestodb.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.prestodb.tempto.fulfillment.table.hive.InlineDataSource;
import io.prestodb.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHivePartitionsTable
extends ProductTest
implements RequirementsProvider {
    private static final int TOO_MANY_PARTITIONS = 105;
    private static final String PARTITIONED_TABLE = "partitioned_table";
    private static final String PARTITIONED_TABLE_WITH_VARIABLE_PARTITIONS = "partitioned_table_with_variable_partitions";
    @Inject
    private MutableTablesState tablesState;

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION), TableRequirements.mutableTable((TableDefinition)TestHivePartitionsTable.partitionedTableDefinition(), (String)PARTITIONED_TABLE, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED), TableRequirements.mutableTable((TableDefinition)TestHivePartitionsTable.partitionedTableWithVariablePartitionsDefinition(), (String)PARTITIONED_TABLE_WITH_VARIABLE_PARTITIONS, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED)});
    }

    private static TableDefinition partitionedTableDefinition() {
        String createTableDdl = "CREATE EXTERNAL TABLE %NAME%(col INT) PARTITIONED BY (part_col INT) STORED AS ORC";
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)PARTITIONED_TABLE, (String)"com/facebook/presto/tests/hive/data/single_int_column/data.orc");
        HiveDataSource invalidData = InlineDataSource.createStringDataSource((String)PARTITIONED_TABLE, (String)"INVALID DATA");
        return HiveTableDefinition.builder((String)PARTITIONED_TABLE).setCreateTableDDLTemplate(createTableDdl).addPartition("part_col = 1", invalidData).addPartition("part_col = 2", dataSource).build();
    }

    private static TableDefinition partitionedTableWithVariablePartitionsDefinition() {
        String createTableDdl = "CREATE TABLE %NAME%(col INT) PARTITIONED BY (part_col INT) STORED AS ORC";
        return HiveTableDefinition.builder((String)PARTITIONED_TABLE_WITH_VARIABLE_PARTITIONS).setCreateTableDDLTemplate(createTableDdl).setNoData().build();
    }

    @Test(groups={"hive_partitioning"})
    public void testShowPartitionsFromHiveTable() {
        String tableNameInDatabase = this.tablesState.get(PARTITIONED_TABLE).getNameInDatabase();
        String partitionsTable = "\"" + tableNameInDatabase + "$partitions\"";
        QueryResult partitionListResult = QueryExecutor.query((String)("SELECT * FROM " + partitionsTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)partitionListResult).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
        TestHivePartitionsTable.assertColumnNames(partitionListResult, "part_col");
        partitionListResult = QueryExecutor.query((String)String.format("SELECT * FROM %s WHERE part_col = 1", partitionsTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)partitionListResult).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        TestHivePartitionsTable.assertColumnNames(partitionListResult, "part_col");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s WHERE no_such_column = 1", partitionsTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'no_such_column' cannot be resolved");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s WHERE col = 1", partitionsTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'col' cannot be resolved");
    }

    @Test(groups={"hive_partitioning"})
    public void testShowPartitionsFromUnpartitionedTable() {
        QueryAssert.assertThat(() -> QueryExecutor.query((String)"SELECT * FROM \"nation$partitions\"", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessageMatching(".*Table hive.default.nation\\$partitions does not exist");
    }

    @Test(groups={"hive_partitioning"})
    public void testShowPartitionsFromHiveTableWithTooManyPartitions() {
        String tableName = this.tablesState.get(PARTITIONED_TABLE_WITH_VARIABLE_PARTITIONS).getNameInDatabase();
        String partitionsTable = "\"" + tableName + "$partitions\"";
        this.createPartitions(tableName, 105);
        Assertions.assertThatThrownBy(() -> QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasMessageMatching(".*: Query over table '\\S+' can potentially read more than \\d+ partitions");
        QueryResult partitionListResult = QueryExecutor.query((String)String.format("SELECT * FROM %s WHERE part_col < 7", partitionsTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)partitionListResult).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4}), QueryAssert.Row.row((Object[])new Object[]{5}), QueryAssert.Row.row((Object[])new Object[]{6})});
        TestHivePartitionsTable.assertColumnNames(partitionListResult, "part_col");
        partitionListResult = QueryExecutor.query((String)String.format("SELECT * FROM %s WHERE part_col < -10", partitionsTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)partitionListResult).hasNoRows();
        partitionListResult = QueryExecutor.query((String)String.format("SELECT * FROM %s ORDER BY part_col LIMIT 7", partitionsTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)partitionListResult).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4}), QueryAssert.Row.row((Object[])new Object[]{5}), QueryAssert.Row.row((Object[])new Object[]{6})});
    }

    private void createPartitions(String tableName, int partitionsToCreate) {
        Objects.requireNonNull(tableName, "tableName is null");
        int maxPartitionsAtOnce = 100;
        IntStream.range(0, IntMath.divide((int)partitionsToCreate, (int)maxPartitionsAtOnce, (RoundingMode)RoundingMode.UP)).forEach(batch -> {
            int rangeStart = batch * maxPartitionsAtOnce;
            int rangeEndInclusive = Math.min((batch + 1) * maxPartitionsAtOnce, partitionsToCreate) - 1;
            QueryExecutor.query((String)String.format("INSERT INTO %s (part_col, col) SELECT CAST(id AS integer), 42 FROM UNNEST (sequence(%s, %s)) AS u(id)", tableName, rangeStart, rangeEndInclusive), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        });
    }

    private static void assertColumnNames(QueryResult queryResult, String ... columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            Assert.assertEquals((Object)queryResult.tryFindColumnIndex(columnNames[i]), Optional.of(i + 1), (String)("Index of column " + columnNames[i]));
        }
        Assert.assertEquals((int)queryResult.getColumnsCount(), (int)columnNames.length);
    }
}

