/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.presto.tests.hive.AllSimpleTypesTableDefinitions;
import com.facebook.presto.tests.hive.HiveTableDefinitions;
import com.facebook.presto.tests.utils.QueryExecutors;
import com.google.common.collect.ImmutableList;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.Requirements;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.Requires;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.MutableTableRequirement;
import io.prestodb.tempto.fulfillment.table.MutableTablesState;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.prestodb.tempto.fulfillment.table.hive.InlineDataSource;
import io.prestodb.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.util.List;
import org.testng.annotations.Test;

public class TestHiveTableStatistics
extends ProductTest {
    private static final String ALL_TYPES_TABLE_NAME = "all_types";
    private static final String EMPTY_ALL_TYPES_TABLE_NAME = "empty_all_types";
    private static final String ALL_TYPES_ALL_NULL_TABLE_NAME = "all_types_all_null";
    private static final HiveTableDefinition ALL_TYPES_TABLE = HiveTableDefinition.like((HiveTableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE).setDataSource(InlineDataSource.createStringDataSource((String)"all_analyzable_types", (String)"121|32761|2147483641|9223372036854775801|123.341|234.561|344.671|345.671|2015-05-10 12:15:31.123456|2015-05-09|ela ma kota|ela ma kot|ela ma    |false|cGllcyBiaW5hcm55|\n127|32767|2147483647|9223372036854775807|123.345|235.567|345.678|345.678|2015-05-10 12:15:35.123456|2015-06-10|ala ma kota|ala ma kot|ala ma    |true|a290IGJpbmFybnk=|\n")).build();
    private static final HiveTableDefinition ALL_TYPES_ALL_NULL_TABLE = HiveTableDefinition.like((HiveTableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE).setDataSource(InlineDataSource.createStringDataSource((String)"all_analyzable_types_all_null", (String)"\\N|\\N|\\N|\\N|\\N|\\N|\\N|\\N|\\N|\\N|\\N|\\N|\\N|\\N|\\N|\n")).build();
    private static final List<QueryAssert.Row> ALL_TYPES_TABLE_STATISTICS = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 2.0, 0.0, null, "121", "127"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 2.0, 0.0, null, "32761", "32767"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 2.0, 0.0, null, "2147483641", "2147483647"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 2.0, 0.0, null, "9223372036854775807", "9223372036854775807"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 2.0, 0.0, null, "123.341", "123.345"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 2.0, 0.0, null, "234.561", "235.567"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 2.0, 0.0, null, "345.0", "346.0"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 2.0, 0.0, null, "345.671", "345.678"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 2.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 2.0, 0.0, null, "2015-05-09", "2015-06-10"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 22.0, 2.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 20.0, 2.0, 0.0, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 12.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 23.0, null, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
    private static final List<QueryAssert.Row> ALL_TYPES_ALL_NULL_TABLE_STATISTICS = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 0.0, 0.0, 1.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 0.0, 0.0, 1.0, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 0.0, null, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
    private static final List<QueryAssert.Row> ALL_TYPES_EMPTY_TABLE_STATISTICS = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 0.0, 0.0, 0.0, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 0.0, 0.0, 0.0, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 0.0, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 0.0, null, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 0.0, null, null})});

    @Test
    @Requires(value={UnpartitionedNationTable.class})
    public void testStatisticsForUnpartitionedTable() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TpchTableDefinitions.NATION.getName()).getNameInDatabase();
        String showStatsWholeTable = "SHOW STATS FOR " + tableNameInDatabase;
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_name", null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_regionkey", null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_comment", null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 25.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", null, 19.0, 0.0, null, "0", "24"}), QueryAssert.Row.row((Object[])new Object[]{"n_name", 177.0, 24.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_regionkey", null, 5.0, 0.0, null, "0", "4"}), QueryAssert.Row.row((Object[])new Object[]{"n_comment", 1857.0, 25.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 25.0, null, null})});
    }

    @Test
    @Requires(value={NationPartitionedByBigintTable.class})
    public void testStatisticsForTablePartitionedByBigint() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getName()).getNameInDatabase();
        String showStatsWholeTable = "SHOW STATS FOR " + tableNameInDatabase;
        String showStatsPartitionOne = "SHOW STATS FOR (SELECT * FROM " + tableNameInDatabase + " WHERE p_regionkey = 1)";
        String showStatsPartitionTwo = "SHOW STATS FOR (SELECT * FROM " + tableNameInDatabase + " WHERE p_regionkey = 2)";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " PARTITION (p_regionkey = \"1\") COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 3.0, 0.0, null, "1", "3"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " PARTITION (p_regionkey) COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 3.0, 0.0, null, "1", "3"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "2", "2"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " PARTITION (p_regionkey = \"1\") COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 114.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 3.0, 0.0, null, "1", "3"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 1497.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "2", "2"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " PARTITION (p_regionkey) COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 109.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 3.0, 0.0, null, "1", "3"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 1197.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 4.0, 0.0, null, "8", "21"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 31.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "2", "2"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 351.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
    }

    @Test
    @Requires(value={NationPartitionedByVarcharTable.class})
    public void testStatisticsForTablePartitionedByVarchar() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_VARCHAR_REGIONKEY.getName()).getNameInDatabase();
        String showStatsWholeTable = "SHOW STATS FOR " + tableNameInDatabase;
        String showStatsPartitionOne = "SHOW STATS FOR (SELECT * FROM " + tableNameInDatabase + " WHERE p_regionkey = 'AMERICA')";
        String showStatsPartitionTwo = "SHOW STATS FOR (SELECT * FROM " + tableNameInDatabase + " WHERE p_regionkey = 'ASIA')";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " PARTITION (p_regionkey = \"AMERICA\") COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 85.0, 3.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 35.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " PARTITION (p_regionkey) COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 85.0, 3.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 35.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 20.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " PARTITION (p_regionkey = \"AMERICA\") COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 114.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 85.0, 3.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 1497.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 35.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 20.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " PARTITION (p_regionkey) COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 109.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 85.0, 3.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 1197.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 35.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 4.0, 0.0, null, "8", "21"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 31.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 20.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 351.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
    }

    @Test(groups={"skip_on_cdh"})
    @Requires(value={AllTypesTable.class})
    public void testStatisticsForAllDataTypes() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(ALL_TYPES_TABLE_NAME).getNameInDatabase();
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 2.0, 0.0, null, "121", "127"}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 2.0, 0.0, null, "32761", "32767"}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 2.0, 0.0, null, "2147483641", "2147483647"}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 2.0, 0.0, null, "9223372036854775807", "9223372036854775807"}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 2.0, 0.0, null, "123.341", "123.345"}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 2.0, 0.0, null, "234.561", "235.567"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 2.0, 0.0, null, "345.0", "346.0"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 2.0, 0.0, null, "345.671", "345.678"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 2.0, 0.0, null, "2015-05-09", "2015-06-10"}), QueryAssert.Row.row((Object[])new Object[]{"c_string", 22.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 20.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 12.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 23.0, null, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
    }

    @Test(groups={"skip_on_cdh"})
    @Requires(value={AllTypesTable.class})
    public void testStatisticsForAllDataTypesNoData() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(EMPTY_ALL_TYPES_TABLE_NAME).getNameInDatabase();
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 0.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", 0.0, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 0.0, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 0.0, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 0.0, null, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 0.0, null, null})});
    }

    @Test(groups={"skip_on_cdh"})
    @Requires(value={AllTypesTable.class})
    public void testStatisticsForAllDataTypesOnlyNulls() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(EMPTY_ALL_TYPES_TABLE_NAME).getNameInDatabase();
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableNameInDatabase + " VALUES(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableNameInDatabase + " COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 0.0, null, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
    }

    @Test
    @Requires(value={UnpartitionedNationTable.class})
    public void testStatisticsForSkewedTable() {
        String tableName = "test_hive_skewed_table_statistics";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (c_string STRING, c_int INT) SKEWED BY (c_string) ON ('c1')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + " VALUES ('c1', 1), ('c1', 2)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE " + tableName + " COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_string", 4.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 2.0, 0.0, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
    }

    @Test
    @Requires(value={UnpartitionedNationTable.class})
    public void testAnalyzesForSkewedTable() {
        String tableName = "test_analyze_skewed_table";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (c_string STRING, c_int INT) SKEWED BY (c_string) ON ('c1')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + " VALUES ('c1', 1), ('c1', 2)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_string", 4.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 2.0, 0.0, null, "1", "2"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
    }

    @Test
    @Requires(value={UnpartitionedNationTable.class})
    public void testAnalyzeForUnpartitionedTable() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TpchTableDefinitions.NATION.getName()).getNameInDatabase();
        String showStatsWholeTable = "SHOW STATS FOR " + tableNameInDatabase;
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_name", null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_regionkey", null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_comment", null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, QueryAssert.anyOf((Object[])new Object[]{null, 0.0}), null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", null, 25.0, 0.0, null, "0", "24"}), QueryAssert.Row.row((Object[])new Object[]{"n_name", 177.0, 25.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"n_regionkey", null, 5.0, 0.0, null, "0", "4"}), QueryAssert.Row.row((Object[])new Object[]{"n_comment", 1857.0, 25.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 25.0, null, null})});
    }

    @Test
    public void testAnalyzeForTableWithNonPrimitiveTypes() {
        String tableName = "test_analyze_table_complex_types";
        String showStatsTable = "SHOW STATS FOR " + tableName;
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("CREATE TABLE " + tableName + "(c_row row(c1 int, c2 int), c_char char, c_int int)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (row(1,2), 'a', 3)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_row", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 1.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 1.0, 0.0, null, "3", "3"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
    }

    @Test
    public void testAnalyzeForPartitionedTableWithNonPrimitiveTypes() {
        String tableName = "test_analyze_partitioned_table_complex_types";
        String showStatsTable = "SHOW STATS FOR " + tableName;
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("CREATE TABLE " + tableName + "(c_row row(c1 int, c2 int), c_char char, c_int int, c_part char) WITH (partitioned_by = ARRAY['c_part'])"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (row(1,2), 'a', 3, '1')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (row(4,5), 'b', 5, '2')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (row(6,7), 'c', 5, '2')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_row", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 3.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 1.0, 0.0, null, "3", "5"}), QueryAssert.Row.row((Object[])new Object[]{"c_part", 3.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 3.0, null, null})});
    }

    @Test
    @Requires(value={NationPartitionedByBigintTable.class})
    public void testAnalyzeForTablePartitionedByBigint() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getName()).getNameInDatabase();
        String showStatsWholeTable = "SHOW STATS FOR " + tableNameInDatabase;
        String showStatsPartitionOne = "SHOW STATS FOR (SELECT * FROM " + tableNameInDatabase + " WHERE p_regionkey = 1)";
        String showStatsPartitionTwo = "SHOW STATS FOR (SELECT * FROM " + tableNameInDatabase + " WHERE p_regionkey = 2)";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableNameInDatabase + " WITH (partitions = ARRAY[ARRAY['1']])"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 114.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 3.0, 0.0, null, "1", "3"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 1497.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{15})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 109.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 3.0, 0.0, null, "1", "3"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 1197.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "8", "21"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 31.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "2", "2"}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 351.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
    }

    @Test
    @Requires(value={NationPartitionedByVarcharTable.class})
    public void testAnalyzeForTablePartitionedByVarchar() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_VARCHAR_REGIONKEY.getName()).getNameInDatabase();
        String showStatsWholeTable = "SHOW STATS FOR " + tableNameInDatabase;
        String showStatsPartitionOne = "SHOW STATS FOR (SELECT * FROM " + tableNameInDatabase + " WHERE p_regionkey = 'AMERICA')";
        String showStatsPartitionTwo = "SHOW STATS FOR (SELECT * FROM " + tableNameInDatabase + " WHERE p_regionkey = 'ASIA')";
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableNameInDatabase + " WITH (partitions = ARRAY[ARRAY['AMERICA']])"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 114.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 85.0, 3.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 1497.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 35.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{15})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsWholeTable, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 109.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 85.0, 3.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 1197.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 15.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 35.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "8", "21"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 31.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", 20.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 351.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
    }

    @Test(groups={"skip_on_cdh"})
    @Requires(value={AllTypesTable.class})
    public void testAnalyzeForAllDataTypes() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(ALL_TYPES_TABLE_NAME).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 0.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 2.0, 0.0, null, "121", "127"}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 2.0, 0.0, null, "32761", "32767"}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 2.0, 0.0, null, "2147483641", "2147483647"}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 2.0, 0.0, null, "9223372036854775807", "9223372036854775807"}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 2.0, 0.0, null, "123.341", "123.345"}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 2.0, 0.0, null, "234.561", "235.567"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 2.0, 0.0, null, "345.0", "346.0"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 2.0, 0.0, null, "345.671", "345.678"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 2.0, 0.0, null, "2015-05-09", "2015-06-10"}), QueryAssert.Row.row((Object[])new Object[]{"c_string", 22.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 20.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 12.0, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 2.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 23.0, null, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})});
    }

    @Test(groups={"skip_on_cdh"})
    @Requires(value={AllTypesTable.class})
    public void testAnalyzeForAllDataTypesNoData() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(EMPTY_ALL_TYPES_TABLE_NAME).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 0.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", 0.0, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 0.0, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 0.0, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 0.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 0.0, null, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 0.0, null, null})});
    }

    @Test(groups={"skip_on_cdh"})
    @Requires(value={AllTypesTable.class})
    public void testAnalyzeForAllDataTypesOnlyNulls() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(EMPTY_ALL_TYPES_TABLE_NAME).getNameInDatabase();
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableNameInDatabase + " VALUES(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("ANALYZE " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_string", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 0.0, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 0.0, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 0.0, null, 1.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 1.0, null, null})});
    }

    @Test
    @Requires(value={AllTypesTable.class})
    public void testComputeTableStatisticsOnCreateTable() {
        String allTypesTable = MutableTablesState.mutableTablesState().get(ALL_TYPES_TABLE_NAME).getNameInDatabase();
        String emptyAllTypesTable = MutableTablesState.mutableTablesState().get(EMPTY_ALL_TYPES_TABLE_NAME).getNameInDatabase();
        String allTypesAllNullTable = MutableTablesState.mutableTablesState().get(ALL_TYPES_ALL_NULL_TABLE_NAME).getNameInDatabase();
        TestHiveTableStatistics.assertComputeTableStatisticsOnCreateTable(allTypesTable, ALL_TYPES_TABLE_STATISTICS);
        TestHiveTableStatistics.assertComputeTableStatisticsOnCreateTable(emptyAllTypesTable, ALL_TYPES_EMPTY_TABLE_STATISTICS);
        TestHiveTableStatistics.assertComputeTableStatisticsOnCreateTable(allTypesAllNullTable, ALL_TYPES_ALL_NULL_TABLE_STATISTICS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Requires(value={AllTypesTable.class})
    public void testComputeTableStatisticsOnInsert() {
        String allTypesTable = MutableTablesState.mutableTablesState().get(ALL_TYPES_TABLE_NAME).getNameInDatabase();
        String emptyAllTypesTable = MutableTablesState.mutableTablesState().get(EMPTY_ALL_TYPES_TABLE_NAME).getNameInDatabase();
        String allTypesAllNullTable = MutableTablesState.mutableTablesState().get(ALL_TYPES_ALL_NULL_TABLE_NAME).getNameInDatabase();
        TestHiveTableStatistics.assertComputeTableStatisticsOnInsert(allTypesTable, ALL_TYPES_TABLE_STATISTICS);
        TestHiveTableStatistics.assertComputeTableStatisticsOnInsert(emptyAllTypesTable, ALL_TYPES_EMPTY_TABLE_STATISTICS);
        TestHiveTableStatistics.assertComputeTableStatisticsOnInsert(allTypesAllNullTable, ALL_TYPES_ALL_NULL_TABLE_STATISTICS);
        String tableName = "test_update_table_statistics";
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutor.query((String)String.format("CREATE TABLE %s AS SELECT * FROM %s WITH NO DATA", tableName, allTypesTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s SELECT * FROM %s", tableName, allTypesTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s SELECT * FROM %s", tableName, allTypesAllNullTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s SELECT * FROM %s", tableName, allTypesAllNullTable), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 2.0, 0.5, null, "121", "127"}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 2.0, 0.5, null, "32761", "32767"}), QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 2.0, 0.5, null, "2147483641", "2147483647"}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 2.0, 0.5, null, "9223372036854775807", "9223372036854775807"}), QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 2.0, 0.5, null, "123.341", "123.345"}), QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 2.0, 0.5, null, "234.561", "235.567"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 2.0, 0.5, null, "345.0", "346.0"}), QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 2.0, 0.5, null, "345.671", "345.678"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 2.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 2.0, 0.5, null, "2015-05-09", "2015-06-10"}), QueryAssert.Row.row((Object[])new Object[]{"c_string", 22.0, 2.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 20.0, 2.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_char", 12.0, 2.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 2.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 23.0, null, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 4.0, null, null})});
            QueryExecutor.query((String)String.format("INSERT INTO %s VALUES( TINYINT '120', SMALLINT '32760', INTEGER '2147483640', BIGINT '9223372036854775800', REAL '123.340', DOUBLE '234.560', CAST(343.0 AS DECIMAL(10, 0)), CAST(345.670 AS DECIMAL(10, 5)), TIMESTAMP '2015-05-10 12:15:30', DATE '2015-05-08', CAST('ela ma kot' AS VARCHAR), CAST('ela ma ko' AS VARCHAR(10)), CAST('ela m     ' AS CHAR(10)), false, CAST('cGllcyBiaW5hcm54' as VARBINARY))", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 2.0, 0.4, null, "120", "127"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 2.0, 0.4, null, "32760", "32767"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 2.0, 0.4, null, "2147483640", "2147483647"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 2.0, 0.4, null, "9223372036854775807", "9223372036854775807"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 2.0, 0.4, null, "123.34", "123.345"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 2.0, 0.4, null, "234.56", "235.567"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 2.0, 0.4, null, "343.0", "346.0"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 2.0, 0.4, null, "345.67", "345.678"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 2.0, 0.4, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 2.0, 0.4, null, "2015-05-08", "2015-06-10"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 32.0, 2.0, 0.4, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 29.0, 2.0, 0.4, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 17.0, 2.0, 0.4, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 2.0, 0.4, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 39.0, null, 0.4, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})}));
        }
        catch (Throwable throwable) {
            QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test
    @Requires(value={AllTypesTable.class})
    public void testComputePartitionStatisticsOnCreateTable() {
        String tableName = "test_compute_partition_statistics_on_create_table";
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutor.query((String)String.format("CREATE TABLE %s WITH (  partitioned_by = ARRAY['p_bigint', 'p_varchar']) AS SELECT * FROM (     VALUES         (           TINYINT '120',            SMALLINT '32760',            INTEGER '2147483640',            BIGINT '9223372036854775800',            REAL '123.340', DOUBLE '234.560',            CAST(343.0 AS DECIMAL(10, 0)),            CAST(345.670 AS DECIMAL(10, 5)),            TIMESTAMP '2015-05-10 12:15:30',            DATE '2015-05-08',            CAST('p1 varchar' AS VARCHAR),            CAST('p1 varchar10' AS VARCHAR(10)),            CAST('p1 char10' AS CHAR(10)), false,            CAST('p1 binary' as VARBINARY),            BIGINT '1',            CAST('partition1' AS VARCHAR)        ),         (null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, BIGINT '1', 'partition1'),         (           TINYINT '99',            SMALLINT '333',           INTEGER '444',            BIGINT '555',            REAL '666.340',            DOUBLE '777.560',            CAST(888.0 AS DECIMAL(10, 0)),            CAST(999.670 AS DECIMAL(10, 5)),            TIMESTAMP '2015-05-10 12:45:30',            DATE '2015-05-09',            CAST('p2 varchar' AS VARCHAR),            CAST('p2 varchar10' AS VARCHAR(10)),            CAST('p2 char10' AS CHAR(10)),            true,            CAST('p2 binary' as VARBINARY),            BIGINT '2',            CAST('partition2' AS VARCHAR)        ),         (null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, BIGINT '2', 'partition2') ) AS t (c_tinyint, c_smallint, c_int, c_bigint, c_float, c_double, c_decimal, c_decimal_w_params, c_timestamp, c_date, c_string, c_varchar, c_char, c_boolean, c_binary, p_bigint, p_varchar)", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_bigint = 1 AND p_varchar = 'partition1')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 1.0, 0.5, null, "120", "120"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 1.0, 0.5, null, "32760", "32760"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 1.0, 0.5, null, "2147483640", "2147483640"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 1.0, 0.5, null, "9223372036854775807", "9223372036854775807"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 1.0, 0.5, null, "123.34", "123.34"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 1.0, 0.5, null, "234.56", "234.56"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 1.0, 0.5, null, "343.0", "343.0"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 1.0, 0.5, null, "345.67", "345.67"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 1.0, 0.5, null, "2015-05-08", "2015-05-08"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 10.0, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 10.0, 1.0, 0.5, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 9.0, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 9.0, null, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_bigint", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_varchar", 20.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})}));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_bigint = 2 AND p_varchar = 'partition2')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 1.0, 0.5, null, "99", "99"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 1.0, 0.5, null, "333", "333"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 1.0, 0.5, null, "444", "444"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 1.0, 0.5, null, "555", "555"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 1.0, 0.5, null, "666.34", "666.34"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 1.0, 0.5, null, "777.56", "777.56"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 1.0, 0.5, null, "888.0", "888.0"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 1.0, 0.5, null, "999.67", "999.67"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 1.0, 0.5, null, "2015-05-09", "2015-05-09"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 10.0, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 10.0, 1.0, 0.5, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 9.0, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 9.0, null, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_bigint", null, 1.0, 0.0, null, "2", "2"}), QueryAssert.Row.row((Object[])new Object[]{"p_varchar", 20.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})}));
        }
        catch (Throwable throwable) {
            QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Requires(value={AllTypesTable.class})
    public void testComputePartitionStatisticsOnInsert() {
        String tableName = "test_compute_partition_statistics_on_insert";
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutor.query((String)String.format("CREATE TABLE %s(c_tinyint            TINYINT, c_smallint           SMALLINT, c_int                INT, c_bigint             BIGINT, c_float              REAL, c_double             DOUBLE, c_decimal            DECIMAL(10,0), c_decimal_w_params   DECIMAL(10,5), c_timestamp          TIMESTAMP, c_date               DATE, c_string             VARCHAR, c_varchar            VARCHAR(10), c_char               CHAR(10), c_boolean            BOOLEAN, c_binary             VARBINARY, p_bigint             BIGINT, p_varchar            VARCHAR ) WITH (  partitioned_by = ARRAY['p_bigint', 'p_varchar'])", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s VALUES (TINYINT '120', SMALLINT '32760', INTEGER '2147483640', BIGINT '9223372036854775800', REAL '123.340', DOUBLE '234.560', CAST(343.0 AS DECIMAL(10, 0)), CAST(345.670 AS DECIMAL(10, 5)), TIMESTAMP '2015-05-10 12:15:30', DATE '2015-05-08', 'p1 varchar', CAST('p1 varchar10' AS VARCHAR(10)), CAST('p1 char10' AS CHAR(10)), false, CAST('p1 binary' as VARBINARY), BIGINT '1', 'partition1'),(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, BIGINT '1', 'partition1')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s VALUES (TINYINT '99', SMALLINT '333', INTEGER '444', BIGINT '555', REAL '666.340', DOUBLE '777.560', CAST(888.0 AS DECIMAL(10, 0)), CAST(999.670 AS DECIMAL(10, 5)), TIMESTAMP '2015-05-10 12:45:30', DATE '2015-05-09', 'p2 varchar', CAST('p2 varchar10' AS VARCHAR(10)), CAST('p2 char10' AS CHAR(10)), true, CAST('p2 binary' as VARBINARY), BIGINT '2', 'partition2'),(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, BIGINT '2', 'partition2')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            String showStatsPartitionOne = String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_bigint = 1 AND p_varchar = 'partition1')", tableName);
            String showStatsPartitionTwo = String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_bigint = 2 AND p_varchar = 'partition2')", tableName);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 1.0, 0.5, null, "120", "120"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 1.0, 0.5, null, "32760", "32760"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 1.0, 0.5, null, "2147483640", "2147483640"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 1.0, 0.5, null, "9223372036854775807", "9223372036854775807"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 1.0, 0.5, null, "123.34", "123.34"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 1.0, 0.5, null, "234.56", "234.56"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 1.0, 0.5, null, "343.0", "343.0"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 1.0, 0.5, null, "345.67", "345.67"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 1.0, 0.5, null, "2015-05-08", "2015-05-08"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 10.0, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 10.0, 1.0, 0.5, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 9.0, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 9.0, null, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_bigint", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_varchar", 20.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})}));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 1.0, 0.5, null, "99", "99"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 1.0, 0.5, null, "333", "333"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 1.0, 0.5, null, "444", "444"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 1.0, 0.5, null, "555", "555"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 1.0, 0.5, null, "666.34", "666.34"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 1.0, 0.5, null, "777.56", "777.56"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 1.0, 0.5, null, "888.0", "888.0"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 1.0, 0.5, null, "999.67", "999.67"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 1.0, 0.5, null, "2015-05-09", "2015-05-09"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 10.0, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 10.0, 1.0, 0.5, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 9.0, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 9.0, null, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_bigint", null, 1.0, 0.0, null, "2", "2"}), QueryAssert.Row.row((Object[])new Object[]{"p_varchar", 20.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 2.0, null, null})}));
            QueryExecutor.query((String)String.format("INSERT INTO %s VALUES( TINYINT '119', SMALLINT '32759', INTEGER '2147483639', BIGINT '9223372036854775799', REAL '122.340', DOUBLE '233.560', CAST(342.0 AS DECIMAL(10, 0)), CAST(344.670 AS DECIMAL(10, 5)), TIMESTAMP '2015-05-10 12:15:29', DATE '2015-05-07', 'p1 varchar', CAST('p1 varchar10' AS VARCHAR(10)), CAST('p1 char10' AS CHAR(10)), true, CAST('p1 binary' as VARBINARY), BIGINT '1', 'partition1')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s VALUES( null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, BIGINT '1', 'partition1')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionOne, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 1.0, 0.5, null, "119", "120"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 1.0, 0.5, null, "32759", "32760"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 1.0, 0.5, null, "2147483639", "2147483640"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 1.0, 0.5, null, "9223372036854775807", "9223372036854775807"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 1.0, 0.5, null, "122.34", "123.34"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 1.0, 0.5, null, "233.56", "234.56"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 1.0, 0.5, null, "342.0", "343.0"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 1.0, 0.5, null, "344.67", "345.67"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 1.0, 0.5, null, "2015-05-07", "2015-05-08"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 20.0, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 20.0, 1.0, 0.5, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 18.0, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 2.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 18.0, null, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_bigint", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{"p_varchar", 40.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 4.0, null, null})}));
            QueryExecutor.query((String)String.format("INSERT INTO %s VALUES( TINYINT '100', SMALLINT '334', INTEGER '445', BIGINT '556', REAL '667.340', DOUBLE '778.560', CAST(889.0 AS DECIMAL(10, 0)), CAST(1000.670 AS DECIMAL(10, 5)), TIMESTAMP '2015-05-10 12:45:31', DATE '2015-05-10', CAST('p2 varchar' AS VARCHAR), CAST('p2 varchar10' AS VARCHAR(10)), CAST('p2 char10' AS CHAR(10)), true, CAST('p2 binary' as VARBINARY), BIGINT '2', 'partition2')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s VALUES( null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, BIGINT '2', 'partition2')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)showStatsPartitionTwo, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", null, 1.0, 0.5, null, "99", "100"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_smallint", null, 1.0, 0.5, null, "333", "334"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_int", null, 1.0, 0.5, null, "444", "445"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_bigint", null, 1.0, 0.5, null, "555", "556"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_float", null, 1.0, 0.5, null, "666.34", "667.34"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_double", null, 1.0, 0.5, null, "777.56", "778.56"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal", null, 1.0, 0.5, null, "888.0", "889.0"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_decimal_w_params", null, 1.0, 0.5, null, "999.67", "1000.67"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_timestamp", null, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_date", null, 1.0, 0.5, null, "2015-05-09", "2015-05-10"}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_string", 20.0, 1.0, 0.5, null, null, null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"c_varchar", 20.0, 1.0, 0.5, null, null, null}), (Object[])new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_char", 18.0, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", null, 1.0, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"c_binary", 18.0, null, 0.5, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_bigint", null, 1.0, 0.0, null, "2", "2"}), QueryAssert.Row.row((Object[])new Object[]{"p_varchar", 40.0, 1.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 4.0, null, null})}));
        }
        catch (Throwable throwable) {
            QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static void assertComputeTableStatisticsOnCreateTable(String sourceTableName, List<QueryAssert.Row> expectedStatistics) {
        String copiedTableName = "assert_compute_table_statistics_on_create_table_" + sourceTableName;
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutor.query((String)String.format("CREATE TABLE %s AS SELECT * FROM %s", copiedTableName, sourceTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(expectedStatistics);
        }
        catch (Throwable throwable) {
            QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static void assertComputeTableStatisticsOnInsert(String sourceTableName, List<QueryAssert.Row> expectedStatistics) {
        String copiedTableName = "assert_compute_table_statistics_on_insert_" + sourceTableName;
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutor.query((String)String.format("CREATE TABLE %s AS SELECT * FROM %s WITH NO DATA", copiedTableName, sourceTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(ALL_TYPES_EMPTY_TABLE_STATISTICS);
            QueryExecutor.query((String)String.format("INSERT INTO %s SELECT * FROM %s", copiedTableName, sourceTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SHOW STATS FOR " + copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(expectedStatistics);
        }
        catch (Throwable throwable) {
            QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutor.query((String)String.format("DROP TABLE IF EXISTS %s", copiedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static final class AllTypesTable
    implements RequirementsProvider {
        private AllTypesTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.mutableTable((TableDefinition)ALL_TYPES_TABLE, (String)TestHiveTableStatistics.ALL_TYPES_TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)ALL_TYPES_ALL_NULL_TABLE, (String)TestHiveTableStatistics.ALL_TYPES_ALL_NULL_TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.LOADED), TableRequirements.mutableTable((TableDefinition)ALL_TYPES_TABLE, (String)TestHiveTableStatistics.EMPTY_ALL_TYPES_TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED)});
        }
    }

    private static class NationPartitionedByVarcharTable
    implements RequirementsProvider {
        private NationPartitionedByVarcharTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.mutableTable((TableDefinition)HiveTableDefinition.from((HiveTableDefinition)HiveTableDefinitions.NATION_PARTITIONED_BY_VARCHAR_REGIONKEY).injectStats(false).build());
        }
    }

    private static class NationPartitionedByBigintTable
    implements RequirementsProvider {
        private NationPartitionedByBigintTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.mutableTable((TableDefinition)HiveTableDefinition.from((HiveTableDefinition)HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY).injectStats(false).build());
        }
    }

    private static class UnpartitionedNationTable
    implements RequirementsProvider {
        private UnpartitionedNationTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.mutableTable((TableDefinition)HiveTableDefinition.from((HiveTableDefinition)TpchTableDefinitions.NATION).injectStats(false).build());
        }
    }
}

