/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.presto.tests.utils.QueryExecutors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.prestodb.tempto.AfterTestWithContext;
import io.prestodb.tempto.BeforeTestWithContext;
import io.prestodb.tempto.ProductTest;
import io.prestodb.tempto.assertions.QueryAssert;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestRoles
extends ProductTest {
    private static final String ROLE1 = "role1";
    private static final String ROLE2 = "role2";
    private static final String ROLE3 = "role3";
    private static final Set<String> TEST_ROLES = ImmutableSet.of((Object)"role1", (Object)"role2", (Object)"role3");

    @BeforeTestWithContext
    public void setUp() {
        QueryExecutors.onPresto().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        this.cleanup();
    }

    @AfterTestWithContext
    public void tearDown() {
        this.cleanup();
    }

    public void cleanup() {
        Set<String> existentRoles = this.listRoles();
        for (String role : TEST_ROLES) {
            if (!existentRoles.contains(role)) continue;
            QueryExecutors.onHive().executeQuery(String.format("DROP ROLE %s", role), new QueryExecutor.QueryParam[0]);
        }
    }

    private Set<String> listRoles() {
        return (Set)QueryExecutors.onHive().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0]).rows().stream().map(Iterables::getOnlyElement).map(String.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testCreateRole() {
        QueryExecutors.onPresto().executeQuery(String.format("CREATE ROLE %s", ROLE1), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(this.listRoles()).contains((Object[])new String[]{ROLE1});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testDropRole() {
        QueryExecutors.onHive().executeQuery(String.format("CREATE ROLE %s", ROLE1), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(this.listRoles()).contains((Object[])new String[]{ROLE1});
        QueryExecutors.onPresto().executeQuery(String.format("DROP ROLE %s", ROLE1), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(this.listRoles()).doesNotContain((Object[])new String[]{ROLE1});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testListRoles() {
        QueryExecutors.onPresto().executeQuery(String.format("CREATE ROLE %s", ROLE1), new QueryExecutor.QueryParam[0]);
        QueryResult expected = QueryExecutors.onHive().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0]);
        QueryResult actual = QueryExecutors.onPresto().executeQuery("SELECT * FROM hive.information_schema.roles", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)actual.rows()).containsOnly((Object[])expected.rows().toArray(new List[0]));
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testCreateDuplicateRole() {
        QueryExecutors.onPresto().executeQuery(String.format("CREATE ROLE %s", ROLE1), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(String.format("CREATE ROLE %s", ROLE1), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Role '%s' already exists", ROLE1));
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testDropNonExistentRole() {
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(String.format("DROP ROLE %s", ROLE3), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Role '%s' does not exist", ROLE3));
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testAccessControl() {
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery(String.format("CREATE ROLE %s", ROLE3), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Cannot create role %s", ROLE3));
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery(String.format("DROP ROLE %s", ROLE3), new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Cannot drop role %s", ROLE3));
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.roles", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot select from table information_schema.roles");
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testPublicRoleIsGrantedToEveryone() {
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoBob().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "public", "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testAdminRoleIsGrantedToHdfs() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hdfs", "USER", "admin", "YES"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testGrantRoleToUser() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testGrantRoleToRole() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testGrantRoleWithAdminOption() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "YES"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "YES"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testGrantRoleMultipleTimes() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "YES"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "YES"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testRevokeRoleFromUser() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
        QueryExecutors.onPresto().executeQuery("REVOKE role1 FROM USER alice", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testRevokeRoleFromRole() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
        QueryExecutors.onPresto().executeQuery("REVOKE role2 FROM ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testRevokeRoleFromOwner() {
        try {
            TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "INSERT", "YES", null})));
            QueryExecutors.onPresto().executeQuery("REVOKE SELECT ON hive.default.test_table FROM USER alice", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table", "INSERT", "YES", null})));
        }
        finally {
            TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table", new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testDropGrantedRole() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
        QueryExecutors.onPresto().executeQuery("DROP ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testRevokeTransitiveRoleFromUser() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
        QueryExecutors.onPresto().executeQuery("REVOKE role1 FROM USER alice", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testRevokeTransitiveRoleFromRole() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role3", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role3 TO ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE2, "ROLE", ROLE3, "NO"})});
        QueryExecutors.onPresto().executeQuery("REVOKE role2 FROM ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testDropTransitiveRole() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role3", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role3 TO ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE2, "ROLE", ROLE3, "NO"})});
        QueryExecutors.onPresto().executeQuery("DROP ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testRevokeAdminOption() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "YES"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "YES"})});
        QueryExecutors.onPresto().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testRevokeMultipleTimes() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1 WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "YES"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "YES"})});
        QueryExecutors.onPresto().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("REVOKE ADMIN OPTION FOR role2 FROM ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"}), QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "NO"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1, "ROLE", ROLE2, "NO"})});
        QueryExecutors.onPresto().executeQuery("REVOKE role1 FROM USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("REVOKE role1 FROM USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("REVOKE role2 FROM ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("REVOKE role2 FROM ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.applicable_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "public", "NO"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testGrantRevokeRoleAccessControl() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot revoke roles [role1] from [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot revoke roles [role1] from [USER bob]");
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER alice", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot revoke roles [role1] from [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot revoke roles [role1] from [USER bob]");
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO ROLE role2 WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("GRANT role1 TO USER bob WITH ADMIN OPTION", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot grant roles [role1] to [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE role1 FROM USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot revoke roles [role1] from [USER bob]");
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("REVOKE ADMIN OPTION FOR role1 FROM USER bob", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot revoke roles [role1] from [USER bob]");
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testSetRole() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role3", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role3 TO ROLE role2", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("SET ROLE ALL", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1}), QueryAssert.Row.row((Object[])new Object[]{ROLE2}), QueryAssert.Row.row((Object[])new Object[]{ROLE3})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE NONE", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1}), QueryAssert.Row.row((Object[])new Object[]{ROLE2}), QueryAssert.Row.row((Object[])new Object[]{ROLE3})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE2}), QueryAssert.Row.row((Object[])new Object[]{ROLE3})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE role3", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE3})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testSetAdminRole() {
        QueryExecutors.onPresto().executeQuery("SET ROLE NONE", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"})});
        QueryExecutors.onPresto().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM hive.information_schema.enabled_roles", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testShowRoles() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"})});
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1})});
        QueryAssert.assertThat(() -> TestRoles.onPrestoAlice().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot show roles from catalog hive");
        QueryExecutors.onPresto().executeQuery("GRANT admin TO alice", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW ROLES", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testShowCurrentRoles() {
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW CURRENT ROLES", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"})});
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO alice", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW CURRENT ROLES", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1}), QueryAssert.Row.row((Object[])new Object[]{ROLE2})});
        TestRoles.onPrestoAlice().executeQuery("SET ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW CURRENT ROLES", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE2})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testShowRoleGrants() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW ROLE GRANTS", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"})});
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW ROLE GRANTS", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"})});
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO alice", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO role1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SHOW ROLE GRANTS", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{"admin"})});
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW ROLE GRANTS", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"public"}), QueryAssert.Row.row((Object[])new Object[]{ROLE1})});
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testSetRoleCreateDropSchema() {
        TestRoles.assertAdminExecute("CREATE SCHEMA hive.test_admin_schema");
        QueryExecutors.onPresto().executeQuery("DROP SCHEMA hive.test_admin_schema", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testAdminCanDropAnyTable() {
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.assertAdminExecute("DROP TABLE hive.default.test_table");
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testAdminCanRenameAnyTable() {
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.assertAdminExecute("ALTER TABLE hive.default.test_table RENAME TO hive.default.test_table_1");
        TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table_1", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testAdminCanAddColumnToAnyTable() {
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.assertAdminExecute("ALTER TABLE hive.default.test_table ADD COLUMN bar DATE");
        TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testAdminCanRenameColumnInAnyTable() {
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.assertAdminExecute("ALTER TABLE hive.default.test_table RENAME COLUMN foo TO bar");
        TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testAdminCanShowAllGrants() {
        try {
            TestRoles.onPrestoBob().executeQuery("CREATE TABLE hive.default.test_table_bob (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table_alice (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery("GRANT admin TO alice", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("SET ROLE ADMIN", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table_alice", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "INSERT", "YES", null})));
            QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table_bob", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "INSERT", "YES", null})));
            TestRoles.onPrestoAlice().executeQuery("GRANT SELECT ON hive.default.test_table_alice  TO bob WITH GRANT OPTION", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("GRANT INSERT ON hive.default.test_table_alice  TO bob", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table_alice", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "default", "test_table_alice", "INSERT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "bob", "USER", "hive", "default", "test_table_alice", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "bob", "USER", "hive", "default", "test_table_alice", "INSERT", "NO", null})));
        }
        finally {
            TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table_alice", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table_bob", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery("REVOKE admin FROM alice", new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testAdminCanShowGrantsOnlyFromCurrentSchema() {
        try {
            TestRoles.onPrestoBob().executeQuery("CREATE TABLE hive.default.test_table_bob (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery("CREATE SCHEMA hive.test", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery("GRANT admin TO alice", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("SET ROLE ADMIN", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.test.test_table_bob (foo BIGINT)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.default.test_table_bob", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "INSERT", "YES", null})));
            QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SHOW GRANTS ON hive.test.test_table_bob", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "INSERT", "YES", null})));
            QueryAssert.assertThat((QueryResult)TestRoles.onPrestoAlice().executeQuery("SELECT * FROM hive.information_schema.table_privileges where table_name = 'test_table_bob'", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"bob", "USER", "bob", "USER", "hive", "default", "test_table_bob", "INSERT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "SELECT", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "DELETE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "UPDATE", "YES", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", "alice", "USER", "hive", "test", "test_table_bob", "INSERT", "YES", null})));
        }
        finally {
            QueryExecutors.onPresto().executeQuery("DROP TABLE hive.default.test_table_bob", new QueryExecutor.QueryParam[0]);
            TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.test.test_table_bob", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery("DROP SCHEMA hive.test", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery("REVOKE admin FROM alice", new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"roles", "authorization", "profile_specific_tests"})
    public void testSetRoleTablePermissions() {
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role1", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role1 TO USER bob", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("GRANT role2 TO USER bob", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("CREATE TABLE hive.default.test_table (foo BIGINT)", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT SELECT ON hive.default.test_table TO ROLE role1", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoAlice().executeQuery("GRANT INSERT ON hive.default.test_table TO ROLE role2", new QueryExecutor.QueryParam[0]);
        String select = "SELECT * FROM hive.default.test_table";
        String insert = "INSERT INTO hive.default.test_table (foo) VALUES (1)";
        TestRoles.assertAdminExecute(select);
        TestRoles.assertAdminExecute(insert);
        TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "ROLE", "hive", "default", "test_table", "SELECT", "NO", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE2, "ROLE", "hive", "default", "test_table", "INSERT", "NO", null})));
        TestRoles.onPrestoBob().executeQuery("SET ROLE ALL", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "ROLE", "hive", "default", "test_table", "SELECT", "NO", null}), (Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE2, "ROLE", "hive", "default", "test_table", "INSERT", "NO", null})));
        TestRoles.onPrestoBob().executeQuery("SET ROLE NONE", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0])).failsWithMessage("Access Denied");
        QueryAssert.assertThat(() -> TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0])).failsWithMessage("Access Denied");
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of());
        TestRoles.onPrestoBob().executeQuery("SET ROLE role1", new QueryExecutor.QueryParam[0]);
        TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0])).failsWithMessage("Access Denied");
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE1, "ROLE", "hive", "default", "test_table", "SELECT", "NO", null})));
        TestRoles.onPrestoBob().executeQuery("SET ROLE role2", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> TestRoles.onPrestoBob().executeQuery(select, new QueryExecutor.QueryParam[0])).failsWithMessage("Access Denied");
        TestRoles.onPrestoBob().executeQuery(insert, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)TestRoles.onPrestoBob().executeQuery("SHOW GRANTS ON hive.default.test_table", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"alice", "USER", ROLE2, "ROLE", "hive", "default", "test_table", "INSERT", "NO", null})));
        TestRoles.onPrestoAlice().executeQuery("DROP TABLE hive.default.test_table", new QueryExecutor.QueryParam[0]);
    }

    private static void assertAdminExecute(String query) {
        QueryExecutors.onPresto().executeQuery("SET ROLE NONE", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(query, new QueryExecutor.QueryParam[0])).failsWithMessage("Access Denied");
        QueryExecutors.onPresto().executeQuery("SET ROLE ALL", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(query, new QueryExecutor.QueryParam[0])).failsWithMessage("Access Denied");
        QueryExecutors.onPresto().executeQuery("SET ROLE admin", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery(query, new QueryExecutor.QueryParam[0]);
    }

    private static QueryExecutor onPrestoAlice() {
        return QueryExecutors.connectToPresto("alice@presto");
    }

    private static QueryExecutor onPrestoBob() {
        return QueryExecutors.connectToPresto("bob@presto");
    }
}

