/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive;

import com.facebook.presto.tests.hive.HivePartitioningTest;
import com.facebook.presto.tests.hive.HiveTableDefinitions;
import io.prestodb.tempto.Requirement;
import io.prestodb.tempto.Requirements;
import io.prestodb.tempto.RequirementsProvider;
import io.prestodb.tempto.configuration.Configuration;
import io.prestodb.tempto.fulfillment.table.MutableTableRequirement;
import io.prestodb.tempto.fulfillment.table.MutableTablesState;
import io.prestodb.tempto.fulfillment.table.TableDefinition;
import io.prestodb.tempto.fulfillment.table.TableRequirements;
import io.prestodb.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestodb.tempto.query.QueryExecutor;
import io.prestodb.tempto.query.QueryResult;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTablePartitioningInsertInto
extends HivePartitioningTest
implements RequirementsProvider {
    private static final String TARGET_NATION_NAME = "target_nation_test";

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.mutableTable((TableDefinition)HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY), TableRequirements.mutableTable((TableDefinition)TpchTableDefinitions.NATION, (String)TARGET_NATION_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED)});
    }

    @Test(groups={"smoke"})
    public void selectFromPartitionedNation() throws Exception {
        this.testQuerySplitsNumber("p_nationkey < 40", 3);
        this.testQuerySplitsNumber("p_regionkey = 42", 0);
        this.testQuerySplitsNumber("p_regionkey = 2 AND p_nationkey < 40", 1);
        this.testQuerySplitsNumber("p_regionkey = 2 AND p_nationkey < 40 or p_regionkey = 3", 2);
        this.testQuerySplitsNumber("p_regionkey = 2 OR p_nationkey < 40", 3);
        this.testQuerySplitsNumber("p_regionkey <= 2", 2);
        this.testQuerySplitsNumber("p_regionkey <= 1 OR p_regionkey >= 3", 2);
    }

    private void testQuerySplitsNumber(String condition, int expectedProcessedSplits) throws Exception {
        String partitionedNation = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getTableHandle()).getNameInDatabase();
        String targetNation = MutableTablesState.mutableTablesState().get(TARGET_NATION_NAME).getNameInDatabase();
        String query = String.format("INSERT INTO %s SELECT p_nationkey, p_name, p_regionkey, p_comment FROM %s WHERE %s", targetNation, partitionedNation, condition);
        QueryResult queryResult = QueryExecutor.query((String)query, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        long processedLinesCount = this.getProcessedLinesCount(query, queryResult);
        int expectedLinesCount = expectedProcessedSplits * 5;
        Assertions.assertThat((long)processedLinesCount).isEqualTo((long)expectedLinesCount);
    }
}

