/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tests.hive.util;

import com.facebook.presto.tests.utils.QueryExecutors;
import io.prestodb.tempto.query.QueryExecutor;
import java.security.SecureRandom;
import java.util.Objects;

public class TemporaryHiveTable
implements AutoCloseable {
    private static final SecureRandom random = new SecureRandom();
    private static final int RANDOM_SUFFIX_LENGTH = 12;
    private final String name;

    public static TemporaryHiveTable temporaryHiveTable(String tableName) {
        return new TemporaryHiveTable(tableName);
    }

    public static String randomTableSuffix() {
        String randomSuffix = Long.toString(Math.abs(random.nextLong()), 36);
        return randomSuffix.substring(0, Math.min(12, randomSuffix.length()));
    }

    private TemporaryHiveTable(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public String getName() {
        return this.name;
    }

    public void closeQuietly(Exception e) {
        block7: {
            try {
                TemporaryHiveTable justCloseIt = this;
                Throwable throwable = null;
                if (justCloseIt != null) {
                    if (throwable != null) {
                        try {
                            justCloseIt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        justCloseIt.close();
                    }
                }
            }
            catch (Exception closeException) {
                if (e == closeException) break block7;
                e.addSuppressed(closeException);
            }
        }
    }

    @Override
    public void close() {
        QueryExecutors.onHive().executeQuery("DROP TABLE " + this.name, new QueryExecutor.QueryParam[0]);
    }
}

